/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageBlockType;
import com.azure.ai.agents.persistent.models.MessageInputImageFileBlock;
import com.azure.ai.agents.persistent.models.MessageInputImageUrlBlock;
import com.azure.ai.agents.persistent.models.MessageInputTextBlock;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class MessageInputContentBlock
implements JsonSerializable<MessageInputContentBlock> {
    private MessageBlockType type = MessageBlockType.fromString("MessageInputContentBlock");

    public MessageBlockType getType() {
        return this.type;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static MessageInputContentBlock fromJson(JsonReader jsonReader) throws IOException {
        return (MessageInputContentBlock)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                MessageInputContentBlock messageInputContentBlock;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("text".equals(discriminatorValue)) {
                    messageInputContentBlock = MessageInputTextBlock.fromJson(readerToUse.reset());
                    return messageInputContentBlock;
                }
                if ("image_file".equals(discriminatorValue)) {
                    messageInputContentBlock = MessageInputImageFileBlock.fromJson(readerToUse.reset());
                    return messageInputContentBlock;
                }
                if ("image_url".equals(discriminatorValue)) {
                    messageInputContentBlock = MessageInputImageUrlBlock.fromJson(readerToUse.reset());
                    return messageInputContentBlock;
                }
                messageInputContentBlock = MessageInputContentBlock.fromJsonKnownDiscriminator(readerToUse.reset());
                return messageInputContentBlock;
            }
        });
    }

    static MessageInputContentBlock fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (MessageInputContentBlock)jsonReader.readObject(reader -> {
            MessageInputContentBlock deserializedMessageInputContentBlock = new MessageInputContentBlock();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedMessageInputContentBlock.type = MessageBlockType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMessageInputContentBlock;
        });
    }
}

