/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.ImageDetailLevel;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageImageFileParam
implements JsonSerializable<MessageImageFileParam> {
    private final String fileId;
    private ImageDetailLevel detail;

    public MessageImageFileParam(String fileId) {
        this.fileId = fileId;
    }

    public String getFileId() {
        return this.fileId;
    }

    public ImageDetailLevel getDetail() {
        return this.detail;
    }

    public MessageImageFileParam setDetail(ImageDetailLevel detail) {
        this.detail = detail;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeStringField("detail", this.detail == null ? null : this.detail.toString());
        return jsonWriter.writeEndObject();
    }

    public static MessageImageFileParam fromJson(JsonReader jsonReader) throws IOException {
        return (MessageImageFileParam)jsonReader.readObject(reader -> {
            String fileId = null;
            ImageDetailLevel detail = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                    continue;
                }
                if ("detail".equals(fieldName)) {
                    detail = ImageDetailLevel.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            MessageImageFileParam deserializedMessageImageFileParam = new MessageImageFileParam(fileId);
            deserializedMessageImageFileParam.detail = detail;
            return deserializedMessageImageFileParam;
        });
    }
}

