/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageDeltaTextAnnotation;
import com.azure.ai.agents.persistent.models.MessageDeltaTextFilePathAnnotationObject;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageDeltaTextFilePathAnnotation
extends MessageDeltaTextAnnotation {
    private String type = "file_path";
    private MessageDeltaTextFilePathAnnotationObject filePath;
    private Integer startIndex;
    private Integer endIndex;
    private String text;

    private MessageDeltaTextFilePathAnnotation(int index) {
        super(index);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageDeltaTextFilePathAnnotationObject getFilePath() {
        return this.filePath;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.getIndex());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("file_path", (JsonSerializable)this.filePath);
        jsonWriter.writeNumberField("start_index", (Number)this.startIndex);
        jsonWriter.writeNumberField("end_index", (Number)this.endIndex);
        jsonWriter.writeStringField("text", this.text);
        return jsonWriter.writeEndObject();
    }

    public static MessageDeltaTextFilePathAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return (MessageDeltaTextFilePathAnnotation)jsonReader.readObject(reader -> {
            int index = 0;
            String type = "file_path";
            MessageDeltaTextFilePathAnnotationObject filePath = null;
            Integer startIndex = null;
            Integer endIndex = null;
            String text = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("file_path".equals(fieldName)) {
                    filePath = MessageDeltaTextFilePathAnnotationObject.fromJson(reader);
                    continue;
                }
                if ("start_index".equals(fieldName)) {
                    startIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("end_index".equals(fieldName)) {
                    endIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            MessageDeltaTextFilePathAnnotation deserializedMessageDeltaTextFilePathAnnotation = new MessageDeltaTextFilePathAnnotation(index);
            deserializedMessageDeltaTextFilePathAnnotation.type = type;
            deserializedMessageDeltaTextFilePathAnnotation.filePath = filePath;
            deserializedMessageDeltaTextFilePathAnnotation.startIndex = startIndex;
            deserializedMessageDeltaTextFilePathAnnotation.endIndex = endIndex;
            deserializedMessageDeltaTextFilePathAnnotation.text = text;
            return deserializedMessageDeltaTextFilePathAnnotation;
        });
    }
}

