/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.MessageDeltaTextAnnotation;
import com.azure.ai.agents.persistent.models.MessageDeltaTextFileCitationAnnotationObject;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageDeltaTextFileCitationAnnotation
extends MessageDeltaTextAnnotation {
    private String type = "file_citation";
    private MessageDeltaTextFileCitationAnnotationObject fileCitation;
    private String text;
    private Integer startIndex;
    private Integer endIndex;

    private MessageDeltaTextFileCitationAnnotation(int index) {
        super(index);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageDeltaTextFileCitationAnnotationObject getFileCitation() {
        return this.fileCitation;
    }

    public String getText() {
        return this.text;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.getIndex());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("file_citation", (JsonSerializable)this.fileCitation);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeNumberField("start_index", (Number)this.startIndex);
        jsonWriter.writeNumberField("end_index", (Number)this.endIndex);
        return jsonWriter.writeEndObject();
    }

    public static MessageDeltaTextFileCitationAnnotation fromJson(JsonReader jsonReader) throws IOException {
        return (MessageDeltaTextFileCitationAnnotation)jsonReader.readObject(reader -> {
            int index = 0;
            String type = "file_citation";
            MessageDeltaTextFileCitationAnnotationObject fileCitation = null;
            String text = null;
            Integer startIndex = null;
            Integer endIndex = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("file_citation".equals(fieldName)) {
                    fileCitation = MessageDeltaTextFileCitationAnnotationObject.fromJson(reader);
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("start_index".equals(fieldName)) {
                    startIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("end_index".equals(fieldName)) {
                    endIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            MessageDeltaTextFileCitationAnnotation deserializedMessageDeltaTextFileCitationAnnotation = new MessageDeltaTextFileCitationAnnotation(index);
            deserializedMessageDeltaTextFileCitationAnnotation.type = type;
            deserializedMessageDeltaTextFileCitationAnnotation.fileCitation = fileCitation;
            deserializedMessageDeltaTextFileCitationAnnotation.text = text;
            deserializedMessageDeltaTextFileCitationAnnotation.startIndex = startIndex;
            deserializedMessageDeltaTextFileCitationAnnotation.endIndex = endIndex;
            return deserializedMessageDeltaTextFileCitationAnnotation;
        });
    }
}

