/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.VectorStoreDataSource;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class MessageAttachment
implements JsonSerializable<MessageAttachment> {
    private String fileId;
    private VectorStoreDataSource dataSource;
    private final List<BinaryData> tools;

    public MessageAttachment(List<BinaryData> tools) {
        this.tools = tools;
    }

    public String getFileId() {
        return this.fileId;
    }

    public MessageAttachment setFileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public VectorStoreDataSource getDataSource() {
        return this.dataSource;
    }

    public MessageAttachment setDataSource(VectorStoreDataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public List<BinaryData> getTools() {
        return this.tools;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeUntyped(element == null ? null : element.toObject(Object.class)));
        jsonWriter.writeStringField("file_id", this.fileId);
        jsonWriter.writeJsonField("data_source", (JsonSerializable)this.dataSource);
        return jsonWriter.writeEndObject();
    }

    public static MessageAttachment fromJson(JsonReader jsonReader) throws IOException {
        return (MessageAttachment)jsonReader.readObject(reader -> {
            List tools = null;
            String fileId = null;
            VectorStoreDataSource dataSource = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> (BinaryData)reader1.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped())));
                    continue;
                }
                if ("file_id".equals(fieldName)) {
                    fileId = reader.getString();
                    continue;
                }
                if ("data_source".equals(fieldName)) {
                    dataSource = VectorStoreDataSource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            MessageAttachment deserializedMessageAttachment = new MessageAttachment(tools);
            deserializedMessageAttachment.fileId = fileId;
            deserializedMessageAttachment.dataSource = dataSource;
            return deserializedMessageAttachment;
        });
    }
}

