/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.VectorStoreConfigurations;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class FileSearchToolResource
implements JsonSerializable<FileSearchToolResource> {
    private List<String> vectorStoreIds;
    private List<VectorStoreConfigurations> vectorStores;

    public List<String> getVectorStoreIds() {
        return this.vectorStoreIds;
    }

    public FileSearchToolResource setVectorStoreIds(List<String> vectorStoreIds) {
        this.vectorStoreIds = vectorStoreIds;
        return this;
    }

    public List<VectorStoreConfigurations> getVectorStores() {
        return this.vectorStores;
    }

    public FileSearchToolResource setVectorStores(List<VectorStoreConfigurations> vectorStores) {
        this.vectorStores = vectorStores;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vector_store_ids", this.vectorStoreIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("vector_stores", this.vectorStores, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FileSearchToolResource fromJson(JsonReader jsonReader) throws IOException {
        return (FileSearchToolResource)jsonReader.readObject(reader -> {
            FileSearchToolResource deserializedFileSearchToolResource = new FileSearchToolResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vector_store_ids".equals(fieldName)) {
                    List vectorStoreIds;
                    deserializedFileSearchToolResource.vectorStoreIds = vectorStoreIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("vector_stores".equals(fieldName)) {
                    List vectorStores;
                    deserializedFileSearchToolResource.vectorStores = vectorStores = reader.readArray(reader1 -> VectorStoreConfigurations.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileSearchToolResource;
        });
    }
}

