/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FileSearchRankingOptions
implements JsonSerializable<FileSearchRankingOptions> {
    private final String ranker;
    private final double scoreThreshold;

    public FileSearchRankingOptions(String ranker, double scoreThreshold) {
        this.ranker = ranker;
        this.scoreThreshold = scoreThreshold;
    }

    public String getRanker() {
        return this.ranker;
    }

    public double getScoreThreshold() {
        return this.scoreThreshold;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ranker", this.ranker);
        jsonWriter.writeDoubleField("score_threshold", this.scoreThreshold);
        return jsonWriter.writeEndObject();
    }

    public static FileSearchRankingOptions fromJson(JsonReader jsonReader) throws IOException {
        return (FileSearchRankingOptions)jsonReader.readObject(reader -> {
            String ranker = null;
            double scoreThreshold = 0.0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ranker".equals(fieldName)) {
                    ranker = reader.getString();
                    continue;
                }
                if ("score_threshold".equals(fieldName)) {
                    scoreThreshold = reader.getDouble();
                    continue;
                }
                reader.skipChildren();
            }
            return new FileSearchRankingOptions(ranker, scoreThreshold);
        });
    }
}

