/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.ConnectedAgentDetails;
import com.azure.ai.agents.persistent.models.ToolDefinition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ConnectedAgentToolDefinition
extends ToolDefinition {
    private String type = "connected_agent";
    private final ConnectedAgentDetails connectedAgent;

    public ConnectedAgentToolDefinition(ConnectedAgentDetails connectedAgent) {
        this.connectedAgent = connectedAgent;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public ConnectedAgentDetails getConnectedAgent() {
        return this.connectedAgent;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("connected_agent", (JsonSerializable)this.connectedAgent);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static ConnectedAgentToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectedAgentToolDefinition)jsonReader.readObject(reader -> {
            ConnectedAgentDetails connectedAgent = null;
            String type = "connected_agent";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connected_agent".equals(fieldName)) {
                    connectedAgent = ConnectedAgentDetails.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ConnectedAgentToolDefinition deserializedConnectedAgentToolDefinition = new ConnectedAgentToolDefinition(connectedAgent);
            deserializedConnectedAgentToolDefinition.type = type;
            return deserializedConnectedAgentToolDefinition;
        });
    }
}

