/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.AzureFunctionDefinition;
import com.azure.ai.agents.persistent.models.ToolDefinition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureFunctionToolDefinition
extends ToolDefinition {
    private String type = "azure_function";
    private final AzureFunctionDefinition azureFunction;

    public AzureFunctionToolDefinition(AzureFunctionDefinition azureFunction) {
        this.azureFunction = azureFunction;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public AzureFunctionDefinition getAzureFunction() {
        return this.azureFunction;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("azure_function", (JsonSerializable)this.azureFunction);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static AzureFunctionToolDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFunctionToolDefinition)jsonReader.readObject(reader -> {
            AzureFunctionDefinition azureFunction = null;
            String type = "azure_function";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("azure_function".equals(fieldName)) {
                    azureFunction = AzureFunctionDefinition.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            AzureFunctionToolDefinition deserializedAzureFunctionToolDefinition = new AzureFunctionToolDefinition(azureFunction);
            deserializedAzureFunctionToolDefinition.type = type;
            return deserializedAzureFunctionToolDefinition;
        });
    }
}

