/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureFunctionStorageQueue
implements JsonSerializable<AzureFunctionStorageQueue> {
    private final String storageServiceEndpoint;
    private final String queueName;

    public AzureFunctionStorageQueue(String storageServiceEndpoint, String queueName) {
        this.storageServiceEndpoint = storageServiceEndpoint;
        this.queueName = queueName;
    }

    public String getStorageServiceEndpoint() {
        return this.storageServiceEndpoint;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("queue_service_endpoint", this.storageServiceEndpoint);
        jsonWriter.writeStringField("queue_name", this.queueName);
        return jsonWriter.writeEndObject();
    }

    public static AzureFunctionStorageQueue fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFunctionStorageQueue)jsonReader.readObject(reader -> {
            String storageServiceEndpoint = null;
            String queueName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("queue_service_endpoint".equals(fieldName)) {
                    storageServiceEndpoint = reader.getString();
                    continue;
                }
                if ("queue_name".equals(fieldName)) {
                    queueName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new AzureFunctionStorageQueue(storageServiceEndpoint, queueName);
        });
    }
}

