/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.models;

import com.azure.ai.agents.persistent.models.AzureFunctionBinding;
import com.azure.ai.agents.persistent.models.FunctionDefinition;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureFunctionDefinition
implements JsonSerializable<AzureFunctionDefinition> {
    private final FunctionDefinition function;
    private final AzureFunctionBinding inputBinding;
    private final AzureFunctionBinding outputBinding;

    public AzureFunctionDefinition(FunctionDefinition function, AzureFunctionBinding inputBinding, AzureFunctionBinding outputBinding) {
        this.function = function;
        this.inputBinding = inputBinding;
        this.outputBinding = outputBinding;
    }

    public FunctionDefinition getFunction() {
        return this.function;
    }

    public AzureFunctionBinding getInputBinding() {
        return this.inputBinding;
    }

    public AzureFunctionBinding getOutputBinding() {
        return this.outputBinding;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("function", (JsonSerializable)this.function);
        jsonWriter.writeJsonField("input_binding", (JsonSerializable)this.inputBinding);
        jsonWriter.writeJsonField("output_binding", (JsonSerializable)this.outputBinding);
        return jsonWriter.writeEndObject();
    }

    public static AzureFunctionDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFunctionDefinition)jsonReader.readObject(reader -> {
            FunctionDefinition function = null;
            AzureFunctionBinding inputBinding = null;
            AzureFunctionBinding outputBinding = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("function".equals(fieldName)) {
                    function = FunctionDefinition.fromJson(reader);
                    continue;
                }
                if ("input_binding".equals(fieldName)) {
                    inputBinding = AzureFunctionBinding.fromJson(reader);
                    continue;
                }
                if ("output_binding".equals(fieldName)) {
                    outputBinding = AzureFunctionBinding.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return new AzureFunctionDefinition(function, inputBinding, outputBinding);
        });
    }
}

