/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent.implementation.models;

import com.azure.ai.agents.persistent.models.PersistentAgentThreadCreationOptions;
import com.azure.ai.agents.persistent.models.ToolDefinition;
import com.azure.ai.agents.persistent.models.ToolResources;
import com.azure.ai.agents.persistent.models.TruncationObject;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CreateThreadAndRunRequest
implements JsonSerializable<CreateThreadAndRunRequest> {
    private final String assistantId;
    private PersistentAgentThreadCreationOptions thread;
    private String model;
    private String instructions;
    private List<ToolDefinition> tools;
    private ToolResources toolResources;
    private Boolean stream;
    private Double temperature;
    private Double topP;
    private Integer maxPromptTokens;
    private Integer maxCompletionTokens;
    private TruncationObject truncationStrategy;
    private BinaryData toolChoice;
    private BinaryData responseFormat;
    private Boolean parallelToolCalls;
    private Map<String, String> metadata;

    public CreateThreadAndRunRequest(String assistantId) {
        this.assistantId = assistantId;
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public PersistentAgentThreadCreationOptions getThread() {
        return this.thread;
    }

    public CreateThreadAndRunRequest setThread(PersistentAgentThreadCreationOptions thread) {
        this.thread = thread;
        return this;
    }

    public String getModel() {
        return this.model;
    }

    public CreateThreadAndRunRequest setModel(String model) {
        this.model = model;
        return this;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public CreateThreadAndRunRequest setInstructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    public List<ToolDefinition> getTools() {
        return this.tools;
    }

    public CreateThreadAndRunRequest setTools(List<ToolDefinition> tools) {
        this.tools = tools;
        return this;
    }

    public ToolResources getToolResources() {
        return this.toolResources;
    }

    public CreateThreadAndRunRequest setToolResources(ToolResources toolResources) {
        this.toolResources = toolResources;
        return this;
    }

    public Boolean isStream() {
        return this.stream;
    }

    public CreateThreadAndRunRequest setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public CreateThreadAndRunRequest setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public CreateThreadAndRunRequest setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public Integer getMaxPromptTokens() {
        return this.maxPromptTokens;
    }

    public CreateThreadAndRunRequest setMaxPromptTokens(Integer maxPromptTokens) {
        this.maxPromptTokens = maxPromptTokens;
        return this;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public CreateThreadAndRunRequest setMaxCompletionTokens(Integer maxCompletionTokens) {
        this.maxCompletionTokens = maxCompletionTokens;
        return this;
    }

    public TruncationObject getTruncationStrategy() {
        return this.truncationStrategy;
    }

    public CreateThreadAndRunRequest setTruncationStrategy(TruncationObject truncationStrategy) {
        this.truncationStrategy = truncationStrategy;
        return this;
    }

    public BinaryData getToolChoice() {
        return this.toolChoice;
    }

    public CreateThreadAndRunRequest setToolChoice(BinaryData toolChoice) {
        this.toolChoice = toolChoice;
        return this;
    }

    public BinaryData getResponseFormat() {
        return this.responseFormat;
    }

    public CreateThreadAndRunRequest setResponseFormat(BinaryData responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    public Boolean isParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public CreateThreadAndRunRequest setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CreateThreadAndRunRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("assistant_id", this.assistantId);
        jsonWriter.writeJsonField("thread", (JsonSerializable)this.thread);
        jsonWriter.writeStringField("model", this.model);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("tool_resources", (JsonSerializable)this.toolResources);
        jsonWriter.writeBooleanField("stream", this.stream);
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        jsonWriter.writeNumberField("max_prompt_tokens", (Number)this.maxPromptTokens);
        jsonWriter.writeNumberField("max_completion_tokens", (Number)this.maxCompletionTokens);
        jsonWriter.writeJsonField("truncation_strategy", (JsonSerializable)this.truncationStrategy);
        if (this.toolChoice != null) {
            jsonWriter.writeFieldName("tool_choice");
            this.toolChoice.writeTo(jsonWriter);
        }
        if (this.responseFormat != null) {
            jsonWriter.writeFieldName("response_format");
            this.responseFormat.writeTo(jsonWriter);
        }
        jsonWriter.writeBooleanField("parallel_tool_calls", this.parallelToolCalls);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CreateThreadAndRunRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CreateThreadAndRunRequest)jsonReader.readObject(reader -> {
            String assistantId = null;
            PersistentAgentThreadCreationOptions thread = null;
            String model = null;
            String instructions = null;
            List tools = null;
            ToolResources toolResources = null;
            Boolean stream = null;
            Double temperature = null;
            Double topP = null;
            Integer maxPromptTokens = null;
            Integer maxCompletionTokens = null;
            TruncationObject truncationStrategy = null;
            BinaryData toolChoice = null;
            BinaryData responseFormat = null;
            Boolean parallelToolCalls = null;
            Map metadata = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("assistant_id".equals(fieldName)) {
                    assistantId = reader.getString();
                    continue;
                }
                if ("thread".equals(fieldName)) {
                    thread = PersistentAgentThreadCreationOptions.fromJson(reader);
                    continue;
                }
                if ("model".equals(fieldName)) {
                    model = reader.getString();
                    continue;
                }
                if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ToolDefinition.fromJson(reader1));
                    continue;
                }
                if ("tool_resources".equals(fieldName)) {
                    toolResources = ToolResources.fromJson(reader);
                    continue;
                }
                if ("stream".equals(fieldName)) {
                    stream = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("max_prompt_tokens".equals(fieldName)) {
                    maxPromptTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("max_completion_tokens".equals(fieldName)) {
                    maxCompletionTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("truncation_strategy".equals(fieldName)) {
                    truncationStrategy = TruncationObject.fromJson(reader);
                    continue;
                }
                if ("tool_choice".equals(fieldName)) {
                    toolChoice = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("response_format".equals(fieldName)) {
                    responseFormat = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("parallel_tool_calls".equals(fieldName)) {
                    parallelToolCalls = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            CreateThreadAndRunRequest deserializedCreateThreadAndRunRequest = new CreateThreadAndRunRequest(assistantId);
            deserializedCreateThreadAndRunRequest.thread = thread;
            deserializedCreateThreadAndRunRequest.model = model;
            deserializedCreateThreadAndRunRequest.instructions = instructions;
            deserializedCreateThreadAndRunRequest.tools = tools;
            deserializedCreateThreadAndRunRequest.toolResources = toolResources;
            deserializedCreateThreadAndRunRequest.stream = stream;
            deserializedCreateThreadAndRunRequest.temperature = temperature;
            deserializedCreateThreadAndRunRequest.topP = topP;
            deserializedCreateThreadAndRunRequest.maxPromptTokens = maxPromptTokens;
            deserializedCreateThreadAndRunRequest.maxCompletionTokens = maxCompletionTokens;
            deserializedCreateThreadAndRunRequest.truncationStrategy = truncationStrategy;
            deserializedCreateThreadAndRunRequest.toolChoice = toolChoice;
            deserializedCreateThreadAndRunRequest.responseFormat = responseFormat;
            deserializedCreateThreadAndRunRequest.parallelToolCalls = parallelToolCalls;
            deserializedCreateThreadAndRunRequest.metadata = metadata;
            return deserializedCreateThreadAndRunRequest;
        });
    }
}

