/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.ThreadsImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateThreadRequest;
import com.azure.ai.agents.persistent.implementation.models.ThreadDeletionStatus;
import com.azure.ai.agents.persistent.implementation.models.UpdateThreadRequest;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.PersistentAgentThread;
import com.azure.ai.agents.persistent.models.ThreadMessageOptions;
import com.azure.ai.agents.persistent.models.ToolResources;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=PersistentAgentsClientBuilder.class, isAsync=true)
public final class ThreadsAsyncClient {
    private final ThreadsImpl serviceClient;

    ThreadsAsyncClient(ThreadsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createThreadWithResponse(BinaryData createThreadRequest, RequestOptions requestOptions) {
        return this.serviceClient.createThreadWithResponseAsync(createThreadRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listThreads(RequestOptions requestOptions) {
        return this.serviceClient.listThreadsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getThreadWithResponse(String threadId, RequestOptions requestOptions) {
        return this.serviceClient.getThreadWithResponseAsync(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateThreadWithResponse(String threadId, BinaryData updateThreadRequest, RequestOptions requestOptions) {
        return this.serviceClient.updateThreadWithResponseAsync(threadId, updateThreadRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PersistentAgentThread> createThread(List<ThreadMessageOptions> messages, ToolResources toolResources, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        CreateThreadRequest createThreadRequestObj = new CreateThreadRequest().setMessages(messages).setToolResources(toolResources).setMetadata(metadata);
        BinaryData createThreadRequest = BinaryData.fromObject((Object)createThreadRequestObj);
        return this.createThreadWithResponse(createThreadRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (PersistentAgentThread)protocolMethodData.toObject(PersistentAgentThread.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PersistentAgentThread> createThread() {
        RequestOptions requestOptions = new RequestOptions();
        CreateThreadRequest createThreadRequestObj = new CreateThreadRequest();
        BinaryData createThreadRequest = BinaryData.fromObject((Object)createThreadRequestObj);
        return this.createThreadWithResponse(createThreadRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (PersistentAgentThread)protocolMethodData.toObject(PersistentAgentThread.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PersistentAgentThread> listThreads(Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listThreads(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (PersistentAgentThread)protocolMethodData.toObject(PersistentAgentThread.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PersistentAgentThread> listThreads() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listThreads(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (PersistentAgentThread)protocolMethodData.toObject(PersistentAgentThread.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PersistentAgentThread> getThread(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getThreadWithResponse(threadId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (PersistentAgentThread)protocolMethodData.toObject(PersistentAgentThread.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PersistentAgentThread> updateThread(String threadId, ToolResources toolResources, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateThreadRequest updateThreadRequestObj = new UpdateThreadRequest().setToolResources(toolResources).setMetadata(metadata);
        BinaryData updateThreadRequest = BinaryData.fromObject((Object)updateThreadRequestObj);
        return this.updateThreadWithResponse(threadId, updateThreadRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (PersistentAgentThread)protocolMethodData.toObject(PersistentAgentThread.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PersistentAgentThread> updateThread(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateThreadRequest updateThreadRequestObj = new UpdateThreadRequest();
        BinaryData updateThreadRequest = BinaryData.fromObject((Object)updateThreadRequestObj);
        return this.updateThreadWithResponse(threadId, updateThreadRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (PersistentAgentThread)protocolMethodData.toObject(PersistentAgentThread.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> deleteThreadInternalWithResponse(String threadId, RequestOptions requestOptions) {
        return this.serviceClient.deleteThreadInternalWithResponseAsync(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<ThreadDeletionStatus> deleteThreadInternal(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteThreadInternalWithResponse(threadId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadDeletionStatus)protocolMethodData.toObject(ThreadDeletionStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteThread(String threadId) {
        Mono<ThreadDeletionStatus> deletionStatusMono = this.deleteThreadInternal(threadId);
        return deletionStatusMono.flatMap(deletionStatus -> {
            if (deletionStatus == null || !deletionStatus.isDeleted()) {
                return Mono.error((Throwable)new RuntimeException("Thread with ID '" + threadId + "' could not be deleted."));
            }
            return Mono.empty();
        });
    }
}

