/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.RunsImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateRunRequest;
import com.azure.ai.agents.persistent.implementation.models.SubmitToolOutputsToRunRequest;
import com.azure.ai.agents.persistent.implementation.models.UpdateRunRequest;
import com.azure.ai.agents.persistent.models.CreateRunOptions;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.PersistentAgentServerSentEvents;
import com.azure.ai.agents.persistent.models.RunAdditionalFieldList;
import com.azure.ai.agents.persistent.models.RunStep;
import com.azure.ai.agents.persistent.models.StreamUpdate;
import com.azure.ai.agents.persistent.models.ThreadRun;
import com.azure.ai.agents.persistent.models.ToolOutput;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import reactor.core.publisher.Flux;

@ServiceClient(builder=PersistentAgentsClientBuilder.class)
public final class RunsClient {
    private final ClientLogger logger = new ClientLogger(RunsClient.class);
    private final RunsImpl serviceClient;

    RunsClient(RunsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> createRunWithResponse(String threadId, BinaryData createRunRequest, RequestOptions requestOptions) {
        return this.serviceClient.createRunWithResponse(threadId, createRunRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listRuns(String threadId, RequestOptions requestOptions) {
        return this.serviceClient.listRuns(threadId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        return this.serviceClient.getRunWithResponse(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> updateRunWithResponse(String threadId, String runId, BinaryData updateRunRequest, RequestOptions requestOptions) {
        return this.serviceClient.updateRunWithResponse(threadId, runId, updateRunRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> submitToolOutputsToRunWithResponse(String threadId, String runId, BinaryData submitToolOutputsToRunRequest, RequestOptions requestOptions) {
        return this.serviceClient.submitToolOutputsToRunWithResponse(threadId, runId, submitToolOutputsToRunRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> cancelRunWithResponse(String threadId, String runId, RequestOptions requestOptions) {
        return this.serviceClient.cancelRunWithResponse(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getRunStepWithResponse(String threadId, String runId, String stepId, RequestOptions requestOptions) {
        return this.serviceClient.getRunStepWithResponse(threadId, runId, stepId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listRunSteps(String threadId, String runId, RequestOptions requestOptions) {
        return this.serviceClient.listRunSteps(threadId, runId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun createRun(CreateRunOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        String threadId = options.getThreadId();
        List<RunAdditionalFieldList> include = options.getInclude();
        CreateRunRequest createRunRequestObj = new CreateRunRequest(options.getAssistantId()).setModel(options.getModel()).setInstructions(options.getInstructions()).setAdditionalInstructions(options.getAdditionalInstructions()).setAdditionalMessages(options.getAdditionalMessages()).setTools(options.getTools()).setStream(options.isStream()).setTemperature(options.getTemperature()).setTopP(options.getTopP()).setMaxPromptTokens(options.getMaxPromptTokens()).setMaxCompletionTokens(options.getMaxCompletionTokens()).setTruncationStrategy(options.getTruncationStrategy()).setToolChoice(options.getToolChoice()).setResponseFormat(options.getResponseFormat()).setParallelToolCalls(options.isParallelToolCalls()).setMetadata(options.getMetadata());
        BinaryData createRunRequest = BinaryData.fromObject((Object)createRunRequestObj);
        if (include != null) {
            requestOptions.addQueryParam("include[]", include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return (ThreadRun)((BinaryData)this.createRunWithResponse(threadId, createRunRequest, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ThreadRun> listRuns(String threadId, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.serviceClient.listRuns(threadId, requestOptions).mapPage(bodyItemValue -> (ThreadRun)bodyItemValue.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ThreadRun> listRuns(String threadId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listRuns(threadId, requestOptions).mapPage(bodyItemValue -> (ThreadRun)bodyItemValue.toObject(ThreadRun.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun getRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadRun)((BinaryData)this.getRunWithResponse(threadId, runId, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun updateRun(String threadId, String runId, Map<String, String> metadata) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateRunRequest updateRunRequestObj = new UpdateRunRequest().setMetadata(metadata);
        BinaryData updateRunRequest = BinaryData.fromObject((Object)updateRunRequestObj);
        return (ThreadRun)((BinaryData)this.updateRunWithResponse(threadId, runId, updateRunRequest, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun updateRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        UpdateRunRequest updateRunRequestObj = new UpdateRunRequest();
        BinaryData updateRunRequest = BinaryData.fromObject((Object)updateRunRequestObj);
        return (ThreadRun)((BinaryData)this.updateRunWithResponse(threadId, runId, updateRunRequest, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun submitToolOutputsToRun(String threadId, String runId, List<ToolOutput> toolOutputs, Boolean stream) {
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest submitToolOutputsToRunRequestObj = new SubmitToolOutputsToRunRequest(toolOutputs).setStream(stream);
        BinaryData submitToolOutputsToRunRequest = BinaryData.fromObject((Object)submitToolOutputsToRunRequestObj);
        return (ThreadRun)((BinaryData)this.submitToolOutputsToRunWithResponse(threadId, runId, submitToolOutputsToRunRequest, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun submitToolOutputsToRun(String threadId, String runId, List<ToolOutput> toolOutputs) {
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest submitToolOutputsToRunRequestObj = new SubmitToolOutputsToRunRequest(toolOutputs);
        BinaryData submitToolOutputsToRunRequest = BinaryData.fromObject((Object)submitToolOutputsToRunRequestObj);
        return (ThreadRun)((BinaryData)this.submitToolOutputsToRunWithResponse(threadId, runId, submitToolOutputsToRunRequest, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ThreadRun cancelRun(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        return (ThreadRun)((BinaryData)this.cancelRunWithResponse(threadId, runId, requestOptions).getValue()).toObject(ThreadRun.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunStep getRunStep(String threadId, String runId, String stepId, List<RunAdditionalFieldList> include) {
        RequestOptions requestOptions = new RequestOptions();
        if (include != null) {
            requestOptions.addQueryParam("include[]", include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        return (RunStep)((BinaryData)this.getRunStepWithResponse(threadId, runId, stepId, requestOptions).getValue()).toObject(RunStep.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunStep getRunStep(String threadId, String runId, String stepId) {
        RequestOptions requestOptions = new RequestOptions();
        return (RunStep)((BinaryData)this.getRunStepWithResponse(threadId, runId, stepId, requestOptions).getValue()).toObject(RunStep.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RunStep> listRunSteps(String threadId, String runId, List<RunAdditionalFieldList> include, Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (include != null) {
            requestOptions.addQueryParam("include[]", include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        return this.serviceClient.listRunSteps(threadId, runId, requestOptions).mapPage(bodyItemValue -> (RunStep)bodyItemValue.toObject(RunStep.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RunStep> listRunSteps(String threadId, String runId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listRunSteps(threadId, runId, requestOptions).mapPage(bodyItemValue -> (RunStep)bodyItemValue.toObject(RunStep.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Stream<StreamUpdate> createRunStreaming(CreateRunOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        String threadId = options.getThreadId();
        List<RunAdditionalFieldList> include = options.getInclude();
        CreateRunRequest createRunRequestObj = new CreateRunRequest(options.getAssistantId()).setModel(options.getModel()).setInstructions(options.getInstructions()).setAdditionalInstructions(options.getAdditionalInstructions()).setAdditionalMessages(options.getAdditionalMessages()).setTools(options.getTools()).setStream(true).setTemperature(options.getTemperature()).setTopP(options.getTopP()).setMaxPromptTokens(options.getMaxPromptTokens()).setMaxCompletionTokens(options.getMaxCompletionTokens()).setTruncationStrategy(options.getTruncationStrategy()).setToolChoice(options.getToolChoice()).setResponseFormat(options.getResponseFormat()).setParallelToolCalls(options.isParallelToolCalls()).setMetadata(options.getMetadata());
        BinaryData createRunRequest = BinaryData.fromObject((Object)createRunRequestObj);
        if (include != null) {
            requestOptions.addQueryParam("include[]", include.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(",")), false);
        }
        Flux response = ((BinaryData)this.createRunWithResponse(threadId, createRunRequest, requestOptions).getValue()).toFluxByteBuffer();
        PersistentAgentServerSentEvents eventStream = new PersistentAgentServerSentEvents((Flux<ByteBuffer>)response);
        Iterable iterable = eventStream.getEvents().toIterable();
        Stream stream = StreamSupport.stream(iterable.spliterator(), false);
        return (Stream)stream.onClose(() -> {
            if (iterable instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)iterable)).close();
                }
                catch (Exception e) {
                    throw this.logger.logExceptionAsError(new RuntimeException(e));
                }
            }
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Stream<StreamUpdate> submitToolOutputsToRunStreaming(String threadId, String runId, List<ToolOutput> toolOutputs) {
        RequestOptions requestOptions = new RequestOptions();
        SubmitToolOutputsToRunRequest submitToolOutputsToRunRequestObj = new SubmitToolOutputsToRunRequest(toolOutputs).setStream(true);
        BinaryData submitToolOutputsToRunRequest = BinaryData.fromObject((Object)submitToolOutputsToRunRequestObj);
        Flux response = ((BinaryData)this.submitToolOutputsToRunWithResponse(threadId, runId, submitToolOutputsToRunRequest, requestOptions).getValue()).toFluxByteBuffer();
        PersistentAgentServerSentEvents eventStream = new PersistentAgentServerSentEvents((Flux<ByteBuffer>)response);
        Iterable iterable = eventStream.getEvents().toIterable();
        Stream stream = StreamSupport.stream(iterable.spliterator(), false);
        return (Stream)stream.onClose(() -> {
            if (iterable instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)iterable)).close();
                }
                catch (Exception e) {
                    throw this.logger.logExceptionAsError(new RuntimeException(e));
                }
            }
        });
    }
}

