/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.FilesAsyncClient;
import com.azure.ai.agents.persistent.MessagesAsyncClient;
import com.azure.ai.agents.persistent.PersistentAgentsAdministrationAsyncClient;
import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.RunsAsyncClient;
import com.azure.ai.agents.persistent.ThreadsAsyncClient;
import com.azure.ai.agents.persistent.VectorStoresAsyncClient;
import com.azure.ai.agents.persistent.implementation.PersistentAgentsClientImpl;
import com.azure.ai.agents.persistent.implementation.models.CreateThreadAndRunRequest;
import com.azure.ai.agents.persistent.models.CreateThreadAndRunOptions;
import com.azure.ai.agents.persistent.models.ThreadRun;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import reactor.core.publisher.Mono;

@ServiceClient(builder=PersistentAgentsClientBuilder.class, isAsync=true)
public final class PersistentAgentsAsyncClient {
    private final PersistentAgentsClientImpl serviceClient;

    PersistentAgentsAsyncClient(PersistentAgentsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    public PersistentAgentsAdministrationAsyncClient getPersistentAgentsAdministrationAsyncClient() {
        return new PersistentAgentsAdministrationAsyncClient(this.serviceClient.getPersistentAgentsAdministration());
    }

    public FilesAsyncClient getFilesAsyncClient() {
        return new FilesAsyncClient(this.serviceClient.getFiles());
    }

    public MessagesAsyncClient getMessagesAsyncClient() {
        return new MessagesAsyncClient(this.serviceClient.getMessages());
    }

    public RunsAsyncClient getRunsAsyncClient() {
        return new RunsAsyncClient(this.serviceClient.getRuns());
    }

    public ThreadsAsyncClient getThreadsAsyncClient() {
        return new ThreadsAsyncClient(this.serviceClient.getThreads());
    }

    public VectorStoresAsyncClient getVectorStoresAsyncClient() {
        return new VectorStoresAsyncClient(this.serviceClient.getVectorStores());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createThreadAndRunWithResponse(BinaryData createThreadAndRunRequest, RequestOptions requestOptions) {
        return this.serviceClient.createThreadAndRunWithResponseAsync(createThreadAndRunRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ThreadRun> createThreadAndRun(CreateThreadAndRunOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        CreateThreadAndRunRequest createThreadAndRunRequestObj = new CreateThreadAndRunRequest(options.getAssistantId()).setThread(options.getThread()).setModel(options.getModel()).setInstructions(options.getInstructions()).setTools(options.getTools()).setToolResources(options.getToolResources()).setStream(options.isStream()).setTemperature(options.getTemperature()).setTopP(options.getTopP()).setMaxPromptTokens(options.getMaxPromptTokens()).setMaxCompletionTokens(options.getMaxCompletionTokens()).setTruncationStrategy(options.getTruncationStrategy()).setToolChoice(options.getToolChoice()).setResponseFormat(options.getResponseFormat()).setParallelToolCalls(options.isParallelToolCalls()).setMetadata(options.getMetadata());
        BinaryData createThreadAndRunRequest = BinaryData.fromObject((Object)createThreadAndRunRequestObj);
        return this.createThreadAndRunWithResponse(createThreadAndRunRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ThreadRun)protocolMethodData.toObject(ThreadRun.class));
    }
}

