/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.PersistentAgentsAdministrationImpl;
import com.azure.ai.agents.persistent.implementation.models.AgentDeletionStatus;
import com.azure.ai.agents.persistent.implementation.models.CreateAgentRequest;
import com.azure.ai.agents.persistent.implementation.models.UpdateAgentRequest;
import com.azure.ai.agents.persistent.models.CreateAgentOptions;
import com.azure.ai.agents.persistent.models.ListSortOrder;
import com.azure.ai.agents.persistent.models.PersistentAgent;
import com.azure.ai.agents.persistent.models.UpdateAgentOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=PersistentAgentsClientBuilder.class, isAsync=true)
public final class PersistentAgentsAdministrationAsyncClient {
    private final PersistentAgentsAdministrationImpl serviceClient;

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getAgentWithResponse(String assistantId, RequestOptions requestOptions) {
        return this.serviceClient.getAgentWithResponseAsync(assistantId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> createAgentWithResponse(BinaryData createAgentRequest, RequestOptions requestOptions) {
        return this.serviceClient.createAgentWithResponseAsync(createAgentRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> updateAgentWithResponse(String assistantId, BinaryData updateAgentRequest, RequestOptions requestOptions) {
        return this.serviceClient.updateAgentWithResponseAsync(assistantId, updateAgentRequest, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listAgents(RequestOptions requestOptions) {
        return this.serviceClient.listAgentsAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PersistentAgent> getAgent(String assistantId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getAgentWithResponse(assistantId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (PersistentAgent)protocolMethodData.toObject(PersistentAgent.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PersistentAgent> createAgent(CreateAgentOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        CreateAgentRequest createAgentRequestObj = new CreateAgentRequest(options.getModel()).setName(options.getName()).setDescription(options.getDescription()).setInstructions(options.getInstructions()).setTools(options.getTools()).setToolResources(options.getToolResources()).setTemperature(options.getTemperature()).setTopP(options.getTopP()).setResponseFormat(options.getResponseFormat()).setMetadata(options.getMetadata());
        BinaryData createAgentRequest = BinaryData.fromObject((Object)createAgentRequestObj);
        return this.createAgentWithResponse(createAgentRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (PersistentAgent)protocolMethodData.toObject(PersistentAgent.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PersistentAgent> updateAgent(UpdateAgentOptions options) {
        RequestOptions requestOptions = new RequestOptions();
        String assistantId = options.getAssistantId();
        UpdateAgentRequest updateAgentRequestObj = new UpdateAgentRequest().setModel(options.getModel()).setName(options.getName()).setDescription(options.getDescription()).setInstructions(options.getInstructions()).setTools(options.getTools()).setToolResources(options.getToolResources()).setTemperature(options.getTemperature()).setTopP(options.getTopP()).setResponseFormat(options.getResponseFormat()).setMetadata(options.getMetadata());
        BinaryData updateAgentRequest = BinaryData.fromObject((Object)updateAgentRequestObj);
        return this.updateAgentWithResponse(assistantId, updateAgentRequest, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (PersistentAgent)protocolMethodData.toObject(PersistentAgent.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PersistentAgent> listAgents(Integer limit, ListSortOrder order, String after, String before) {
        RequestOptions requestOptions = new RequestOptions();
        if (limit != null) {
            requestOptions.addQueryParam("limit", String.valueOf(limit), false);
        }
        if (order != null) {
            requestOptions.addQueryParam("order", order.toString(), false);
        }
        if (after != null) {
            requestOptions.addQueryParam("after", after, false);
        }
        if (before != null) {
            requestOptions.addQueryParam("before", before, false);
        }
        PagedFlux<BinaryData> pagedFluxResponse = this.listAgents(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (PersistentAgent)protocolMethodData.toObject(PersistentAgent.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PersistentAgent> listAgents() {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listAgents(requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (PersistentAgent)protocolMethodData.toObject(PersistentAgent.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> deleteAgentInternalWithResponse(String assistantId, RequestOptions requestOptions) {
        return this.serviceClient.deleteAgentInternalWithResponseAsync(assistantId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<AgentDeletionStatus> deleteAgentInternal(String assistantId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteAgentInternalWithResponse(assistantId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (AgentDeletionStatus)protocolMethodData.toObject(AgentDeletionStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAgent(String assistantId) {
        Mono<AgentDeletionStatus> deletionStatusMono = this.deleteAgentInternal(assistantId);
        return deletionStatusMono.flatMap(deletionStatus -> {
            if (deletionStatus == null || !deletionStatus.isDeleted()) {
                return Mono.error((Throwable)new RuntimeException("Persistent Agent with ID '" + assistantId + "' could not be deleted."));
            }
            return Mono.empty();
        });
    }

    PersistentAgentsAdministrationAsyncClient(PersistentAgentsAdministrationImpl serviceClient) {
        this.serviceClient = serviceClient;
    }
}

