/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.FilesImpl;
import com.azure.ai.agents.persistent.implementation.MultipartFormDataHelper;
import com.azure.ai.agents.persistent.implementation.models.FileDeletionStatus;
import com.azure.ai.agents.persistent.models.FileInfo;
import com.azure.ai.agents.persistent.models.FileListResponse;
import com.azure.ai.agents.persistent.models.FilePurpose;
import com.azure.ai.agents.persistent.models.UploadFileRequest;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.logging.ClientLogger;
import java.util.List;
import java.util.Objects;

@ServiceClient(builder=PersistentAgentsClientBuilder.class)
public final class FilesClient {
    private static final ClientLogger LOGGER = new ClientLogger(FilesClient.class);
    private final FilesImpl serviceClient;

    FilesClient(FilesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> uploadFileWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.uploadFileWithResponse(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getFileWithResponse(String fileId, RequestOptions requestOptions) {
        return this.serviceClient.getFileWithResponse(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getFileContentWithResponse(String fileId, RequestOptions requestOptions) {
        return this.serviceClient.getFileContentWithResponse(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileInfo uploadFile(UploadFileRequest body) {
        RequestOptions requestOptions = new RequestOptions();
        return (FileInfo)((BinaryData)this.uploadFileWithResponse(new MultipartFormDataHelper(requestOptions).serializeFileField("file", body.getFile().getContent(), body.getFile().getContentType(), body.getFile().getFilename()).serializeTextField("purpose", Objects.toString((Object)body.getPurpose())).serializeTextField("filename", body.getFilename()).end().getRequestBody(), requestOptions).getValue()).toObject(FileInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileInfo getFile(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (FileInfo)((BinaryData)this.getFileWithResponse(fileId, requestOptions).getValue()).toObject(FileInfo.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BinaryData getFileContent(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (BinaryData)this.getFileContentWithResponse(fileId, requestOptions).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Response<BinaryData> deleteFileInternalWithResponse(String fileId, RequestOptions requestOptions) {
        return this.serviceClient.deleteFileInternalWithResponse(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    FileDeletionStatus deleteFileInternal(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return (FileDeletionStatus)((BinaryData)this.deleteFileInternalWithResponse(fileId, requestOptions).getValue()).toObject(FileDeletionStatus.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFile(String fileId) {
        FileDeletionStatus deletionStatus = this.deleteFileInternal(fileId);
        if (deletionStatus == null || !deletionStatus.isDeleted()) {
            throw LOGGER.logExceptionAsWarning(new RuntimeException("File with ID '" + fileId + "' could not be deleted."));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> listFilesInternalWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.listFilesInternalWithResponse(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileListResponse listFilesInternal(FilePurpose purpose) {
        RequestOptions requestOptions = new RequestOptions();
        if (purpose != null) {
            requestOptions.addQueryParam("purpose", purpose.toString(), false);
        }
        return (FileListResponse)((BinaryData)this.listFilesInternalWithResponse(requestOptions).getValue()).toObject(FileListResponse.class);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public FileListResponse listFilesInternal() {
        RequestOptions requestOptions = new RequestOptions();
        return (FileListResponse)((BinaryData)this.listFilesInternalWithResponse(requestOptions).getValue()).toObject(FileListResponse.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public List<FileInfo> listFiles(FilePurpose purpose) {
        return this.listFilesInternal(purpose).getData();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public List<FileInfo> listFiles() {
        return this.listFilesInternal().getData();
    }
}

