/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.agents.persistent;

import com.azure.ai.agents.persistent.PersistentAgentsClientBuilder;
import com.azure.ai.agents.persistent.implementation.FilesImpl;
import com.azure.ai.agents.persistent.implementation.MultipartFormDataHelper;
import com.azure.ai.agents.persistent.implementation.models.FileDeletionStatus;
import com.azure.ai.agents.persistent.models.FileInfo;
import com.azure.ai.agents.persistent.models.FileListResponse;
import com.azure.ai.agents.persistent.models.FilePurpose;
import com.azure.ai.agents.persistent.models.UploadFileRequest;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=PersistentAgentsClientBuilder.class, isAsync=true)
public final class FilesAsyncClient {
    private final FilesImpl serviceClient;

    FilesAsyncClient(FilesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> uploadFileWithResponse(BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.uploadFileWithResponseAsync(body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getFileWithResponse(String fileId, RequestOptions requestOptions) {
        return this.serviceClient.getFileWithResponseAsync(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getFileContentWithResponse(String fileId, RequestOptions requestOptions) {
        return this.serviceClient.getFileContentWithResponseAsync(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileInfo> uploadFile(UploadFileRequest body) {
        RequestOptions requestOptions = new RequestOptions();
        return this.uploadFileWithResponse(new MultipartFormDataHelper(requestOptions).serializeFileField("file", body.getFile().getContent(), body.getFile().getContentType(), body.getFile().getFilename()).serializeTextField("purpose", Objects.toString((Object)body.getPurpose())).serializeTextField("filename", body.getFilename()).end().getRequestBody(), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (FileInfo)protocolMethodData.toObject(FileInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileInfo> getFile(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getFileWithResponse(fileId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (FileInfo)protocolMethodData.toObject(FileInfo.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BinaryData> getFileContent(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getFileContentWithResponse(fileId, requestOptions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> deleteFileInternalWithResponse(String fileId, RequestOptions requestOptions) {
        return this.serviceClient.deleteFileInternalWithResponseAsync(fileId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<FileDeletionStatus> deleteFileInternal(String fileId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.deleteFileInternalWithResponse(fileId, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (FileDeletionStatus)protocolMethodData.toObject(FileDeletionStatus.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteFile(String fileId) {
        Mono<FileDeletionStatus> deletionStatusMono = this.deleteFileInternal(fileId);
        return deletionStatusMono.flatMap(deletionStatus -> {
            if (deletionStatus == null || !deletionStatus.isDeleted()) {
                return Mono.error((Throwable)new RuntimeException("File with ID '" + fileId + "' could not be deleted."));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> listFilesInternalWithResponse(RequestOptions requestOptions) {
        return this.serviceClient.listFilesInternalWithResponseAsync(requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileListResponse> listFilesInternal(FilePurpose purpose) {
        RequestOptions requestOptions = new RequestOptions();
        if (purpose != null) {
            requestOptions.addQueryParam("purpose", purpose.toString(), false);
        }
        return this.listFilesInternalWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (FileListResponse)protocolMethodData.toObject(FileListResponse.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FileListResponse> listFilesInternal() {
        RequestOptions requestOptions = new RequestOptions();
        return this.listFilesInternalWithResponse(requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (FileListResponse)protocolMethodData.toObject(FileListResponse.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<FileInfo> listFiles(FilePurpose purpose) {
        return this.listFilesInternal(purpose).flatMapMany(response -> Flux.fromIterable(response.getData()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public Flux<FileInfo> listFiles() {
        return this.listFilesInternal().flatMapMany(response -> Flux.fromIterable(response.getData()));
    }
}

