/*
 * Decompiled with CFR 0.152.
 */
package com.azure.mobile;

import com.azure.data.model.Permission;
import com.azure.data.model.PermissionMode;
import com.azure.data.model.service.DataError;
import com.azure.data.model.service.PermissionProviderError;
import com.azure.data.model.service.ResourceType;
import com.azure.data.service.PermissionProvider;
import com.azure.data.service.PermissionProviderConfiguration;
import com.azure.data.service.PermissionProviderKt;
import com.azure.data.util.json.GsonConfigKt;
import com.azure.mobile.PermissionRequest;
import java.io.IOException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B%\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB#\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0002JJ\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0016J:\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0016JB\u0010 \u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0016JN\u0010!\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0002JB\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0016JB\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0016JB\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\u00100\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lcom/azure/mobile/DefaultPermissionProvider;", "Lcom/azure/data/service/PermissionProvider;", "baseUrl", "Ljava/net/URL;", "configuration", "Lcom/azure/data/service/PermissionProviderConfiguration;", "client", "Lokhttp3/OkHttpClient;", "(Ljava/net/URL;Lcom/azure/data/service/PermissionProviderConfiguration;Lokhttp3/OkHttpClient;)V", "Lokhttp3/HttpUrl;", "(Lokhttp3/HttpUrl;Lcom/azure/data/service/PermissionProviderConfiguration;Lokhttp3/OkHttpClient;)V", "getConfiguration", "()Lcom/azure/data/service/PermissionProviderConfiguration;", "setConfiguration", "(Lcom/azure/data/service/PermissionProviderConfiguration;)V", "getPermission", "", "permissionRequest", "Lcom/azure/mobile/PermissionRequest;", "completion", "Lkotlin/Function1;", "Lcom/azure/data/model/service/Response;", "Lcom/azure/data/model/Permission;", "getPermissionForAttachment", "attachmentId", "", "documentId", "collectionId", "databaseId", "permissionMode", "Lcom/azure/data/model/PermissionMode;", "getPermissionForCollection", "getPermissionForDocument", "getPermissionForResource", "altLink", "getPermissionForStoredProcedure", "storedProcedureId", "getPermissionForTrigger", "triggerId", "getPermissionForUserDefinedFunction", "functionId", "azuremobile_release"})
public final class DefaultPermissionProvider
implements PermissionProvider {
    private final HttpUrl baseUrl;
    @Nullable
    private PermissionProviderConfiguration configuration;
    private final OkHttpClient client;

    public void getPermissionForCollection(@NotNull String collectionId, @NotNull String databaseId, @NotNull PermissionMode permissionMode, @NotNull Function1<? super com.azure.data.model.service.Response<Permission>, Unit> completion) {
        Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)permissionMode, (String)"permissionMode");
        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
        PermissionProviderConfiguration permissionProviderConfiguration = this.getConfiguration();
        if (permissionProviderConfiguration == null) {
            Intrinsics.throwNpe();
        }
        PermissionRequest permissionRequest = new PermissionRequest(databaseId, collectionId, null, null, (int)permissionProviderConfiguration.getDefaultTokenDuration(), permissionMode);
        this.getPermission(permissionRequest, completion);
    }

    public void getPermissionForDocument(@NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull PermissionMode permissionMode, @NotNull Function1<? super com.azure.data.model.service.Response<Permission>, Unit> completion) {
        Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
        Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)permissionMode, (String)"permissionMode");
        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
        String altLink = ResourceType.Database.getPath() + '/' + databaseId + '/' + ResourceType.Collection.getPath() + '/' + collectionId + '/' + ResourceType.Document.getPath() + '/' + documentId;
        this.getPermissionForResource(databaseId, collectionId, documentId, altLink, permissionMode, completion);
    }

    public void getPermissionForAttachment(@NotNull String attachmentId, @NotNull String documentId, @NotNull String collectionId, @NotNull String databaseId, @NotNull PermissionMode permissionMode, @NotNull Function1<? super com.azure.data.model.service.Response<Permission>, Unit> completion) {
        Intrinsics.checkParameterIsNotNull((Object)attachmentId, (String)"attachmentId");
        Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
        Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)permissionMode, (String)"permissionMode");
        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
        String altLink = ResourceType.Database.getPath() + '/' + databaseId + '/' + ResourceType.Collection.getPath() + '/' + collectionId + '/' + ResourceType.Document.getPath() + '/' + documentId + '/' + ResourceType.Attachment.getPath() + '/' + attachmentId;
        this.getPermissionForResource(databaseId, collectionId, documentId, altLink, permissionMode, completion);
    }

    public void getPermissionForStoredProcedure(@NotNull String storedProcedureId, @NotNull String collectionId, @NotNull String databaseId, @NotNull PermissionMode permissionMode, @NotNull Function1<? super com.azure.data.model.service.Response<Permission>, Unit> completion) {
        Intrinsics.checkParameterIsNotNull((Object)storedProcedureId, (String)"storedProcedureId");
        Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)permissionMode, (String)"permissionMode");
        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
        String altLink = ResourceType.Database.getPath() + '/' + databaseId + '/' + ResourceType.Collection.getPath() + '/' + collectionId + '/' + ResourceType.StoredProcedure.getPath() + '/' + storedProcedureId;
        this.getPermissionForResource(databaseId, collectionId, null, altLink, permissionMode, completion);
    }

    public void getPermissionForUserDefinedFunction(@NotNull String functionId, @NotNull String collectionId, @NotNull String databaseId, @NotNull PermissionMode permissionMode, @NotNull Function1<? super com.azure.data.model.service.Response<Permission>, Unit> completion) {
        Intrinsics.checkParameterIsNotNull((Object)functionId, (String)"functionId");
        Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)permissionMode, (String)"permissionMode");
        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
        String altLink = ResourceType.Database.getPath() + '/' + databaseId + '/' + ResourceType.Collection.getPath() + '/' + collectionId + '/' + ResourceType.Udf.getPath() + '/' + functionId;
        this.getPermissionForResource(databaseId, collectionId, null, altLink, permissionMode, completion);
    }

    public void getPermissionForTrigger(@NotNull String triggerId, @NotNull String collectionId, @NotNull String databaseId, @NotNull PermissionMode permissionMode, @NotNull Function1<? super com.azure.data.model.service.Response<Permission>, Unit> completion) {
        Intrinsics.checkParameterIsNotNull((Object)triggerId, (String)"triggerId");
        Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
        Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
        Intrinsics.checkParameterIsNotNull((Object)permissionMode, (String)"permissionMode");
        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
        String altLink = ResourceType.Database.getPath() + '/' + databaseId + '/' + ResourceType.Collection.getPath() + '/' + collectionId + '/' + ResourceType.Trigger.getPath() + '/' + triggerId;
        this.getPermissionForResource(databaseId, collectionId, null, altLink, permissionMode, completion);
    }

    private final void getPermissionForResource(String databaseId, String collectionId, String documentId, String altLink, PermissionMode permissionMode, Function1<? super com.azure.data.model.service.Response<Permission>, Unit> completion) {
        String string = PermissionProviderKt.getSelfLink((PermissionProvider)this, (String)altLink);
        if (string == null) {
            completion.invoke((Object)new com.azure.data.model.service.Response(new DataError((Error)PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
            return;
        }
        String resourceLink = string;
        PermissionProviderConfiguration permissionProviderConfiguration = this.getConfiguration();
        if (permissionProviderConfiguration == null) {
            Intrinsics.throwNpe();
        }
        PermissionRequest permissionRequest = new PermissionRequest(databaseId, collectionId, documentId, resourceLink, (int)permissionProviderConfiguration.getDefaultTokenDuration(), permissionMode);
        this.getPermission(permissionRequest, completion);
    }

    static /* synthetic */ void getPermissionForResource$default(DefaultPermissionProvider defaultPermissionProvider, String string, String string2, String string3, String string4, PermissionMode permissionMode, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        defaultPermissionProvider.getPermissionForResource(string, string2, string3, string4, permissionMode, (Function1<? super com.azure.data.model.service.Response<Permission>, Unit>)function1);
    }

    private final void getPermission(PermissionRequest permissionRequest, Function1<? super com.azure.data.model.service.Response<Permission>, Unit> completion) {
        try {
            HttpUrl url = this.baseUrl.newBuilder().addPathSegment("api/data/permission").build();
            Request.Builder builder = new Request.Builder().url(url).addHeader("Content-Type", "application/json");
            String string = GsonConfigKt.getGson().toJson((Object)permissionRequest);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(permissionRequest)");
            Request request = builder.post(RequestBody.Companion.create(string, MediaType.Companion.parse("application/json"))).build();
            this.client.newCall(request).enqueue(new Callback(completion, request){
                final /* synthetic */ Function1 $completion;
                final /* synthetic */ Request $request;

                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    this.$completion.invoke((Object)new com.azure.data.model.service.Response(new DataError((Exception)e), this.$request, null, null, false, 28, null));
                }

                public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    try {
                        Permission permission;
                        ResponseBody responseBody = response.body();
                        if (responseBody == null) {
                            this.$completion.invoke((Object)new com.azure.data.model.service.Response(new DataError((Error)PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                            return;
                        }
                        ResponseBody body = responseBody;
                        String json = body.string();
                        Permission permission2 = permission = (Permission)GsonConfigKt.getGson().fromJson(json, Permission.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)permission2, (String)"permission");
                        this.$completion.invoke((Object)new com.azure.data.model.service.Response((Object)permission2));
                        return;
                    }
                    catch (Exception ex) {
                        this.$completion.invoke((Object)new com.azure.data.model.service.Response(new DataError(ex), this.$request, response, null, false, 24, null));
                        return;
                    }
                }
                {
                    this.$completion = $captured_local_variable$0;
                    this.$request = $captured_local_variable$1;
                }
            });
        }
        catch (Exception ex) {
            completion.invoke((Object)new com.azure.data.model.service.Response(new DataError((Error)PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
            return;
        }
    }

    @Nullable
    public PermissionProviderConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(@Nullable PermissionProviderConfiguration permissionProviderConfiguration) {
        this.configuration = permissionProviderConfiguration;
    }

    public DefaultPermissionProvider(@NotNull HttpUrl baseUrl, @Nullable PermissionProviderConfiguration configuration, @NotNull OkHttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.baseUrl = baseUrl;
        this.configuration = configuration;
        this.client = client;
    }

    public /* synthetic */ DefaultPermissionProvider(HttpUrl httpUrl, PermissionProviderConfiguration permissionProviderConfiguration, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            permissionProviderConfiguration = PermissionProviderConfiguration.Companion.getDefault();
        }
        if ((n & 4) != 0) {
            okHttpClient = new OkHttpClient();
        }
        this(httpUrl, permissionProviderConfiguration, okHttpClient);
    }

    public DefaultPermissionProvider(@NotNull URL baseUrl, @Nullable PermissionProviderConfiguration configuration, @NotNull OkHttpClient client) {
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        HttpUrl httpUrl = HttpUrl.Companion.get(baseUrl);
        if (httpUrl == null) {
            Intrinsics.throwNpe();
        }
        this(httpUrl, configuration, client);
    }

    public /* synthetic */ DefaultPermissionProvider(URL uRL, PermissionProviderConfiguration permissionProviderConfiguration, OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            permissionProviderConfiguration = PermissionProviderConfiguration.Companion.getDefault();
        }
        if ((n & 4) != 0) {
            okHttpClient = new OkHttpClient.Builder().build();
        }
        this(uRL, permissionProviderConfiguration, okHttpClient);
    }
}

