/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import com.azure.core.log.LoggerKt;
import com.azure.core.util.ContextProvider;
import com.azure.data.model.Query;
import com.azure.data.model.Resource;
import com.azure.data.model.ResourceList;
import com.azure.data.model.service.ResourceLocation;
import com.azure.data.model.service.ResourceType;
import com.azure.data.service.ResourceCacheKt;
import com.azure.data.service.ResourceEncryptor;
import com.azure.data.util.ResourceOracle;
import com.azure.data.util.json.GsonConfigKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 +2\u00020\u0001:\u0002+,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0017J.\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0002J'\u0010\u001f\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#\u00a2\u0006\u0002\u0010$J(\u0010%\u001a\n\u0012\u0004\u0012\u0002H\u0012\u0018\u00010\u0017\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J(\u0010&\u001a\n\u0012\u0004\u0012\u0002H\u0012\u0018\u00010\u0017\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#J\u0006\u0010'\u001a\u00020\u0011J\u000e\u0010(\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020!J\u001d\u0010*\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006-"}, d2={"Lcom/azure/data/service/ResourceCache;", "", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "resourceEncryptor", "Lcom/azure/data/service/ResourceEncryptor;", "getResourceEncryptor", "()Lcom/azure/data/service/ResourceEncryptor;", "setResourceEncryptor", "(Lcom/azure/data/service/ResourceEncryptor;)V", "cache", "", "T", "Lcom/azure/data/model/Resource;", "resource", "(Lcom/azure/data/model/Resource;)V", "resources", "Lcom/azure/data/model/ResourceList;", "query", "Lcom/azure/data/model/Query;", "contentPath", "", "decrypt", "data", "encrypt", "getResourceAt", "location", "Lcom/azure/data/model/service/ResourceLocation;", "resourceType", "Ljava/lang/reflect/Type;", "(Lcom/azure/data/model/service/ResourceLocation;Ljava/lang/reflect/Type;)Lcom/azure/data/model/Resource;", "getResourcesAt", "getResourcesForQuery", "purge", "remove", "resourceLocation", "replace", "Companion", "ResourcesMetadata", "azuredata_release"})
public final class ResourceCache {
    private boolean isEnabled = true;
    @Nullable
    private ResourceEncryptor resourceEncryptor;
    private ExecutorService executor;
    @NotNull
    private static ResourceCache shared;
    public static final Companion Companion;

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Nullable
    public final ResourceEncryptor getResourceEncryptor() {
        return this.resourceEncryptor;
    }

    public final void setResourceEncryptor(@Nullable ResourceEncryptor resourceEncryptor2) {
        this.resourceEncryptor = resourceEncryptor2;
    }

    public final <T extends Resource> void cache(@NotNull T resource) {
        Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
        ResourceOracle.Companion.getShared().storeLinks(resource);
        if (this.isEnabled) {
            this.executor.execute(new Runnable(this, resource){
                final /* synthetic */ ResourceCache this$0;
                final /* synthetic */ Resource $resource;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    boolean $i$f$safeExecute = false;
                    try {
                        boolean bl = false;
                        File file = ResourceCacheKt.resourceCacheFile(ContextProvider.Companion.getAppContext(), this.$resource);
                        if (file != null) {
                            File file2 = file;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            File it = file2;
                            boolean bl4 = false;
                            Object object = it;
                            Charset charset = Charsets.UTF_8;
                            int n = 8192;
                            boolean bl5 = false;
                            Object object2 = object;
                            boolean bl6 = false;
                            Object object3 = object2;
                            boolean bl7 = false;
                            object3 = new FileOutputStream((File)object3);
                            bl7 = false;
                            object2 = new OutputStreamWriter((OutputStream)object3, charset);
                            bl6 = false;
                            object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
                            boolean bl8 = false;
                            Throwable throwable = null;
                            try {
                                BufferedWriter writer = (BufferedWriter)object;
                                boolean bl9 = false;
                                String string = GsonConfigKt.getGson().toJson((Object)this.$resource);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(resource)");
                                writer.write(ResourceCache.access$encrypt(this.this$0, string));
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Exception ex$iv) {
                        boolean $i$f$e = false;
                        int level$iv$iv$iv = 6;
                        boolean $i$f$log = false;
                        if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                            boolean bl = false;
                            Timber.e((Throwable)ex$iv);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
                {
                    this.this$0 = resourceCache;
                    this.$resource = resource;
                }
            });
        }
    }

    public final <T extends Resource> void cache(@NotNull ResourceList<T> resources) {
        Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
        ResourceOracle.Companion.getShared().storeLinks(resources);
        Iterable $this$forEach$iv = resources.getItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Resource it = (Resource)element$iv;
            boolean bl = false;
            this.cache(it);
        }
    }

    public final <T extends Resource> void cache(@NotNull ResourceList<T> resources, @NotNull Query query, @NotNull String contentPath) {
        Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull((Object)contentPath, (String)"contentPath");
        if (resources.getCount() == 0) {
            return;
        }
        ResourceOracle.Companion.getShared().storeLinks(resources);
        if (this.isEnabled) {
            this.executor.execute(new Runnable(this, resources, contentPath, query){
                final /* synthetic */ ResourceCache this$0;
                final /* synthetic */ ResourceList $resources;
                final /* synthetic */ String $contentPath;
                final /* synthetic */ Query $query;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    boolean $i$f$safeExecute = false;
                    try {
                        boolean bl = false;
                        String string = this.$resources.getResourceId();
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        ResourcesMetadata metadata2 = new ResourcesMetadata(string, this.$contentPath);
                        File metadataPath = ResourceCacheKt.metadatafileUrl(ContextProvider.Companion.getAppContext(), this.$query);
                        Object object = metadataPath;
                        Charset charset = Charsets.UTF_8;
                        int n = 8192;
                        boolean bl2 = false;
                        Object object2 = object;
                        boolean bl3 = false;
                        Object object3 = object2;
                        boolean bl4 = false;
                        object3 = new FileOutputStream((File)object3);
                        bl4 = false;
                        object2 = new OutputStreamWriter((OutputStream)object3, charset);
                        bl3 = false;
                        object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
                        boolean bl5 = false;
                        Object object4 = null;
                        try {
                            BufferedWriter writer = (BufferedWriter)object;
                            boolean bl6 = false;
                            String string2 = GsonConfigKt.getGson().toJson((Object)metadata2);
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gson.toJson(metadata)");
                            writer.write(ResourceCache.access$encrypt(this.this$0, string2));
                            writer = Unit.INSTANCE;
                        }
                        catch (Throwable writer) {
                            object4 = writer;
                            throw writer;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)object4);
                        }
                        Iterable $this$forEach$iv = this.$resources.getItems();
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            Resource resource = (Resource)element$iv;
                            boolean bl7 = false;
                            File file = ResourceCacheKt.resourceCacheFile(ContextProvider.Companion.getAppContext(), resource, this.$query);
                            Object object5 = file;
                            Charset charset2 = Charsets.UTF_8;
                            int n2 = 8192;
                            boolean bl8 = false;
                            Object object6 = object5;
                            boolean bl9 = false;
                            Object object7 = object6;
                            boolean bl10 = false;
                            object7 = new FileOutputStream((File)object7);
                            bl10 = false;
                            object6 = new OutputStreamWriter((OutputStream)object7, charset2);
                            bl9 = false;
                            object5 = object6 instanceof BufferedWriter ? (BufferedWriter)object6 : new BufferedWriter((Writer)object6, n2);
                            boolean bl11 = false;
                            Throwable throwable = null;
                            try {
                                BufferedWriter writer = (BufferedWriter)object5;
                                boolean bl12 = false;
                                String string3 = GsonConfigKt.getGson().toJson((Object)resource);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"gson.toJson(resource)");
                                writer.write(ResourceCache.access$encrypt(this.this$0, string3));
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object5, (Throwable)throwable);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Exception ex$iv) {
                        boolean $i$f$e = false;
                        int level$iv$iv$iv = 6;
                        boolean $i$f$log = false;
                        if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                            boolean bl = false;
                            Timber.e((Throwable)ex$iv);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
                {
                    this.this$0 = resourceCache;
                    this.$resources = resourceList;
                    this.$contentPath = string;
                    this.$query = query;
                }
            });
        }
    }

    public final <T extends Resource> void replace(@NotNull T resource) {
        Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
        this.remove(resource);
        this.cache(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T extends Resource> T getResourceAt(@NotNull ResourceLocation location, @NotNull Type resourceType) {
        Resource resource;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
        if (!this.isEnabled) {
            return null;
        }
        boolean $i$f$safe = false;
        try {
            Resource resource2;
            boolean bl = false;
            File file = ResourceCacheKt.resourceCacheFile(ContextProvider.Companion.getAppContext(), location);
            if (file != null) {
                File file2 = file;
                boolean bl2 = false;
                boolean bl3 = false;
                File file3 = file2;
                boolean bl4 = false;
                Object object = file3;
                Charset charset = Charsets.UTF_8;
                int n = 8192;
                boolean bl5 = false;
                Object object2 = object;
                boolean bl6 = false;
                Object object3 = object2;
                boolean bl7 = false;
                object3 = new FileInputStream((File)object3);
                bl7 = false;
                object2 = new InputStreamReader((InputStream)object3, charset);
                bl6 = false;
                object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                boolean bl8 = false;
                Throwable throwable = null;
                try {
                    BufferedReader it = (BufferedReader)object;
                    boolean bl9 = false;
                    Resource resource3 = (Resource)GsonConfigKt.getGson().fromJson(this.decrypt(TextStreamsKt.readText((Reader)it)), resourceType);
                    resource2 = resource3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            } else {
                resource2 = null;
            }
            resource = resource2;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            resource = null;
        }
        return (T)resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final <T extends Resource> ResourceList<T> getResourcesAt(@NotNull ResourceLocation location, @NotNull Type resourceType) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
        if (this.isEnabled) {
            boolean $i$f$safeExecute = false;
            try {
                Collection<Resource> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                boolean bl = false;
                ResourceList resources = new ResourceList();
                Iterable iterable = ResourceCacheKt.resourceCacheFiles(ContextProvider.Companion.getAppContext(), location);
                ResourceList resourceList = resources;
                boolean $i$f$map = false;
                void var9_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Resource resource;
                    void file;
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Closeable closeable = file;
                    Charset charset = Charsets.UTF_8;
                    int n = 8192;
                    boolean bl3 = false;
                    Reader reader = closeable;
                    boolean bl4 = false;
                    InputStream inputStream = reader;
                    boolean bl5 = false;
                    inputStream = new FileInputStream((File)((Object)inputStream));
                    bl5 = false;
                    reader = new InputStreamReader(inputStream, charset);
                    bl4 = false;
                    closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                    boolean bl6 = false;
                    Throwable throwable = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable;
                        boolean bl7 = false;
                        resource = (Resource)GsonConfigKt.getGson().fromJson(this.decrypt(TextStreamsKt.readText((Reader)it)), resourceType);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    Resource resource2 = resource;
                    collection.add(resource2);
                }
                collection = (List)destination$iv$iv;
                resourceList.setItems(collection);
                iterable = resources.getItems();
                resourceList = resources;
                boolean bl8 = false;
                int n = iterable.size();
                resourceList.setCount(n);
                return resources;
            }
            catch (Exception ex$iv) {
                boolean $i$f$e = false;
                int level$iv$iv$iv = 6;
                boolean $i$f$log = false;
                if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Timber.e((Throwable)ex$iv);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final <T extends Resource> ResourceList<T> getResourcesForQuery(@NotNull Query query, @NotNull Type resourceType) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull((Object)resourceType, (String)"resourceType");
        if (this.isEnabled) {
            boolean $i$f$safeExecute = false;
            try {
                List list;
                ResourceList resourceList;
                boolean bl = false;
                ResourceList resources = new ResourceList();
                File metadataPath = ResourceCacheKt.metadatafileUrl(ContextProvider.Companion.getAppContext(), query);
                Object object = metadataPath;
                Charset charset = Charsets.UTF_8;
                int n = 8192;
                boolean bl2 = false;
                Object object2 = object;
                boolean bl3 = false;
                Object object3 = object2;
                int n2 = 0;
                object3 = new FileInputStream((File)object3);
                n2 = 0;
                object2 = new InputStreamReader((InputStream)object3, charset);
                bl3 = false;
                object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    Object it = (BufferedReader)object;
                    boolean bl5 = false;
                    it = (ResourcesMetadata)GsonConfigKt.getGson().fromJson(this.decrypt(TextStreamsKt.readText((Reader)((Reader)it))), ResourcesMetadata.class);
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                Object metadata2 = it;
                resources.setResourceId(((ResourcesMetadata)metadata2).getResourceId());
                ResourceList resourceList2 = resources;
                File[] fileArray = ResourceCacheKt.resourceCacheFiles(ContextProvider.Companion.getAppContext(), query);
                if (fileArray != null) {
                    Collection<Resource> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    object = fileArray;
                    resourceList = resourceList2;
                    boolean $i$f$map = false;
                    throwable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                    boolean $i$f$mapTo = false;
                    void var12_19 = $this$mapTo$iv$iv;
                    int n3 = ((void)var12_19).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        Resource resource;
                        void file;
                        void item$iv$iv;
                        void var18_26 = item$iv$iv = var12_19[n2];
                        collection = destination$iv$iv;
                        boolean bl6 = false;
                        Closeable closeable = file;
                        Charset charset2 = Charsets.UTF_8;
                        int n4 = 8192;
                        boolean bl7 = false;
                        Reader reader = closeable;
                        boolean bl8 = false;
                        InputStream inputStream = reader;
                        boolean bl9 = false;
                        inputStream = new FileInputStream((File)((Object)inputStream));
                        bl9 = false;
                        reader = new InputStreamReader(inputStream, charset2);
                        bl8 = false;
                        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n4);
                        boolean bl10 = false;
                        Throwable throwable2 = null;
                        try {
                            BufferedReader it = (BufferedReader)closeable;
                            boolean bl11 = false;
                            resource = (Resource)GsonConfigKt.getGson().fromJson(this.decrypt(TextStreamsKt.readText((Reader)it)), resourceType);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        }
                        Resource resource2 = resource;
                        collection.add(resource2);
                    }
                    collection = (List)destination$iv$iv;
                    resourceList2 = resourceList;
                    list = collection;
                } else {
                    list = CollectionsKt.emptyList();
                }
                resourceList2.setItems(list);
                object = resources.getItems();
                resourceList = resources;
                bl4 = false;
                int n5 = object.size();
                resourceList.setCount(n5);
                resources.setAltContentLink(ResourceType.Companion.fromType(resourceType).getPath(), ((ResourcesMetadata)metadata2).getContentPath());
                return resources;
            }
            catch (Exception ex$iv) {
                boolean $i$f$e = false;
                int level$iv$iv$iv = 6;
                boolean $i$f$log = false;
                if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Timber.e((Throwable)ex$iv);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return null;
    }

    public final void remove(@NotNull Resource resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        ResourceOracle.removeLinks$default(ResourceOracle.Companion.getShared(), resource, false, 2, null);
        if (this.isEnabled) {
            boolean $i$f$safeExecute = false;
            try {
                boolean bl = false;
                this.executor.execute(new Runnable(this, resource){
                    final /* synthetic */ ResourceCache this$0;
                    final /* synthetic */ Resource $resource$inlined;
                    {
                        this.this$0 = resourceCache;
                        this.$resource$inlined = resource;
                    }

                    public final void run() {
                        block0: {
                            File file = ResourceCacheKt.resourceCacheDir(ContextProvider.Companion.getAppContext(), this.$resource$inlined);
                            if (file == null) break block0;
                            FilesKt.deleteRecursively((File)file);
                        }
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception ex$iv) {
                boolean $i$f$e = false;
                int level$iv$iv$iv = 6;
                boolean $i$f$log = false;
                if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Timber.e((Throwable)ex$iv);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void remove(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        ResourceOracle.removeLinks$default(ResourceOracle.Companion.getShared(), resourceLocation, false, 2, null);
        if (this.isEnabled && !resourceLocation.isFeed()) {
            boolean $i$f$safeExecute = false;
            try {
                boolean bl = false;
                this.executor.execute(new Runnable(this, resourceLocation){
                    final /* synthetic */ ResourceCache this$0;
                    final /* synthetic */ ResourceLocation $resourceLocation$inlined;
                    {
                        this.this$0 = resourceCache;
                        this.$resourceLocation$inlined = resourceLocation;
                    }

                    public final void run() {
                        block0: {
                            File file = ResourceCacheKt.resourceCacheDir(ContextProvider.Companion.getAppContext(), this.$resourceLocation$inlined);
                            if (file == null) break block0;
                            FilesKt.deleteRecursively((File)file);
                        }
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception ex$iv) {
                boolean $i$f$e = false;
                int level$iv$iv$iv = 6;
                boolean $i$f$log = false;
                if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Timber.e((Throwable)ex$iv);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void purge() {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            ResourceOracle.Companion.getShared().purge();
            File databasesDir = new File(ResourceCacheKt.azureDataCacheDir(ContextProvider.Companion.getAppContext()), "dbs");
            File offersDir = new File(ResourceCacheKt.azureDataCacheDir(ContextProvider.Companion.getAppContext()), "offers");
            File queriesDir = new File(ResourceCacheKt.azureDataCacheDir(ContextProvider.Companion.getAppContext()), "queries");
            if (databasesDir.exists() && databasesDir.isDirectory()) {
                FilesKt.deleteRecursively((File)databasesDir);
            }
            if (offersDir.exists() && offersDir.isDirectory()) {
                FilesKt.deleteRecursively((File)offersDir);
            }
            if (queriesDir.exists() && queriesDir.isDirectory()) {
                FilesKt.deleteRecursively((File)queriesDir);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String encrypt(String data) {
        ResourceEncryptor resourceEncryptor2 = this.resourceEncryptor;
        if (resourceEncryptor2 != null) {
            ResourceEncryptor resourceEncryptor3 = resourceEncryptor2;
            boolean bl = false;
            boolean bl2 = false;
            ResourceEncryptor it = resourceEncryptor3;
            boolean bl3 = false;
            return it.encrypt(data);
        }
        return data;
    }

    private final String decrypt(String data) {
        ResourceEncryptor resourceEncryptor2 = this.resourceEncryptor;
        if (resourceEncryptor2 != null) {
            ResourceEncryptor resourceEncryptor3 = resourceEncryptor2;
            boolean bl = false;
            boolean bl2 = false;
            ResourceEncryptor it = resourceEncryptor3;
            boolean bl3 = false;
            return it.decrypt(data);
        }
        return data;
    }

    private ResourceCache() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newCachedThreadPool()");
        this.executor = executorService;
    }

    static {
        Companion = new Companion(null);
        shared = new ResourceCache();
    }

    public static final /* synthetic */ String access$encrypt(ResourceCache $this, String data) {
        return $this.encrypt(data);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/azure/data/service/ResourceCache$ResourcesMetadata;", "", "resourceId", "", "contentPath", "(Ljava/lang/String;Ljava/lang/String;)V", "getContentPath", "()Ljava/lang/String;", "getResourceId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "azuredata_release"})
    private static final class ResourcesMetadata {
        @NotNull
        private final String resourceId;
        @NotNull
        private final String contentPath;

        @NotNull
        public final String getResourceId() {
            return this.resourceId;
        }

        @NotNull
        public final String getContentPath() {
            return this.contentPath;
        }

        public ResourcesMetadata(@NotNull String resourceId, @NotNull String contentPath) {
            Intrinsics.checkParameterIsNotNull((Object)resourceId, (String)"resourceId");
            Intrinsics.checkParameterIsNotNull((Object)contentPath, (String)"contentPath");
            this.resourceId = resourceId;
            this.contentPath = contentPath;
        }

        @NotNull
        public final String component1() {
            return this.resourceId;
        }

        @NotNull
        public final String component2() {
            return this.contentPath;
        }

        @NotNull
        public final ResourcesMetadata copy(@NotNull String resourceId, @NotNull String contentPath) {
            Intrinsics.checkParameterIsNotNull((Object)resourceId, (String)"resourceId");
            Intrinsics.checkParameterIsNotNull((Object)contentPath, (String)"contentPath");
            return new ResourcesMetadata(resourceId, contentPath);
        }

        public static /* synthetic */ ResourcesMetadata copy$default(ResourcesMetadata resourcesMetadata, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = resourcesMetadata.resourceId;
            }
            if ((n & 2) != 0) {
                string2 = resourcesMetadata.contentPath;
            }
            return resourcesMetadata.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ResourcesMetadata(resourceId=" + this.resourceId + ", contentPath=" + this.contentPath + ")";
        }

        public int hashCode() {
            String string = this.resourceId;
            String string2 = this.contentPath;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ResourcesMetadata)) break block3;
                    ResourcesMetadata resourcesMetadata = (ResourcesMetadata)object;
                    if (!Intrinsics.areEqual((Object)this.resourceId, (Object)resourcesMetadata.resourceId) || !Intrinsics.areEqual((Object)this.contentPath, (Object)resourcesMetadata.contentPath)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/azure/data/service/ResourceCache$Companion;", "", "()V", "shared", "Lcom/azure/data/service/ResourceCache;", "getShared", "()Lcom/azure/data/service/ResourceCache;", "setShared", "(Lcom/azure/data/service/ResourceCache;)V", "azuredata_release"})
    public static final class Companion {
        @NotNull
        public final ResourceCache getShared() {
            return shared;
        }

        public final void setShared(@NotNull ResourceCache resourceCache) {
            Intrinsics.checkParameterIsNotNull((Object)resourceCache, (String)"<set-?>");
            shared = resourceCache;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

