/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.model.service;

import com.azure.core.http.ExtensionsKt;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpMediaType;
import com.azure.core.http.HttpMethod;
import com.azure.data.constants.MSHttpHeader;
import com.azure.data.model.Resource;
import com.azure.data.model.ResourceList;
import com.azure.data.model.partition.PartitionKeyRange;
import com.azure.data.model.partition.PartitionKeyResource;
import com.azure.data.model.service.DocumentClientError;
import com.azure.data.model.service.ResourceLocation;
import com.azure.data.service.PartitionKeyPropertyCache;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000 i2\u00020\u0001:\u0001iB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[J\t\u0010\\\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010]\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010^\u001a\u00020\u001d2\b\u0010_\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010`\u001a\u00020a2\u0006\u0010Z\u001a\u00020[J\t\u0010b\u001a\u00020'H\u00d6\u0001J\u001d\u0010c\u001a\u00020a\"\b\b\u0000\u0010d*\u00020e2\u0006\u0010f\u001a\u0002Hd\u00a2\u0006\u0002\u0010gJ\t\u0010h\u001a\u00020\u0005H\u00d6\u0001R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\n\"\u0004\b\u0018\u0010\fR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\n\"\u0004\b\u001b\u0010\fR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001e\"\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010%\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001e\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010,\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010-\u001a\u00020.X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001e\u00103\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010,\u001a\u0004\b4\u0010)\"\u0004\b5\u0010+R\"\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u000106X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\"\u0010;\u001a\n\u0012\u0004\u0012\u00020=\u0018\u00010<X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\"\u0010B\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\"\u0010H\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010E\"\u0004\bJ\u0010GR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u001c\u0010M\u001a\u0004\u0018\u00010NX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u001c\u0010S\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\n\"\u0004\bU\u0010\f\u00a8\u0006j"}, d2={"Lcom/azure/data/model/service/RequestDetails;", "", "resourceLocation", "Lcom/azure/data/model/service/ResourceLocation;", "partitionKey", "", "(Lcom/azure/data/model/service/ResourceLocation;Ljava/lang/String;)V", "(Lcom/azure/data/model/service/ResourceLocation;)V", "acceptEncoding", "getAcceptEncoding", "()Ljava/lang/String;", "setAcceptEncoding", "(Ljava/lang/String;)V", "body", "", "getBody", "()[B", "setBody", "([B)V", "cacheControl", "getCacheControl", "setCacheControl", "contentType", "getContentType", "setContentType", "ifNoneMatchETag", "getIfNoneMatchETag", "setIfNoneMatchETag", "isQuery", "", "()Z", "setQuery", "(Z)V", "isUpsert", "()Ljava/lang/Boolean;", "setUpsert", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "maxPerPage", "", "getMaxPerPage", "()Ljava/lang/Integer;", "setMaxPerPage", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "method", "Lcom/azure/core/http/HttpMethod;", "getMethod", "()Lcom/azure/core/http/HttpMethod;", "setMethod", "(Lcom/azure/core/http/HttpMethod;)V", "offerThroughput", "getOfferThroughput", "setOfferThroughput", "", "getPartitionKey", "()Ljava/util/List;", "setPartitionKey", "(Ljava/util/List;)V", "partitionKeyRange", "Lcom/azure/data/model/ResourceList;", "Lcom/azure/data/model/partition/PartitionKeyRange;", "getPartitionKeyRange", "()Lcom/azure/data/model/ResourceList;", "setPartitionKeyRange", "(Lcom/azure/data/model/ResourceList;)V", "postTriggers", "", "getPostTriggers", "()Ljava/util/Set;", "setPostTriggers", "(Ljava/util/Set;)V", "preTriggers", "getPreTriggers", "setPreTriggers", "getResourceLocation", "()Lcom/azure/data/model/service/ResourceLocation;", "resourceType", "Ljava/lang/reflect/Type;", "getResourceType", "()Ljava/lang/reflect/Type;", "setResourceType", "(Ljava/lang/reflect/Type;)V", "slug", "getSlug", "setSlug", "buildRequest", "Lokhttp3/Request;", "url", "Lokhttp3/HttpUrl;", "headersBuilder", "Lokhttp3/Headers$Builder;", "component1", "copy", "equals", "other", "fillHeaders", "", "hashCode", "setResourcePartitionKey", "T", "Lcom/azure/data/model/Resource;", "resource", "(Lcom/azure/data/model/Resource;)V", "toString", "Companion", "azuredata_release"})
public final class RequestDetails {
    @NotNull
    public HttpMethod method;
    @Nullable
    private List<String> partitionKey;
    @Nullable
    private Integer maxPerPage;
    @Nullable
    private transient byte[] body;
    @NotNull
    private String contentType;
    @Nullable
    private transient Type resourceType;
    private boolean isQuery;
    @Nullable
    private ResourceList<PartitionKeyRange> partitionKeyRange;
    @Nullable
    private Set<String> preTriggers;
    @Nullable
    private Set<String> postTriggers;
    @Nullable
    private String ifNoneMatchETag;
    @Nullable
    private Integer offerThroughput;
    @Nullable
    private Boolean isUpsert;
    @Nullable
    private String slug;
    @Nullable
    private String acceptEncoding;
    @Nullable
    private String cacheControl;
    @NotNull
    private final ResourceLocation resourceLocation;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final HttpMethod getMethod() {
        HttpMethod httpMethod = this.method;
        if (httpMethod == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"method");
        }
        return httpMethod;
    }

    public final void setMethod(@NotNull HttpMethod httpMethod) {
        Intrinsics.checkParameterIsNotNull((Object)httpMethod, (String)"<set-?>");
        this.method = httpMethod;
    }

    @Nullable
    public final List<String> getPartitionKey() {
        return this.partitionKey;
    }

    public final void setPartitionKey(@Nullable List<String> list) {
        this.partitionKey = list;
    }

    @Nullable
    public final Integer getMaxPerPage() {
        return this.maxPerPage;
    }

    public final void setMaxPerPage(@Nullable Integer n) {
        this.maxPerPage = n;
    }

    @Nullable
    public final byte[] getBody() {
        return this.body;
    }

    public final void setBody(@Nullable byte[] byArray) {
        this.body = byArray;
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    public final void setContentType(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.contentType = string;
    }

    @Nullable
    public final Type getResourceType() {
        return this.resourceType;
    }

    public final void setResourceType(@Nullable Type type) {
        this.resourceType = type;
    }

    public final boolean isQuery() {
        return this.isQuery;
    }

    public final void setQuery(boolean bl) {
        this.isQuery = bl;
    }

    @Nullable
    public final ResourceList<PartitionKeyRange> getPartitionKeyRange() {
        return this.partitionKeyRange;
    }

    public final void setPartitionKeyRange(@Nullable ResourceList<PartitionKeyRange> resourceList) {
        this.partitionKeyRange = resourceList;
    }

    @Nullable
    public final Set<String> getPreTriggers() {
        return this.preTriggers;
    }

    public final void setPreTriggers(@Nullable Set<String> set) {
        this.preTriggers = set;
    }

    @Nullable
    public final Set<String> getPostTriggers() {
        return this.postTriggers;
    }

    public final void setPostTriggers(@Nullable Set<String> set) {
        this.postTriggers = set;
    }

    @Nullable
    public final String getIfNoneMatchETag() {
        return this.ifNoneMatchETag;
    }

    public final void setIfNoneMatchETag(@Nullable String string) {
        this.ifNoneMatchETag = string;
    }

    @Nullable
    public final Integer getOfferThroughput() {
        return this.offerThroughput;
    }

    public final void setOfferThroughput(@Nullable Integer n) {
        this.offerThroughput = n;
    }

    @Nullable
    public final Boolean isUpsert() {
        return this.isUpsert;
    }

    public final void setUpsert(@Nullable Boolean bl) {
        this.isUpsert = bl;
    }

    @Nullable
    public final String getSlug() {
        return this.slug;
    }

    public final void setSlug(@Nullable String string) {
        this.slug = string;
    }

    @Nullable
    public final String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public final void setAcceptEncoding(@Nullable String string) {
        this.acceptEncoding = string;
    }

    @Nullable
    public final String getCacheControl() {
        return this.cacheControl;
    }

    public final void setCacheControl(@Nullable String string) {
        this.cacheControl = string;
    }

    public final <T extends Resource> void setResourcePartitionKey(@NotNull T resource) {
        Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
        if (resource instanceof PartitionKeyResource) {
            Collection collection = this.partitionKey;
            boolean bl = false;
            boolean bl2 = false;
            if (collection == null || collection.isEmpty()) {
                this.partitionKey = PartitionKeyPropertyCache.Companion.getPartitionKeyValues(resource);
            }
        }
    }

    public final void fillHeaders(@NotNull Headers.Builder headersBuilder) {
        block21: {
            int max;
            boolean bl;
            boolean bl2;
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)headersBuilder, (String)"headersBuilder");
            Integer n = this.maxPerPage;
            if (n != null) {
                object = n;
                bl2 = false;
                bl = false;
                max = ((Number)object).intValue();
                boolean bl3 = false;
                int n2 = 1;
                if (new IntRange(n2, 1000).contains(max)) {
                    headersBuilder.add(MSHttpHeader.MSMaxItemCount.getValue(), String.valueOf(max));
                } else {
                    throw (Throwable)DocumentClientError.Companion.getInvalidMaxPerPageError();
                }
            }
            object = this.partitionKey;
            bl2 = false;
            bl = false;
            if (!(object == null || object.isEmpty())) {
                List<String> list = this.partitionKey;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                Function1 function1 = null;
                CharSequence charSequence = null;
                max = 0;
                CharSequence bl3 = "\",\"";
                CharSequence charSequence2 = "\"]";
                CharSequence charSequence3 = "[\"";
                String partitionKeyValue = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)bl3, (CharSequence)charSequence3, (CharSequence)charSequence2, (int)max, charSequence, function1, (int)56, null);
                headersBuilder.add(MSHttpHeader.MSDocumentDBPartitionKey.getValue(), partitionKeyValue);
            }
            if (this.isQuery) {
                headersBuilder.add(MSHttpHeader.MSDocumentDBIsQuery.getValue(), "True");
                this.contentType = HttpMediaType.QueryJson.getValue();
                object = this.partitionKey;
                boolean bl4 = false;
                boolean bl5 = false;
                if (object == null || object.isEmpty()) {
                    headersBuilder.add(MSHttpHeader.MSDocumentDBQueryEnableCrossPartition.getValue(), "True");
                }
            }
            ResourceList<PartitionKeyRange> resourceList = this.partitionKeyRange;
            if (resourceList != null) {
                object = resourceList;
                boolean bl6 = false;
                boolean bl7 = false;
                ResourceList<PartitionKeyRange> it = object;
                boolean bl8 = false;
                Collection collection = it.getItems();
                boolean bl9 = false;
                if (!collection.isEmpty()) {
                    String string = MSHttpHeader.MSDocumentDBPartitionKeyRangeId.getValue();
                    StringBuilder stringBuilder = new StringBuilder();
                    String string2 = it.getResourceId();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    headersBuilder.add(string, stringBuilder.append(string2).append(',').append(it.getItems().get(0).getId()).toString());
                }
            }
            if (this.body != null) {
                headersBuilder.add(HttpHeader.ContentType.getValue(), this.contentType);
            }
            Set<String> set = this.postTriggers;
            if (set != null) {
                object = set;
                boolean bl10 = false;
                boolean bl11 = false;
                Set<String> it = object;
                boolean bl12 = false;
                Collection collection = it;
                boolean bl13 = false;
                if (!collection.isEmpty()) {
                    String postTriggerInclude = CollectionsKt.joinToString$default((Iterable)it, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                    headersBuilder.add(MSHttpHeader.MSDocumentDBPostTriggerInclude.getValue(), postTriggerInclude);
                }
            }
            Set<String> set2 = this.preTriggers;
            if (set2 != null) {
                object = set2;
                boolean bl14 = false;
                boolean bl15 = false;
                Object it = object;
                boolean bl16 = false;
                Collection postTriggerInclude = (Collection)it;
                boolean bl17 = false;
                if (!postTriggerInclude.isEmpty()) {
                    String preTriggerInclude = CollectionsKt.joinToString$default((Iterable)((Iterable)it), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                    headersBuilder.add(MSHttpHeader.MSDocumentDBPreTriggerInclude.getValue(), preTriggerInclude);
                }
            }
            object = this.ifNoneMatchETag;
            boolean bl18 = false;
            boolean bl19 = false;
            if (!(object == null || object.length() == 0)) {
                String string = HttpHeader.IfNoneMatch.getValue();
                String string3 = this.ifNoneMatchETag;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                headersBuilder.add(string, string3);
            }
            Integer n3 = this.offerThroughput;
            if (n3 != null) {
                object = n3;
                bl18 = false;
                bl19 = false;
                int it = ((Number)object).intValue();
                boolean bl20 = false;
                headersBuilder.add(MSHttpHeader.MSOfferThroughput.getValue(), String.valueOf(it));
            }
            Boolean bl21 = this.isUpsert;
            if (bl21 != null) {
                object = bl21;
                bl18 = false;
                bl19 = false;
                boolean it = (Boolean)object;
                boolean bl22 = false;
                headersBuilder.add(MSHttpHeader.MSDocumentDBIsUpsert.getValue(), String.valueOf(this.isUpsert));
            }
            String string = this.slug;
            if (string != null) {
                object = string;
                bl18 = false;
                bl19 = false;
                Object it = object;
                boolean bl23 = false;
                headersBuilder.add(HttpHeader.Slug.getValue(), (String)it);
            }
            String string4 = this.acceptEncoding;
            if (string4 != null) {
                object = string4;
                bl18 = false;
                bl19 = false;
                Object it = object;
                boolean bl24 = false;
                headersBuilder.add(HttpHeader.Accept.getValue(), (String)it);
            }
            String string5 = this.cacheControl;
            if (string5 == null) break block21;
            object = string5;
            bl18 = false;
            bl19 = false;
            Object it = object;
            boolean bl25 = false;
            headersBuilder.add(HttpHeader.CacheControl.getValue(), (String)it);
        }
    }

    @NotNull
    public final Request buildRequest(@NotNull HttpUrl url, @NotNull Headers.Builder headersBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)headersBuilder, (String)"headersBuilder");
        Request.Builder builder = new Request.Builder().headers(headersBuilder.build()).url(url);
        HttpMethod httpMethod = this.method;
        if (httpMethod == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"method");
        }
        return ExtensionsKt.withMethod((Request.Builder)builder, (HttpMethod)httpMethod, this.body != null ? RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])this.body, (MediaType)MediaType.Companion.parse(this.contentType), (int)0, (int)0, (int)6, null) : null).build();
    }

    @NotNull
    public final ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public RequestDetails(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        this.resourceLocation = resourceLocation;
        this.contentType = HttpMediaType.Json.getValue();
    }

    public RequestDetails(@NotNull ResourceLocation resourceLocation, @Nullable String partitionKey) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
            this(resourceLocation);
            String string = partitionKey;
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.partitionKey = CollectionsKt.listOf((Object)partitionKey);
        }
    }

    @NotNull
    public final ResourceLocation component1() {
        return this.resourceLocation;
    }

    @NotNull
    public final RequestDetails copy(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        return new RequestDetails(resourceLocation);
    }

    public static /* synthetic */ RequestDetails copy$default(RequestDetails requestDetails, ResourceLocation resourceLocation, int n, Object object) {
        if ((n & 1) != 0) {
            resourceLocation = requestDetails.resourceLocation;
        }
        return requestDetails.copy(resourceLocation);
    }

    @NotNull
    public String toString() {
        return "RequestDetails(resourceLocation=" + this.resourceLocation + ")";
    }

    public int hashCode() {
        ResourceLocation resourceLocation = this.resourceLocation;
        return resourceLocation != null ? resourceLocation.hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof RequestDetails)) break block3;
                RequestDetails requestDetails = (RequestDetails)object;
                if (!Intrinsics.areEqual((Object)this.resourceLocation, (Object)requestDetails.resourceLocation)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u0002H\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/azure/data/model/service/RequestDetails$Companion;", "", "()V", "fromResource", "Lcom/azure/data/model/service/RequestDetails;", "T", "Lcom/azure/data/model/Resource;", "resource", "partitionKey", "", "(Lcom/azure/data/model/Resource;Ljava/lang/String;)Lcom/azure/data/model/service/RequestDetails;", "azuredata_release"})
    public static final class Companion {
        @NotNull
        public final <T extends Resource> RequestDetails fromResource(@NotNull T resource, @Nullable String partitionKey) {
            Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
            RequestDetails details = new RequestDetails(new ResourceLocation.Resource(resource));
            details.setResourceType(resource.getClass());
            String string = partitionKey;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                details.setPartitionKey(CollectionsKt.listOf((Object)it));
            } else {
                Companion companion = this;
                boolean bl = false;
                boolean bl4 = false;
                Companion $this$run = companion;
                boolean bl5 = false;
                details.setResourcePartitionKey(resource);
            }
            return details;
        }

        public static /* synthetic */ RequestDetails fromResource$default(Companion companion, Resource resource, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.fromResource(resource, string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

