/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import android.content.Intent;
import com.azure.core.http.HttpStatusCode;
import com.azure.core.log.LoggerKt;
import com.azure.core.util.ContextProvider;
import com.azure.data.constants.MSHttpHeader;
import com.azure.data.model.Resource;
import com.azure.data.model.service.DataError;
import com.azure.data.model.service.DocumentClientError;
import com.azure.data.model.service.RequestDetails;
import com.azure.data.model.service.ResourceLocation;
import com.azure.data.model.service.ResourceWriteOperation;
import com.azure.data.model.service.ResourceWriteOperationType;
import com.azure.data.model.service.Response;
import com.azure.data.model.service.ResponseKt;
import com.azure.data.model.service.Result;
import com.azure.data.service.DocumentClient;
import com.azure.data.service.ResourceCache;
import com.azure.data.service.ResourceCacheKt;
import com.azure.data.service.ResourceWriteOperationQueue;
import com.azure.data.service.ResourceWriteOperationQueue$WhenMappings;
import com.azure.data.service.ResourceWriteOperationQueueKt;
import com.azure.data.util.ResourceOracle;
import com.azure.data.util.ResourceValidationKt;
import com.azure.data.util.StringExtensionsKt;
import com.azure.data.util.json.GsonConfigKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00062\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u0015\u0012\u0004\u0012\u00020\f0\u0014\u00a2\u0006\u0002\u0010\u0016J,\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u001c\u0010\u0013\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00180\u0015j\u0002`\u0019\u0012\u0004\u0012\u00020\f0\u0014JK\u0010\u001a\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00062\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u0015\u0012\u0004\u0012\u00020\f0\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J.\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u001c\u0010\u0013\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00180\u0015j\u0002`\u0019\u0012\u0004\u0012\u00020\f0\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\b\u0010\u001e\u001a\u00020\fH\u0002J*\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\t2\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0015\u0012\u0004\u0012\u00020\f0\u0014H\u0002J*\u0010 \u001a\u00020\f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0014H\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0006\u0010\"\u001a\u00020\fJ\b\u0010#\u001a\u00020\fH\u0002J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u001c\u0010&\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H\r0\u0015H\u0002J\b\u0010(\u001a\u00020\fH\u0002J\u0006\u0010)\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/azure/data/service/ResourceWriteOperationQueue;", "", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "isSyncing", "", "processedWrites", "", "Lcom/azure/data/model/service/ResourceWriteOperation;", "writes", "addCreateOrReplace", "", "T", "Lcom/azure/data/model/Resource;", "resource", "requestDetails", "Lcom/azure/data/model/service/RequestDetails;", "replace", "callback", "Lkotlin/Function1;", "Lcom/azure/data/model/service/Response;", "(Lcom/azure/data/model/Resource;Lcom/azure/data/model/service/RequestDetails;ZLkotlin/jvm/functions/Function1;)V", "addDelete", "", "Lcom/azure/data/model/service/DataResponse;", "createOrReplaceOffline", "deleteOffline", "enqueueWrite", "write", "load", "performWrite", "performWrites", "persistWriteOnDisk", "purge", "removeCachedResources", "removeWrite", "removeWriteFromDisk", "sendBroadcast", "response", "sendOfflineWriteQueueProcessedBroadcast", "sync", "Companion", "azuredata_release"})
public final class ResourceWriteOperationQueue {
    private List<ResourceWriteOperation> writes;
    private List<ResourceWriteOperation> processedWrites;
    private boolean isSyncing;
    private final ExecutorService executor;
    @NotNull
    private static final Lazy shared$delegate;
    public static final Companion Companion;

    public final <T extends Resource> void addCreateOrReplace(@NotNull T resource, @NotNull RequestDetails requestDetails, boolean replace, @NotNull Function1<? super Response<T>, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
        Intrinsics.checkParameterIsNotNull((Object)requestDetails, (String)"requestDetails");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createOrReplaceOffline(resource, requestDetails, replace, (Function1)new Function1<Response<T>, Unit>(this, callback, replace, resource, requestDetails){
            final /* synthetic */ ResourceWriteOperationQueue this$0;
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ boolean $replace;
            final /* synthetic */ Resource $resource;
            final /* synthetic */ RequestDetails $requestDetails;

            public final void invoke(@NotNull Response<T> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                this.$callback.invoke(response);
                if (response.isSuccessful()) {
                    ResourceWriteOperationType resourceWriteOperationType = this.$replace ? ResourceWriteOperationType.Replace : ResourceWriteOperationType.Create;
                    Object object = response.getResponse();
                    if (object == null || (object = object.header(MSHttpHeader.MSContentPath.getValue())) == null) {
                        object = "";
                    }
                    ResourceWriteOperationQueue.access$enqueueWrite(this.this$0, new ResourceWriteOperation(resourceWriteOperationType, this.$resource, this.$requestDetails, (String)object));
                }
            }
            {
                this.this$0 = resourceWriteOperationQueue;
                this.$callback = function1;
                this.$replace = bl;
                this.$resource = resource;
                this.$requestDetails = requestDetails;
                super(1);
            }
        });
    }

    public static /* synthetic */ void addCreateOrReplace$default(ResourceWriteOperationQueue resourceWriteOperationQueue, Resource resource, RequestDetails requestDetails, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        resourceWriteOperationQueue.addCreateOrReplace(resource, requestDetails, bl, function1);
    }

    public final void addDelete(@NotNull RequestDetails requestDetails, @NotNull Function1<? super Response<String>, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)requestDetails, (String)"requestDetails");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.deleteOffline(requestDetails, (Function1<? super Response<String>, Unit>)((Function1)new Function1<Response<String>, Unit>(this, callback, requestDetails){
            final /* synthetic */ ResourceWriteOperationQueue this$0;
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ RequestDetails $requestDetails;

            public final void invoke(@NotNull Response<String> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                this.$callback.invoke(response);
                if (response.isSuccessful()) {
                    Object object = response.getResponse();
                    if (object == null || (object = object.header(MSHttpHeader.MSContentPath.getValue())) == null) {
                        object = "";
                    }
                    ResourceWriteOperationQueue.access$enqueueWrite(this.this$0, new ResourceWriteOperation(ResourceWriteOperationType.Delete, null, this.$requestDetails, (String)object));
                }
            }
            {
                this.this$0 = resourceWriteOperationQueue;
                this.$callback = function1;
                this.$requestDetails = requestDetails;
                super(1);
            }
        }));
    }

    public final void sync() {
        this.executor.execute(new Runnable(this){
            final /* synthetic */ ResourceWriteOperationQueue this$0;

            public final void run() {
                if (ResourceWriteOperationQueue.access$isSyncing$p(this.this$0) || ResourceWriteOperationQueue.access$getWrites$p(this.this$0).isEmpty()) {
                    return;
                }
                List writes = ResourceWriteOperationQueueKt.access$sortedByResourceType(ResourceWriteOperationQueue.access$getWrites$p(this.this$0));
                ResourceWriteOperationQueue.access$setSyncing$p(this.this$0, true);
                ResourceWriteOperationQueue.access$performWrites(this.this$0, writes, (Function1)new Function1<Boolean, Unit>(this){
                    final /* synthetic */ sync.1 this$0;

                    public final void invoke(boolean isSuccess) {
                        if (isSuccess) {
                            ResourceWriteOperationQueue.access$sendOfflineWriteQueueProcessedBroadcast(this.this$0.this$0);
                        }
                        ResourceWriteOperationQueue.access$removeCachedResources(this.this$0.this$0);
                        ResourceWriteOperationQueue.access$setSyncing$p(this.this$0.this$0, false);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = resourceWriteOperationQueue;
            }
        });
    }

    public final void purge() {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            FilesKt.deleteRecursively((File)ResourceWriteOperationQueueKt.access$pendingWritesDir(ContextProvider.Companion.getAppContext()));
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void load() {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            this.executor.execute(new Runnable(this){
                final /* synthetic */ ResourceWriteOperationQueue this$0;
                {
                    this.this$0 = resourceWriteOperationQueue;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void run() {
                    Collection<ResourceWriteOperation> collection;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = ResourceWriteOperationQueueKt.access$pendingWritesFiles(ContextProvider.Companion.getAppContext());
                    ResourceWriteOperationQueue resourceWriteOperationQueue = this.this$0;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        ResourceWriteOperation resourceWriteOperation;
                        void it;
                        File file = (File)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Closeable closeable = it;
                        Charset charset = Charsets.UTF_8;
                        int n = 8192;
                        boolean bl2 = false;
                        Reader reader = closeable;
                        boolean bl3 = false;
                        InputStream inputStream = reader;
                        boolean bl4 = false;
                        inputStream = new FileInputStream((File)((Object)inputStream));
                        bl4 = false;
                        reader = new InputStreamReader(inputStream, charset);
                        bl3 = false;
                        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                        boolean bl5 = false;
                        Throwable throwable = null;
                        try {
                            BufferedReader reader2 = (BufferedReader)closeable;
                            boolean bl6 = false;
                            resourceWriteOperation = (ResourceWriteOperation)GsonConfigKt.getGson().fromJson(TextStreamsKt.readText((Reader)reader2), ResourceWriteOperation.class);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        ResourceWriteOperation resourceWriteOperation2 = resourceWriteOperation;
                        collection.add(resourceWriteOperation2);
                    }
                    collection = (List)destination$iv$iv;
                    ResourceWriteOperationQueue.access$setWrites$p(resourceWriteOperationQueue, CollectionsKt.toMutableList((Collection)collection));
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void performWrites(List<ResourceWriteOperation> writes, Function1<? super Boolean, Unit> callback) {
        if (writes.isEmpty()) {
            callback.invoke((Object)true);
            return;
        }
        ResourceWriteOperation write = writes.remove(0);
        this.performWrite(write, (Function1<? super Response<Unit>, Unit>)((Function1)new Function1<Response<Unit>, Unit>(this, write, writes, callback){
            final /* synthetic */ ResourceWriteOperationQueue this$0;
            final /* synthetic */ ResourceWriteOperation $write;
            final /* synthetic */ List $writes;
            final /* synthetic */ Function1 $callback;

            public final void invoke(@NotNull Response<Unit> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                if (!response.getFromCache()) {
                    ResourceWriteOperationQueue.access$getProcessedWrites$p(this.this$0).add(this.$write);
                    ResourceWriteOperationQueue.access$sendBroadcast(this.this$0, response);
                    ResourceWriteOperationQueue.access$removeWrite(this.this$0, this.$write);
                }
                ResourceWriteOperationQueue.access$performWrites(this.this$0, this.$writes, this.$callback);
            }
            {
                this.this$0 = resourceWriteOperationQueue;
                this.$write = resourceWriteOperation;
                this.$writes = list;
                this.$callback = function1;
                super(1);
            }
        }));
    }

    private final void performWrite(ResourceWriteOperation write, Function1<? super Response<Unit>, Unit> callback) {
        switch (ResourceWriteOperationQueue$WhenMappings.$EnumSwitchMapping$0[write.getType().ordinal()]) {
            case 1: {
                DocumentClient documentClient = DocumentClient.Companion.getShared();
                Resource resource = write.getResource();
                if (resource == null) {
                    Intrinsics.throwNpe();
                }
                documentClient.createOrReplace$azuredata_release(resource, write.getRequestDetails(), false, (Function1)new Function1<Response<Resource>, Unit>(callback){
                    final /* synthetic */ Function1 $callback;

                    public final void invoke(@NotNull Response<Resource> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        this.$callback.invoke(ResponseKt.map(it, (Function1)performWrite.1.INSTANCE));
                    }
                    {
                        this.$callback = function1;
                        super(1);
                    }
                });
                break;
            }
            case 2: {
                DocumentClient documentClient = DocumentClient.Companion.getShared();
                Resource resource = write.getResource();
                if (resource == null) {
                    Intrinsics.throwNpe();
                }
                documentClient.createOrReplace$azuredata_release(resource, write.getRequestDetails(), true, (Function1)new Function1<Response<Resource>, Unit>(callback){
                    final /* synthetic */ Function1 $callback;

                    public final void invoke(@NotNull Response<Resource> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        this.$callback.invoke(ResponseKt.map(it, (Function1)performWrite.1.INSTANCE));
                    }
                    {
                        this.$callback = function1;
                        super(1);
                    }
                });
                break;
            }
            case 3: {
                DocumentClient documentClient = DocumentClient.Companion.getShared();
                Resource resource = write.getResource();
                if (resource == null) {
                    Intrinsics.throwNpe();
                }
                DocumentClient.delete$default(documentClient, resource, null, performWrite.3.INSTANCE, 2, null);
            }
        }
    }

    private final void enqueueWrite(ResourceWriteOperation write) {
        this.executor.execute(new Runnable(this, write){
            final /* synthetic */ ResourceWriteOperationQueue this$0;
            final /* synthetic */ ResourceWriteOperation $write;

            public final void run() {
                int index = ResourceWriteOperationQueue.access$getWrites$p(this.this$0).indexOf(this.$write);
                if (index < 0) {
                    ResourceWriteOperationQueue.access$getWrites$p(this.this$0).add(this.$write);
                    ResourceWriteOperationQueue.access$persistWriteOnDisk(this.this$0, this.$write);
                    return;
                }
                ResourceWriteOperation existingWrite = (ResourceWriteOperation)ResourceWriteOperationQueue.access$getWrites$p(this.this$0).get(index);
                Pair pair = new Pair((Object)((Object)existingWrite.getType()), (Object)((Object)this.$write.getType()));
                if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)((Object)ResourceWriteOperationType.Create), (Object)((Object)ResourceWriteOperationType.Replace)))) {
                    ResourceWriteOperationQueue.access$getWrites$p(this.this$0).set(index, ResourceWriteOperationQueueKt.access$withType(this.$write, ResourceWriteOperationType.Create));
                    ResourceWriteOperationQueue.access$removeWriteFromDisk(this.this$0, existingWrite);
                    ResourceWriteOperationQueue.access$persistWriteOnDisk(this.this$0, this.$write);
                } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)((Object)ResourceWriteOperationType.Create), (Object)((Object)ResourceWriteOperationType.Delete)))) {
                    ResourceWriteOperationQueue.access$getWrites$p(this.this$0).remove(index);
                    ResourceWriteOperationQueue.access$removeWriteFromDisk(this.this$0, existingWrite);
                } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)((Object)ResourceWriteOperationType.Replace), (Object)((Object)ResourceWriteOperationType.Delete)))) {
                    ResourceWriteOperationQueue.access$getWrites$p(this.this$0).set(index, this.$write);
                    ResourceWriteOperationQueue.access$removeWriteFromDisk(this.this$0, existingWrite);
                    ResourceWriteOperationQueue.access$persistWriteOnDisk(this.this$0, this.$write);
                } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)((Object)ResourceWriteOperationType.Replace), (Object)((Object)ResourceWriteOperationType.Replace)))) {
                    ResourceWriteOperationQueue.access$getWrites$p(this.this$0).set(index, this.$write);
                    ResourceWriteOperationQueue.access$removeWriteFromDisk(this.this$0, existingWrite);
                    ResourceWriteOperationQueue.access$persistWriteOnDisk(this.this$0, this.$write);
                }
            }
            {
                this.this$0 = resourceWriteOperationQueue;
                this.$write = resourceWriteOperation;
            }
        });
    }

    private final void removeWrite(ResourceWriteOperation write) {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            int index = this.writes.indexOf(write);
            if (index < 0) {
                this.writes.remove(index);
                this.removeWriteFromDisk(write);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void removeCachedResources() {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            while (!this.processedWrites.isEmpty()) {
                Collection collection = this.processedWrites;
                List<ResourceWriteOperation> list = this.processedWrites;
                boolean bl2 = false;
                int n = collection.size();
                ResourceWriteOperation write = list.remove(n - 1);
                FilesKt.deleteRecursively((File)new File(new URI(ResourceCacheKt.azureDataCacheDir(ContextProvider.Companion.getAppContext()).getAbsolutePath() + '/' + write.getResourceLocalContentPath())));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final <T extends Resource> void createOrReplaceOffline(T resource, RequestDetails requestDetails, boolean replace, Function1<? super Response<T>, Unit> callback) {
        String string;
        CharSequence request;
        boolean bl;
        boolean bl2;
        CharSequence charSequence;
        if (!ResourceValidationKt.isValidIdForResource(resource.getId())) {
            callback.invoke(new Response(new DataError(DocumentClientError.Companion.getInvalidId()), null, null, null, false, 30, null));
            return;
        }
        String altLink = requestDetails.getResourceLocation().altLink(resource.getId());
        String knownSelfLink = ResourceOracle.Companion.getShared().getSelfLink(altLink);
        if (replace) {
            charSequence = knownSelfLink;
            bl2 = false;
            bl = false;
            if (charSequence == null || charSequence.length() == 0) {
                request = new Request.Builder().url("https://localhost/" + altLink).build();
                Response.Builder builder = new Response.Builder().request((Request)request).protocol(Protocol.HTTP_1_1).code(HttpStatusCode.NotFound.getCode());
                String string2 = DocumentClientError.Companion.getNotFound().getMessage();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                okhttp3.Response response = builder.message(string2).build();
                callback.invoke(new Response(new DataError(DocumentClientError.Companion.getNotFound()), (Request)request, response, null, true));
                return;
            }
        }
        if (!replace) {
            request = knownSelfLink;
            boolean response = false;
            bl = false;
            if (!(request == null || request.length() == 0)) {
                request = new Request.Builder().url("https://localhost/" + altLink).build();
                Response.Builder builder = new Response.Builder().request((Request)request).protocol(Protocol.HTTP_1_1).code(HttpStatusCode.Conflict.getCode());
                String string3 = DocumentClientError.Companion.getConflict().getMessage();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                okhttp3.Response response2 = builder.message(string3).build();
                callback.invoke(new Response(new DataError(DocumentClientError.Companion.getConflict()), (Request)request, response2, null, true));
                return;
            }
        }
        if ((string = knownSelfLink) == null) {
            ResourceLocation resourceLocation = requestDetails.getResourceLocation();
            String string4 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"UUID.randomUUID().toString()");
            string = resourceLocation.selfLink(string4);
        }
        if (string != null) {
            charSequence = string;
            bl2 = false;
            bl = false;
            CharSequence selfLink = charSequence;
            boolean bl3 = false;
            ResourceOracle.Companion.getShared().storeLinks((String)selfLink, altLink);
            resource.setAltLink(altLink);
            ResourceCache.Companion.getShared().cache(resource);
            Request request2 = new Request.Builder().url("https://localhost/" + (String)selfLink).build();
            okhttp3.Response response = new Response.Builder().request(request2).protocol(Protocol.HTTP_1_1).code(replace ? HttpStatusCode.Ok.getCode() : HttpStatusCode.Created.getCode()).addHeader(MSHttpHeader.MSContentPath.getValue(), (String)selfLink).addHeader(MSHttpHeader.MSAltContentPath.getValue(), StringExtensionsKt.ancestorPath(altLink)).message(GsonConfigKt.getGson().toJson(resource)).build();
            callback.invoke(new Response(request2, response, null, new Result(resource, null, 2, null), requestDetails.getResourceLocation(), requestDetails.getResourceLocation().getResourceType().getType(), true));
            return;
        }
        callback.invoke(new Response(new DataError(DocumentClientError.Companion.getInternalError()), null, null, null, false, 30, null));
    }

    static /* synthetic */ void createOrReplaceOffline$default(ResourceWriteOperationQueue resourceWriteOperationQueue, Resource resource, RequestDetails requestDetails, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        resourceWriteOperationQueue.createOrReplaceOffline(resource, requestDetails, bl, function1);
    }

    private final void deleteOffline(RequestDetails requestDetails, Function1<? super Response<String>, Unit> callback) {
        String string = ResourceOracle.Companion.getShared().getSelfLink(requestDetails.getResourceLocation().link());
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String selfLink = string2;
            boolean bl3 = false;
            ResourceCache.Companion.getShared().remove(requestDetails.getResourceLocation());
            Request request = new Request.Builder().url("https://com.azuredata.cache/" + selfLink).build();
            okhttp3.Response response = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(HttpStatusCode.NoContent.getCode()).addHeader(MSHttpHeader.MSContentPath.getValue(), selfLink).addHeader(MSHttpHeader.MSAltContentPath.getValue(), StringExtensionsKt.ancestorPath(requestDetails.getResourceLocation().link())).message("").build();
            callback.invoke(new Response(request, response, null, new Result("", null, 2, null), requestDetails.getResourceLocation(), requestDetails.getResourceLocation().getResourceType().getType(), true));
            return;
        }
        Request request = new Request.Builder().url("https://localhost/" + requestDetails.getResourceLocation().link()).build();
        Response.Builder builder = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(HttpStatusCode.NotFound.getCode());
        String string3 = DocumentClientError.Companion.getNotFound().getMessage();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        okhttp3.Response response = builder.message(string3).build();
        callback.invoke(new Response(new DataError(DocumentClientError.Companion.getNotFound()), request, response, null, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void persistWriteOnDisk(ResourceWriteOperation write) {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            Object object = ResourceWriteOperationQueueKt.access$resourceWriteOperationFile(ContextProvider.Companion.getAppContext(), write);
            Charset charset = Charsets.UTF_8;
            int n = 8192;
            boolean bl2 = false;
            Object object2 = object;
            boolean bl3 = false;
            Object object3 = object2;
            boolean bl4 = false;
            object3 = new FileOutputStream((File)object3);
            bl4 = false;
            object2 = new OutputStreamWriter((OutputStream)object3, charset);
            bl3 = false;
            object = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
            boolean bl5 = false;
            Throwable throwable = null;
            try {
                BufferedWriter it = (BufferedWriter)object;
                boolean bl6 = false;
                it.write(GsonConfigKt.getGson().toJson((Object)write));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void removeWriteFromDisk(ResourceWriteOperation write) {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            ResourceWriteOperationQueueKt.access$resourceWriteOperationFile(ContextProvider.Companion.getAppContext(), write).delete();
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final <T> void sendBroadcast(Response<T> response) {
        Intent intent = new Intent();
        if (response.isSuccessful()) {
            intent.setAction("com.azuredata.data.OFFLINE_RESOURCE_SYNC_SUCCEEDED");
            intent.putExtra("data", response.getJsonData());
        } else {
            intent.setAction("com.azuredata.data.OFFLINE_RESOURCE_SYNC_FAILED");
            intent.putExtra("error", response.getJsonData());
        }
        ContextProvider.Companion.getAppContext().sendBroadcast(intent);
    }

    private final void sendOfflineWriteQueueProcessedBroadcast() {
        ContextProvider.Companion.getAppContext().sendBroadcast(new Intent("com.azuredata.data.OFFLINE_WRITE_OPERATION_QUEUE.PROCESSED"));
    }

    public ResourceWriteOperationQueue() {
        List list;
        ResourceWriteOperationQueue resourceWriteOperationQueue = this;
        boolean bl = false;
        resourceWriteOperationQueue.writes = list = (List)new ArrayList();
        resourceWriteOperationQueue = this;
        bl = false;
        resourceWriteOperationQueue.processedWrites = list = (List)new ArrayList();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        this.executor = executorService;
    }

    static {
        Companion = new Companion(null);
        shared$delegate = LazyKt.lazy((Function0)Companion.shared.2.INSTANCE);
    }

    public static final /* synthetic */ void access$enqueueWrite(ResourceWriteOperationQueue $this, ResourceWriteOperation write) {
        $this.enqueueWrite(write);
    }

    public static final /* synthetic */ boolean access$isSyncing$p(ResourceWriteOperationQueue $this) {
        return $this.isSyncing;
    }

    public static final /* synthetic */ void access$setSyncing$p(ResourceWriteOperationQueue $this, boolean bl) {
        $this.isSyncing = bl;
    }

    public static final /* synthetic */ List access$getWrites$p(ResourceWriteOperationQueue $this) {
        return $this.writes;
    }

    public static final /* synthetic */ void access$setWrites$p(ResourceWriteOperationQueue $this, List list) {
        $this.writes = list;
    }

    public static final /* synthetic */ void access$performWrites(ResourceWriteOperationQueue $this, List writes, Function1 callback) {
        $this.performWrites(writes, (Function1<? super Boolean, Unit>)callback);
    }

    public static final /* synthetic */ void access$sendOfflineWriteQueueProcessedBroadcast(ResourceWriteOperationQueue $this) {
        $this.sendOfflineWriteQueueProcessedBroadcast();
    }

    public static final /* synthetic */ void access$removeCachedResources(ResourceWriteOperationQueue $this) {
        $this.removeCachedResources();
    }

    public static final /* synthetic */ List access$getProcessedWrites$p(ResourceWriteOperationQueue $this) {
        return $this.processedWrites;
    }

    public static final /* synthetic */ void access$setProcessedWrites$p(ResourceWriteOperationQueue $this, List list) {
        $this.processedWrites = list;
    }

    public static final /* synthetic */ void access$sendBroadcast(ResourceWriteOperationQueue $this, Response response) {
        $this.sendBroadcast(response);
    }

    public static final /* synthetic */ void access$removeWrite(ResourceWriteOperationQueue $this, ResourceWriteOperation write) {
        $this.removeWrite(write);
    }

    public static final /* synthetic */ void access$persistWriteOnDisk(ResourceWriteOperationQueue $this, ResourceWriteOperation write) {
        $this.persistWriteOnDisk(write);
    }

    public static final /* synthetic */ void access$removeWriteFromDisk(ResourceWriteOperationQueue $this, ResourceWriteOperation write) {
        $this.removeWriteFromDisk(write);
    }

    public static final /* synthetic */ void access$load(ResourceWriteOperationQueue $this) {
        $this.load();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/azure/data/service/ResourceWriteOperationQueue$Companion;", "", "()V", "shared", "Lcom/azure/data/service/ResourceWriteOperationQueue;", "getShared", "()Lcom/azure/data/service/ResourceWriteOperationQueue;", "shared$delegate", "Lkotlin/Lazy;", "azuredata_release"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "shared", "getShared()Lcom/azure/data/service/ResourceWriteOperationQueue;"))};
        }

        @NotNull
        public final ResourceWriteOperationQueue getShared() {
            Lazy lazy = shared$delegate;
            Companion companion = Companion;
            KProperty kProperty = $$delegatedProperties[0];
            boolean bl = false;
            return (ResourceWriteOperationQueue)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

