/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.azure.data.model.Permission;
import com.azure.data.model.Resource;
import com.azure.data.util.ResourceOracle;
import com.azure.data.util.json.GsonConfigKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0013J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/azure/data/service/PermissionCache;", "", "host", "", "(Ljava/lang/String;)V", "cache", "", "Lcom/azure/data/model/Permission;", "isRestored", "", "()Z", "setRestored", "(Z)V", "permissionCachePrefsEditor", "Landroid/content/SharedPreferences$Editor;", "permissionCacheStorageKey", "slashCharacter", "", "commit", "", "getPermission", "resource", "Lcom/azure/data/model/Resource;", "altLink", "purge", "restore", "appCtx", "Landroid/content/Context;", "setPermission", "permission", "Companion", "azuredata_release"})
@SuppressLint(value={"CommitPrefEdits"})
public final class PermissionCache {
    private final String permissionCacheStorageKey;
    private final char slashCharacter = '/';
    private Map<String, Permission> cache;
    private SharedPreferences.Editor permissionCachePrefsEditor;
    private boolean isRestored;
    @NotNull
    public static PermissionCache shared;
    public static final Companion Companion;

    public final boolean isRestored() {
        return this.isRestored;
    }

    public final void setRestored(boolean bl) {
        this.isRestored = bl;
    }

    private final void commit() {
        SharedPreferences.Editor editor = this.permissionCachePrefsEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"permissionCachePrefsEditor");
        }
        editor.apply();
    }

    /*
     * WARNING - void declaration
     */
    public final void restore(@NotNull Context appCtx) {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        SharedPreferences permissionCachePrefs;
        Intrinsics.checkParameterIsNotNull((Object)appCtx, (String)"appCtx");
        SharedPreferences sharedPreferences = permissionCachePrefs = appCtx.getSharedPreferences(this.permissionCacheStorageKey, 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences, (String)"permissionCachePrefs");
        Map map2 = sharedPreferences.getAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"permissionCachePrefs.all");
        Map map3 = map2;
        PermissionCache permissionCache = this;
        boolean $i$f$mapValues = false;
        void var5_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            map = map4;
            boolean bl2 = false;
            Permission permission = (Permission)GsonConfigKt.getGson().fromJson(String.valueOf(it.getValue()), Permission.class);
            map.put(k2, permission);
        }
        map = destination$iv$iv;
        permissionCache.cache = MapsKt.toMutableMap((Map)map);
        SharedPreferences.Editor editor = permissionCachePrefs.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"permissionCachePrefs.edit()");
        this.permissionCachePrefsEditor = editor;
        this.isRestored = true;
    }

    public final void purge() {
        Map map;
        PermissionCache permissionCache = this;
        boolean bl = false;
        permissionCache.cache = map = (Map)new LinkedHashMap();
        SharedPreferences.Editor editor = this.permissionCachePrefsEditor;
        if (editor == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"permissionCachePrefsEditor");
        }
        editor.clear();
        this.commit();
    }

    @Nullable
    public final Permission getPermission(@NotNull Resource resource) {
        String altLink;
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        String string = altLink = ResourceOracle.Companion.getShared().getAltLink(resource);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            Map<String, Permission> map = this.cache;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cache");
            }
            return map.get(altLink);
        }
        return null;
    }

    @Nullable
    public final Permission getPermission(@NotNull String altLink) {
        Permission permission;
        Intrinsics.checkParameterIsNotNull((Object)altLink, (String)"altLink");
        CharSequence charSequence = StringsKt.trim((String)altLink, (char[])new char[]{this.slashCharacter});
        boolean bl = false;
        if (charSequence.length() > 0) {
            Map<String, Permission> map = this.cache;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cache");
            }
            permission = map.get(altLink);
        } else {
            permission = null;
        }
        return permission;
    }

    public final boolean setPermission(@NotNull Permission permission, @NotNull Resource resource) {
        boolean bl;
        String altLink;
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        String string = altLink = ResourceOracle.Companion.getShared().getAltLink(resource);
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string2;
            boolean bl4 = false;
            bl = this.setPermission(permission, it);
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean setPermission(@NotNull Permission permission, @NotNull String altLink) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
        Intrinsics.checkParameterIsNotNull((Object)altLink, (String)"altLink");
        CharSequence charSequence = StringsKt.trim((String)altLink, (char[])new char[]{this.slashCharacter});
        boolean bl2 = false;
        if (charSequence.length() > 0) {
            Map<String, Permission> map = this.cache;
            if (map == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cache");
            }
            map.put(altLink, permission);
            SharedPreferences.Editor editor = this.permissionCachePrefsEditor;
            if (editor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"permissionCachePrefsEditor");
            }
            editor.putString(altLink, GsonConfigKt.getGson().toJson((Object)permission));
            this.commit();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private PermissionCache(String host) {
        this.permissionCacheStorageKey = "com.azure.data.permissioncache" + host;
        this.slashCharacter = (char)47;
    }

    static {
        Companion = new Companion(null);
    }

    public /* synthetic */ PermissionCache(String host, DefaultConstructorMarker $constructor_marker) {
        this(host);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/azure/data/service/PermissionCache$Companion;", "", "()V", "shared", "Lcom/azure/data/service/PermissionCache;", "getShared", "()Lcom/azure/data/service/PermissionCache;", "setShared", "(Lcom/azure/data/service/PermissionCache;)V", "init", "", "host", "", "azuredata_release"})
    public static final class Companion {
        @NotNull
        public final PermissionCache getShared() {
            PermissionCache permissionCache = shared;
            if (permissionCache == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shared");
            }
            return permissionCache;
        }

        public final void setShared(@NotNull PermissionCache permissionCache) {
            Intrinsics.checkParameterIsNotNull((Object)permissionCache, (String)"<set-?>");
            shared = permissionCache;
        }

        public final void init(@NotNull String host) {
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            this.setShared(new PermissionCache(host, null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

