/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import android.content.Context;
import com.azure.core.log.LoggerKt;
import com.azure.data.model.Query;
import com.azure.data.model.Resource;
import com.azure.data.model.service.ResourceLocation;
import com.azure.data.model.service.ResourceType;
import com.azure.data.util.ResourceFilePath;
import com.azure.data.util.ResourceOracle;
import com.azure.data.util.StringExtensionsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a$\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0080\b\u00a2\u0006\u0002\u0010\n\u001a\u0017\u0010\u000b\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0080\b\u001a\f\u0010\f\u001a\u00020\u0003*\u00020\rH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0003*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0003*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0003*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u001c\u0010\u0016\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0003*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u001f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\u0010\u0019\u001a\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0014\u0010\u001b\u001a\u00020\u0003*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a8\u0006\u001c"}, d2={"createEmptyChildDirectoriesIfNecessary", "", "parent", "Ljava/io/File;", "resourceType", "Lcom/azure/data/model/service/ResourceType;", "safe", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "safeExecute", "azureDataCacheDir", "Landroid/content/Context;", "metadatafileUrl", "query", "Lcom/azure/data/model/Query;", "resourceCacheDir", "resource", "Lcom/azure/data/model/Resource;", "resourceLocation", "Lcom/azure/data/model/service/ResourceLocation;", "resourceCacheFile", "resourceCacheFiles", "", "(Landroid/content/Context;Lcom/azure/data/model/Query;)[Ljava/io/File;", "", "resultsCacheDir", "azuredata_release"})
public final class ResourceCacheKt {
    @Nullable
    public static final File resourceCacheFile(@NotNull Context $receiver, @NotNull Resource resource) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        ResourceFilePath resourceFilePath = ResourceOracle.Companion.getShared().getFilePath(resource);
        if (resourceFilePath != null) {
            ResourceFilePath resourceFilePath2;
            ResourceFilePath it = resourceFilePath2 = resourceFilePath;
            boolean bl = false;
            File directory = new File(ResourceCacheKt.azureDataCacheDir($receiver), it.getDirectory());
            if (!directory.exists()) {
                directory.mkdirs();
            }
            ResourceCacheKt.createEmptyChildDirectoriesIfNecessary(directory, ResourceType.Companion.fromType(resource.getClass()));
            return new File(directory, it.getFile());
        }
        return null;
    }

    @Nullable
    public static final File resourceCacheFile(@NotNull Context $receiver, @NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        ResourceFilePath resourceFilePath = ResourceOracle.Companion.getShared().getFilePath(resourceLocation);
        if (resourceFilePath != null) {
            ResourceFilePath resourceFilePath2;
            ResourceFilePath it = resourceFilePath2 = resourceFilePath;
            boolean bl = false;
            File directory = new File(ResourceCacheKt.azureDataCacheDir($receiver), it.getDirectory());
            if (!directory.exists()) {
                directory.mkdirs();
            }
            ResourceCacheKt.createEmptyChildDirectoriesIfNecessary(directory, resourceLocation.getResourceType());
            return new File(directory, it.getFile());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> resourceCacheFiles(@NotNull Context $receiver, @NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        File file = ResourceCacheKt.resourceCacheDir($receiver, resourceLocation);
        if (file != null) {
            void $receiver$iv$iv;
            File[] $receiver$iv;
            File file2;
            File file3 = file2 = file;
            boolean bl = false;
            File[] fileArray = file3.listFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"file.listFiles()");
            File[] fileArray2 = $receiver$iv = fileArray;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            void var8_8 = $receiver$iv$iv;
            int n = ((void)var8_8).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var12_12 = item$iv$iv = var8_8[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                File file4 = new File((File)it, stringBuilder.append(v3.getName()).append(".json").toString());
                collection.add(file4);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public static final File resourceCacheDir(@NotNull Context $receiver, @NotNull Resource resource) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        ResourceFilePath resourceFilePath = ResourceOracle.Companion.getShared().getFilePath(resource);
        if (resourceFilePath != null) {
            ResourceFilePath resourceFilePath2;
            ResourceFilePath it = resourceFilePath2 = resourceFilePath;
            boolean bl = false;
            File directory = new File(ResourceCacheKt.azureDataCacheDir($receiver), it.getDirectory());
            if (!directory.exists()) {
                directory.mkdirs();
            }
            return directory;
        }
        return null;
    }

    @Nullable
    public static final File resourceCacheDir(@NotNull Context $receiver, @NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        String string = ResourceOracle.Companion.getShared().getDirectoryPath(resourceLocation);
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            File directory = new File(ResourceCacheKt.azureDataCacheDir($receiver), it);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            return directory;
        }
        return null;
    }

    @NotNull
    public static final File azureDataCacheDir(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        File directory = new File($receiver.getCacheDir(), "com.azuredata.data");
        if (!directory.exists()) {
            directory.mkdir();
        }
        return directory;
    }

    public static final void createEmptyChildDirectoriesIfNecessary(@NotNull File parent, @NotNull ResourceType resourceType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)((Object)resourceType), (String)"resourceType");
        Iterable $receiver$iv = resourceType.getChildren();
        for (Object element$iv : $receiver$iv) {
            ResourceType it = (ResourceType)((Object)element$iv);
            boolean bl = false;
            File childDirectory = new File(parent, it.getPath());
            if (childDirectory.exists()) continue;
            childDirectory.mkdirs();
        }
    }

    @NotNull
    public static final File resourceCacheDir(@NotNull Context $receiver, @NotNull Query query) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        String queryPath = ResourceOracle.Companion.getShared().getDirectoryPath(query);
        File directory = new File(ResourceCacheKt.azureDataCacheDir($receiver), queryPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    @NotNull
    public static final File metadatafileUrl(@NotNull Context $receiver, @NotNull Query query) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        File dir = ResourceCacheKt.resourceCacheDir($receiver, query);
        return new File(dir, "metadata.json");
    }

    @NotNull
    public static final File resultsCacheDir(@NotNull Context $receiver, @NotNull Query query) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        File dir = ResourceCacheKt.resourceCacheDir($receiver, query);
        File resultsDir = new File(dir, "results");
        if (!resultsDir.exists()) {
            resultsDir.mkdirs();
        }
        return resultsDir;
    }

    @NotNull
    public static final File resourceCacheFile(@NotNull Context $receiver, @NotNull Resource resource, @NotNull Query query) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        StringBuilder stringBuilder = new StringBuilder();
        String string = resource.getSelfLink();
        if (string == null || (string = StringExtensionsKt.lastPathComponent(string)) == null) {
            string = resource.getResourceId();
        }
        String filename = stringBuilder.append(string).append(".json").toString();
        File resultsPath = ResourceCacheKt.resultsCacheDir($receiver, query);
        return new File(resultsPath, filename);
    }

    @NotNull
    public static final File[] resourceCacheFiles(@NotNull Context $receiver, @NotNull Query query) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        File resultsPath = ResourceCacheKt.resultsCacheDir($receiver, query);
        File[] fileArray = resultsPath.listFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"resultsPath.listFiles()");
        return fileArray;
    }

    @Nullable
    public static final <T> T safe(@NotNull Function0<? extends T> block) {
        Object object;
        int $i$f$safe = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            object = block.invoke();
        }
        catch (Exception ex) {
            boolean $i$f$e = false;
            int level$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex);
            }
            object = null;
        }
        return (T)object;
    }

    public static final void safeExecute(@NotNull Function0<Unit> block) {
        int $i$f$safeExecute = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            Unit unit = (Unit)block.invoke();
        }
        catch (Exception ex) {
            boolean $i$f$e = false;
            int level$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex);
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

