/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import com.azure.core.util.ContextProvider;
import com.azure.data.model.Permission;
import com.azure.data.model.PermissionMode;
import com.azure.data.model.Resource;
import com.azure.data.model.Timestamp;
import com.azure.data.model.service.DataError;
import com.azure.data.model.service.PermissionProviderError;
import com.azure.data.model.service.ResourceLocation;
import com.azure.data.model.service.ResourceType;
import com.azure.data.model.service.Response;
import com.azure.data.service.PermissionCache;
import com.azure.data.service.PermissionProvider;
import com.azure.data.service.PermissionProviderConfiguration;
import com.azure.data.service.PermissionProviderKt$WhenMappings;
import com.azure.data.util.ResourceExtensionsKt;
import com.azure.data.util.ResourceOracle;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00010\bH\u0002\u001a6\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u00010\bH\u0000\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"doGetPermission", "", "Lcom/azure/data/service/PermissionProvider;", "location", "Lcom/azure/data/model/service/ResourceLocation;", "permissionMode", "Lcom/azure/data/model/PermissionMode;", "completion", "Lkotlin/Function1;", "Lcom/azure/data/model/service/Response;", "Lcom/azure/data/model/Permission;", "getPermission", "resourceLocation", "getSelfLink", "", "altLink", "azuredata_release"})
public final class PermissionProviderKt {
    /*
     * WARNING - void declaration
     */
    public static final void getPermission(@NotNull PermissionProvider $receiver, @NotNull ResourceLocation resourceLocation, @NotNull PermissionMode permissionMode, @NotNull Function1<? super Response<Permission>, Unit> completion) {
        Object object;
        void location;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
        if (!PermissionCache.Companion.getShared().isRestored()) {
            PermissionCache.Companion.getShared().restore(ContextProvider.Companion.getAppContext());
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = resourceLocation;
        if ($receiver.getConfiguration() == null) {
            $receiver.setConfiguration(PermissionProviderConfiguration.Companion.getDefault());
        }
        PermissionProviderConfiguration permissionProviderConfiguration = $receiver.getConfiguration();
        if (permissionProviderConfiguration == null) {
            Intrinsics.throwNpe();
        }
        PermissionProviderConfiguration config = permissionProviderConfiguration;
        PermissionProviderConfiguration permissionProviderConfiguration2 = $receiver.getConfiguration();
        if (permissionProviderConfiguration2 == null) {
            Intrinsics.throwNpe();
        }
        PermissionMode mode = permissionProviderConfiguration2.getDefaultPermissionMode() == PermissionMode.All ? PermissionMode.All : permissionMode;
        ResourceType resourceType = ((ResourceLocation)location.element).getResourceType();
        if (!resourceType.getSupportsPermissionToken()) {
            completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidResourceType()), null, null, null, false, 30, null));
        }
        ResourceType resourceType2 = config.getDefaultResourceType();
        if (resourceType2 != null) {
            object = resourceType2;
            ResourceType defaultResourceType = object;
            boolean bl = false;
            if (resourceType != defaultResourceType && resourceType.isDecendentOf(defaultResourceType)) {
                ResourceLocation resourceLocation2;
                Map<ResourceType, String> ancestorIds = resourceLocation.ancestorIds();
                switch (PermissionProviderKt$WhenMappings.$EnumSwitchMapping$0[defaultResourceType.ordinal()]) {
                    case 1: {
                        String string = ancestorIds.get((Object)ResourceType.Database);
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        String string2 = ancestorIds.get((Object)ResourceType.Collection);
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        resourceLocation2 = new ResourceLocation.Collection(string, string2);
                        break;
                    }
                    case 2: {
                        String string = ancestorIds.get((Object)ResourceType.Database);
                        if (string == null) {
                            Intrinsics.throwNpe();
                        }
                        String string3 = ancestorIds.get((Object)ResourceType.Collection);
                        if (string3 == null) {
                            Intrinsics.throwNpe();
                        }
                        String string4 = ancestorIds.get((Object)ResourceType.Document);
                        if (string4 == null) {
                            Intrinsics.throwNpe();
                        }
                        resourceLocation2 = new ResourceLocation.Document(string, string3, string4);
                        break;
                    }
                    default: {
                        completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidDefaultResourceType()), null, null, null, false, 30, null));
                        return;
                    }
                }
                location.element = resourceLocation2;
            }
        }
        Permission permission = PermissionCache.Companion.getShared().getPermission(((ResourceLocation)location.element).link());
        if (permission != null) {
            Object permission2 = object = permission;
            boolean bl = false;
            if (((Permission)permission2).getPermissionMode() == PermissionMode.All || ((Permission)permission2).getPermissionMode() == permissionMode) {
                Timestamp timestamp = ((Resource)permission2).getTimestamp();
                if (timestamp != null) {
                    Timestamp timestamp2;
                    Timestamp timestamp3 = timestamp2 = timestamp;
                    boolean bl2 = false;
                    if (config.getDefaultTokenDuration() - (new Date().getTime() - timestamp3.getTime()) / (long)1000 > config.getTokenRefreshThreshold()) {
                        completion.invoke(new Response<Object>(permission2));
                        return;
                    }
                }
            }
        }
        PermissionProviderKt.doGetPermission($receiver, (ResourceLocation)location.element, mode, (Function1<? super Response<Permission>, Unit>)((Function1)new Function1<Response<Permission>, Unit>((Ref.ObjectRef)location, completion){
            final /* synthetic */ Ref.ObjectRef $location;
            final /* synthetic */ Function1 $completion;

            public final void invoke(@NotNull Response<Permission> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                Permission permission = it.getResource();
                if (permission != null) {
                    Permission permission2;
                    Permission permission3 = permission2 = permission;
                    boolean bl = false;
                    if (PermissionCache.Companion.getShared().setPermission(permission3, ((ResourceLocation)this.$location.element).link())) {
                        this.$completion.invoke(new Response<Permission>(permission3));
                    } else {
                        this.$completion.invoke(new Response<T>(new DataError(PermissionProviderError.Companion.getPermissionCacheFailed()), null, null, null, false, 30, null));
                    }
                } else {
                    Unit cfr_ignored_0 = (Unit)this.$completion.invoke(new Response<T>(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                }
            }
            {
                this.$location = objectRef;
                this.$completion = function1;
                super(1);
            }
        }));
    }

    private static final void doGetPermission(@NotNull PermissionProvider $receiver, ResourceLocation location, PermissionMode permissionMode, Function1<? super Response<Permission>, Unit> completion) {
        Object object;
        ResourceLocation resourceLocation = location;
        if (resourceLocation instanceof ResourceLocation.Collection) {
            String string = location.getId();
            if (string != null) {
                String string2;
                String id = string2 = string;
                boolean bl = false;
                $receiver.getPermissionForCollection(id, ((ResourceLocation.Collection)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidResourceType()), null, null, null, false, 30, null));
            }
        } else if (resourceLocation instanceof ResourceLocation.StoredProcedure) {
            String string = location.getId();
            if (string != null) {
                String string3;
                String it = string3 = string;
                boolean bl = false;
                $receiver.getPermissionForStoredProcedure(it, ((ResourceLocation.StoredProcedure)location).getCollectionId(), ((ResourceLocation.StoredProcedure)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                $receiver.getPermissionForCollection(((ResourceLocation.StoredProcedure)location).getCollectionId(), ((ResourceLocation.StoredProcedure)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            }
        } else if (resourceLocation instanceof ResourceLocation.Trigger) {
            String string = location.getId();
            if (string != null) {
                String string4;
                String it = string4 = string;
                boolean bl = false;
                $receiver.getPermissionForTrigger(it, ((ResourceLocation.Trigger)location).getCollectionId(), ((ResourceLocation.Trigger)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                $receiver.getPermissionForCollection(((ResourceLocation.Trigger)location).getCollectionId(), ((ResourceLocation.Trigger)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            }
        } else if (resourceLocation instanceof ResourceLocation.Udf) {
            String string = location.getId();
            if (string != null) {
                String string5;
                String it = string5 = string;
                boolean bl = false;
                $receiver.getPermissionForUserDefinedFunction(it, ((ResourceLocation.Udf)location).getCollectionId(), ((ResourceLocation.Udf)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                $receiver.getPermissionForCollection(((ResourceLocation.Udf)location).getCollectionId(), ((ResourceLocation.Udf)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            }
        } else if (resourceLocation instanceof ResourceLocation.Document) {
            String string = location.getId();
            if (string != null) {
                String string6;
                String it = string6 = string;
                boolean bl = false;
                $receiver.getPermissionForDocument(it, ((ResourceLocation.Document)location).getCollectionId(), ((ResourceLocation.Document)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                $receiver.getPermissionForCollection(((ResourceLocation.Document)location).getCollectionId(), ((ResourceLocation.Document)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            }
        } else if (resourceLocation instanceof ResourceLocation.Attachment) {
            String string = location.getId();
            if (string != null) {
                String string7;
                String it = string7 = string;
                boolean bl = false;
                $receiver.getPermissionForAttachment(it, ((ResourceLocation.Attachment)location).getDocumentId(), ((ResourceLocation.Attachment)location).getCollectionId(), ((ResourceLocation.Attachment)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            } else {
                $receiver.getPermissionForDocument(((ResourceLocation.Attachment)location).getDocumentId(), ((ResourceLocation.Attachment)location).getCollectionId(), ((ResourceLocation.Attachment)location).getDatabaseId(), permissionMode, completion);
                object = Unit.INSTANCE;
            }
        } else if (resourceLocation instanceof ResourceLocation.Resource) {
            switch (PermissionProviderKt$WhenMappings.$EnumSwitchMapping$2[location.getResourceType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidResourceType()), null, null, null, false, 30, null));
                    break;
                }
                case 5: {
                    String string = (String)ResourceExtensionsKt.ancestorIds$default(((ResourceLocation.Resource)location).getResource(), false, 1, null).get((Object)ResourceType.Database);
                    if (string != null) {
                        String string8;
                        String it = string8 = string;
                        boolean bl = false;
                        $receiver.getPermissionForCollection(((ResourceLocation.Resource)location).getResource().getId(), it, permissionMode, completion);
                        object = Unit.INSTANCE;
                        break;
                    }
                    object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                    break;
                }
                default: {
                    Map ancestorIds = ResourceExtensionsKt.ancestorIds$default(((ResourceLocation.Resource)location).getResource(), false, 1, null);
                    object = (String)ancestorIds.get((Object)ResourceType.Database);
                    if (object != null) {
                        Unit unit;
                        Object object2;
                        Object dbId = object2 = object;
                        boolean bl = false;
                        String string = (String)ancestorIds.get((Object)ResourceType.Collection);
                        if (string != null) {
                            String string9;
                            String collId = string9 = string;
                            boolean bl2 = false;
                            switch (PermissionProviderKt$WhenMappings.$EnumSwitchMapping$1[location.getResourceType().ordinal()]) {
                                case 1: {
                                    $receiver.getPermissionForStoredProcedure(((ResourceLocation.Resource)location).getResource().getId(), collId, (String)dbId, permissionMode, completion);
                                    unit = Unit.INSTANCE;
                                    break;
                                }
                                case 2: {
                                    $receiver.getPermissionForTrigger(((ResourceLocation.Resource)location).getResource().getId(), collId, (String)dbId, permissionMode, completion);
                                    unit = Unit.INSTANCE;
                                    break;
                                }
                                case 3: {
                                    $receiver.getPermissionForUserDefinedFunction(((ResourceLocation.Resource)location).getResource().getId(), collId, (String)dbId, permissionMode, completion);
                                    unit = Unit.INSTANCE;
                                    break;
                                }
                                case 4: {
                                    $receiver.getPermissionForDocument(((ResourceLocation.Resource)location).getResource().getId(), collId, (String)dbId, permissionMode, completion);
                                    unit = Unit.INSTANCE;
                                    break;
                                }
                                case 5: {
                                    String string10 = (String)ancestorIds.get((Object)ResourceType.Document);
                                    if (string10 != null) {
                                        String string11;
                                        String docId = string11 = string10;
                                        boolean bl3 = false;
                                        $receiver.getPermissionForAttachment(((ResourceLocation.Resource)location).getResource().getId(), docId, collId, (String)dbId, permissionMode, completion);
                                        unit = Unit.INSTANCE;
                                        break;
                                    }
                                    unit = null;
                                    break;
                                }
                                default: {
                                    unit = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                                }
                            }
                        } else {
                            unit = null;
                        }
                        object = unit;
                        if (unit != null) break;
                    }
                    object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                    break;
                }
            }
        } else if (resourceLocation instanceof ResourceLocation.Child) {
            switch (PermissionProviderKt$WhenMappings.$EnumSwitchMapping$4[location.getResourceType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidResourceType()), null, null, null, false, 30, null));
                    break;
                }
                case 5: {
                    String string = location.getId();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    $receiver.getPermissionForCollection(string, ((ResourceLocation.Child)location).getResource().getId(), permissionMode, completion);
                    object = Unit.INSTANCE;
                    break;
                }
                default: {
                    Map ancestorIds = ResourceExtensionsKt.ancestorIds$default(((ResourceLocation.Child)location).getResource(), false, 1, null);
                    String string = (String)ancestorIds.get((Object)ResourceType.Database);
                    if (string != null) {
                        String string12;
                        String dbId = string12 = string;
                        boolean bl = false;
                        switch (PermissionProviderKt$WhenMappings.$EnumSwitchMapping$3[location.getResourceType().ordinal()]) {
                            case 1: {
                                String string13 = location.getId();
                                if (string13 == null) {
                                    Intrinsics.throwNpe();
                                }
                                $receiver.getPermissionForStoredProcedure(string13, ((ResourceLocation.Child)location).getResource().getId(), dbId, permissionMode, completion);
                                break;
                            }
                            case 2: {
                                String string14 = location.getId();
                                if (string14 == null) {
                                    Intrinsics.throwNpe();
                                }
                                $receiver.getPermissionForTrigger(string14, ((ResourceLocation.Child)location).getResource().getId(), dbId, permissionMode, completion);
                                break;
                            }
                            case 3: {
                                String string15 = location.getId();
                                if (string15 == null) {
                                    Intrinsics.throwNpe();
                                }
                                $receiver.getPermissionForUserDefinedFunction(string15, ((ResourceLocation.Child)location).getResource().getId(), dbId, permissionMode, completion);
                                break;
                            }
                            case 4: {
                                String string16 = location.getId();
                                if (string16 == null) {
                                    Intrinsics.throwNpe();
                                }
                                $receiver.getPermissionForDocument(string16, ((ResourceLocation.Child)location).getResource().getId(), dbId, permissionMode, completion);
                                break;
                            }
                            case 5: {
                                String string17 = (String)ancestorIds.get((Object)ResourceType.Collection);
                                if (string17 != null) {
                                    String string18;
                                    String collId = string18 = string17;
                                    boolean bl4 = false;
                                    String string19 = location.getId();
                                    if (string19 != null) {
                                        String string20;
                                        String it = string20 = string19;
                                        boolean bl5 = false;
                                        $receiver.getPermissionForAttachment(it, ((ResourceLocation.Child)location).getResource().getId(), collId, dbId, permissionMode, completion);
                                        break;
                                    }
                                    $receiver.getPermissionForDocument(((ResourceLocation.Child)location).getResource().getId(), collId, dbId, permissionMode, completion);
                                    break;
                                }
                                Unit cfr_ignored_0 = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                                break;
                            }
                            default: {
                                completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                            }
                        }
                        object = Unit.INSTANCE;
                        break;
                    }
                    object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getGetPermissionFailed()), null, null, null, false, 30, null));
                    break;
                }
            }
        } else {
            object = (Unit)completion.invoke(new Response(new DataError(PermissionProviderError.Companion.getInvalidResourceType()), null, null, null, false, 30, null));
        }
    }

    @Nullable
    public static final String getSelfLink(@NotNull PermissionProvider $receiver, @NotNull String altLink) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)altLink, (String)"altLink");
        return ResourceOracle.Companion.getShared().getSelfLink(altLink);
    }
}

