/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import android.content.Intent;
import com.azure.core.log.LoggerKt;
import com.azure.core.util.ContextProvider;
import com.azure.data.constants.MSHttpHeader;
import com.azure.data.model.DataError;
import com.azure.data.model.DocumentClientError;
import com.azure.data.model.Resource;
import com.azure.data.model.ResourceLocation;
import com.azure.data.model.Result;
import com.azure.data.service.DocumentClient;
import com.azure.data.service.ResourceCache;
import com.azure.data.service.ResourceCacheKt;
import com.azure.data.service.ResourceWriteOperation;
import com.azure.data.service.ResourceWriteOperationQueue;
import com.azure.data.service.ResourceWriteOperationQueue$WhenMappings;
import com.azure.data.service.ResourceWriteOperationQueueKt;
import com.azure.data.service.ResourceWriteOperationType;
import com.azure.data.service.Response;
import com.azure.data.service.ResponseKt;
import com.azure.data.util.ResourceOracle;
import com.azure.data.util.ResourceValidationKt;
import com.azure.data.util.StringExtensionsKt;
import com.azure.data.util.json.GsonConfigKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0013\u0018\u0000 .2\u00020\u0001:\u0001.B\u0005\u00a2\u0006\u0002\u0010\u0002Ja\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u00062\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u0018\u0012\u0004\u0012\u00020\f0\u0017\u00a2\u0006\u0002\u0010\u0019JD\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00112\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u001c\u0010\u0016\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00140\u0018j\u0002`\u001c\u0012\u0004\u0012\u00020\f0\u0017JK\u0010\u001d\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u00062\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\u0018\u0012\u0004\u0012\u00020\f0\u0017H\u0002\u00a2\u0006\u0002\u0010\u001eJ.\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00112\u001c\u0010\u0016\u001a\u0018\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00140\u0018j\u0002`\u001c\u0012\u0004\u0012\u00020\f0\u0017H\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\tH\u0002J\b\u0010\"\u001a\u00020\fH\u0002J*\u0010#\u001a\u00020\f2\u0006\u0010!\u001a\u00020\t2\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0018\u0012\u0004\u0012\u00020\f0\u0017H\u0002J*\u0010$\u001a\u00020\f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0017H\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010!\u001a\u00020\tH\u0002J\u0006\u0010&\u001a\u00020\fJ\b\u0010'\u001a\u00020\fH\u0002J\u0010\u0010(\u001a\u00020\f2\u0006\u0010!\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020\f2\u0006\u0010!\u001a\u00020\tH\u0002J\u001c\u0010*\u001a\u00020\f\"\u0004\b\u0000\u0010\r2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H\r0\u0018H\u0002J\b\u0010,\u001a\u00020\fH\u0002J\u0006\u0010-\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/azure/data/service/ResourceWriteOperationQueue;", "", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "isSyncing", "", "processedWrites", "", "Lcom/azure/data/service/ResourceWriteOperation;", "writes", "addCreateOrReplace", "", "T", "Lcom/azure/data/model/Resource;", "resource", "location", "Lcom/azure/data/model/ResourceLocation;", "headers", "", "", "replace", "callback", "Lkotlin/Function1;", "Lcom/azure/data/service/Response;", "(Lcom/azure/data/model/Resource;Lcom/azure/data/model/ResourceLocation;Ljava/util/Map;ZLkotlin/jvm/functions/Function1;)V", "addDelete", "resourceLocation", "Lcom/azure/data/service/DataResponse;", "createOrReplaceOffline", "(Lcom/azure/data/model/Resource;Lcom/azure/data/model/ResourceLocation;ZLkotlin/jvm/functions/Function1;)V", "deleteOffline", "enqueueWrite", "write", "load", "performWrite", "performWrites", "persistWriteOnDisk", "purge", "removeCachedResources", "removeWrite", "removeWriteFromDisk", "sendBroadcast", "response", "sendOfflineWriteQueueProcessedBroadcast", "sync", "Companion", "azuredata_release"})
public final class ResourceWriteOperationQueue {
    private List<ResourceWriteOperation> writes;
    private List<ResourceWriteOperation> processedWrites;
    private boolean isSyncing;
    private final ExecutorService executor;
    @NotNull
    private static final Lazy shared$delegate;
    public static final Companion Companion;

    public final <T extends Resource> void addCreateOrReplace(@NotNull T resource, @NotNull ResourceLocation location, @Nullable Map<String, String> headers, boolean replace, @NotNull Function1<? super Response<T>, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createOrReplaceOffline(resource, location, replace, (Function1)new Function1<Response<T>, Unit>(this, callback, replace, resource, location, headers){
            final /* synthetic */ ResourceWriteOperationQueue this$0;
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ boolean $replace;
            final /* synthetic */ Resource $resource;
            final /* synthetic */ ResourceLocation $location;
            final /* synthetic */ Map $headers;

            public final void invoke(@NotNull Response<T> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                this.$callback.invoke(response);
                if (response.isSuccessful()) {
                    Map map;
                    ResourceWriteOperationQueue resourceWriteOperationQueue = this.this$0;
                    ResourceWriteOperationType resourceWriteOperationType = this.$replace ? ResourceWriteOperationType.Replace : ResourceWriteOperationType.Create;
                    Resource resource = this.$resource;
                    ResourceLocation resourceLocation = this.$location;
                    Object object = response.getResponse();
                    if (object == null || (object = object.header(MSHttpHeader.MSContentPath.name())) == null) {
                        object = "";
                    }
                    if ((map = this.$headers) == null) {
                        Object object2 = object;
                        ResourceLocation resourceLocation2 = resourceLocation;
                        Resource resource2 = resource;
                        ResourceWriteOperationType resourceWriteOperationType2 = resourceWriteOperationType;
                        ResourceWriteOperationQueue resourceWriteOperationQueue2 = resourceWriteOperationQueue;
                        Map map2 = new LinkedHashMap<K, V>();
                        resourceWriteOperationQueue = resourceWriteOperationQueue2;
                        resourceWriteOperationType = resourceWriteOperationType2;
                        resource = resource2;
                        resourceLocation = resourceLocation2;
                        object = object2;
                        map = map2;
                    }
                    Map map3 = map;
                    Object object3 = object;
                    ResourceLocation resourceLocation3 = resourceLocation;
                    Resource resource3 = resource;
                    ResourceWriteOperationType resourceWriteOperationType3 = resourceWriteOperationType;
                    ResourceWriteOperationQueue.access$enqueueWrite(resourceWriteOperationQueue, new ResourceWriteOperation(resourceWriteOperationType3, resource3, resourceLocation3, (String)object3, map3));
                }
            }
            {
                this.this$0 = resourceWriteOperationQueue;
                this.$callback = function1;
                this.$replace = bl;
                this.$resource = resource;
                this.$location = resourceLocation;
                this.$headers = map;
                super(1);
            }
        });
    }

    public static /* synthetic */ void addCreateOrReplace$default(ResourceWriteOperationQueue resourceWriteOperationQueue, Resource resource, ResourceLocation resourceLocation, Map map, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            map = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        resourceWriteOperationQueue.addCreateOrReplace(resource, resourceLocation, map, bl, function1);
    }

    public final void addDelete(@NotNull ResourceLocation resourceLocation, @Nullable Map<String, String> headers, @NotNull Function1<? super Response<String>, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.deleteOffline(resourceLocation, (Function1<? super Response<String>, Unit>)((Function1)new Function1<Response<String>, Unit>(this, callback, resourceLocation, headers){
            final /* synthetic */ ResourceWriteOperationQueue this$0;
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ ResourceLocation $resourceLocation;
            final /* synthetic */ Map $headers;

            public final void invoke(@NotNull Response<String> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                this.$callback.invoke(response);
                if (response.isSuccessful()) {
                    Map map;
                    ResourceWriteOperationQueue resourceWriteOperationQueue = this.this$0;
                    ResourceWriteOperationType resourceWriteOperationType = ResourceWriteOperationType.Delete;
                    Resource resource = null;
                    ResourceLocation resourceLocation = this.$resourceLocation;
                    Object object = response.getResponse();
                    if (object == null || (object = object.header(MSHttpHeader.MSContentPath.name())) == null) {
                        object = "";
                    }
                    if ((map = this.$headers) == null) {
                        Object object2 = object;
                        ResourceLocation resourceLocation2 = resourceLocation;
                        Resource resource2 = resource;
                        ResourceWriteOperationType resourceWriteOperationType2 = resourceWriteOperationType;
                        ResourceWriteOperationQueue resourceWriteOperationQueue2 = resourceWriteOperationQueue;
                        Map map2 = new LinkedHashMap<K, V>();
                        resourceWriteOperationQueue = resourceWriteOperationQueue2;
                        resourceWriteOperationType = resourceWriteOperationType2;
                        resource = resource2;
                        resourceLocation = resourceLocation2;
                        object = object2;
                        map = map2;
                    }
                    Map map3 = map;
                    Object object3 = object;
                    ResourceLocation resourceLocation3 = resourceLocation;
                    Resource resource3 = resource;
                    ResourceWriteOperationType resourceWriteOperationType3 = resourceWriteOperationType;
                    ResourceWriteOperationQueue.access$enqueueWrite(resourceWriteOperationQueue, new ResourceWriteOperation(resourceWriteOperationType3, resource3, resourceLocation3, (String)object3, map3));
                }
            }
            {
                this.this$0 = resourceWriteOperationQueue;
                this.$callback = function1;
                this.$resourceLocation = resourceLocation;
                this.$headers = map;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void addDelete$default(ResourceWriteOperationQueue resourceWriteOperationQueue, ResourceLocation resourceLocation, Map map, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            map = null;
        }
        resourceWriteOperationQueue.addDelete(resourceLocation, map, (Function1<? super Response<String>, Unit>)function1);
    }

    public final void sync() {
        this.executor.execute(new Runnable(this){
            final /* synthetic */ ResourceWriteOperationQueue this$0;

            public final void run() {
                if (ResourceWriteOperationQueue.access$isSyncing$p(this.this$0) || ResourceWriteOperationQueue.access$getWrites$p(this.this$0).isEmpty()) {
                    return;
                }
                List writes = ResourceWriteOperationQueueKt.access$sortedByResourceType(ResourceWriteOperationQueue.access$getWrites$p(this.this$0));
                ResourceWriteOperationQueue.access$setSyncing$p(this.this$0, true);
                ResourceWriteOperationQueue.access$performWrites(this.this$0, writes, (Function1)new Function1<Boolean, Unit>(this){
                    final /* synthetic */ sync.1 this$0;

                    public final void invoke(boolean isSuccess) {
                        if (isSuccess) {
                            ResourceWriteOperationQueue.access$sendOfflineWriteQueueProcessedBroadcast(this.this$0.this$0);
                        }
                        ResourceWriteOperationQueue.access$removeCachedResources(this.this$0.this$0);
                        ResourceWriteOperationQueue.access$setSyncing$p(this.this$0.this$0, false);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = resourceWriteOperationQueue;
            }
        });
    }

    public final void purge() {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            FilesKt.deleteRecursively((File)ResourceWriteOperationQueueKt.access$pendingWritesDir(ContextProvider.Companion.getAppContext()));
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void load() {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            this.executor.execute(new Runnable(this){
                final /* synthetic */ ResourceWriteOperationQueue this$0;
                {
                    this.this$0 = resourceWriteOperationQueue;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void run() {
                    Collection<ResourceWriteOperation> collection;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv = ResourceWriteOperationQueueKt.access$pendingWritesFiles(ContextProvider.Companion.getAppContext());
                    ResourceWriteOperationQueue resourceWriteOperationQueue = this.this$0;
                    Iterable iterable = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        ResourceWriteOperation resourceWriteOperation;
                        void it;
                        File file = (File)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Closeable closeable = it;
                        Object object = Charsets.UTF_8;
                        int n = 8192;
                        Reader reader = closeable;
                        InputStream inputStream = reader;
                        reader = new InputStreamReader(inputStream = (InputStream)new FileInputStream((File)((Object)inputStream)), (Charset)object);
                        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                        object = null;
                        try {
                            BufferedReader it2 = (BufferedReader)closeable;
                            boolean bl2 = false;
                            resourceWriteOperation = (ResourceWriteOperation)GsonConfigKt.getGson().fromJson(TextStreamsKt.readText((Reader)it2), ResourceWriteOperation.class);
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                        }
                        ResourceWriteOperation resourceWriteOperation2 = resourceWriteOperation;
                        collection.add(resourceWriteOperation2);
                    }
                    collection = (List)destination$iv$iv;
                    ResourceWriteOperationQueue.access$setWrites$p(resourceWriteOperationQueue, CollectionsKt.toMutableList((Collection)collection));
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void performWrites(List<ResourceWriteOperation> writes, Function1<? super Boolean, Unit> callback) {
        if (writes.isEmpty()) {
            callback.invoke((Object)true);
            return;
        }
        ResourceWriteOperation write = writes.remove(0);
        this.performWrite(write, (Function1<? super Response<Unit>, Unit>)((Function1)new Function1<Response<Unit>, Unit>(this, write, writes, callback){
            final /* synthetic */ ResourceWriteOperationQueue this$0;
            final /* synthetic */ ResourceWriteOperation $write;
            final /* synthetic */ List $writes;
            final /* synthetic */ Function1 $callback;

            public final void invoke(@NotNull Response<Unit> response) {
                Intrinsics.checkParameterIsNotNull(response, (String)"response");
                if (!response.getFromCache()) {
                    ResourceWriteOperationQueue.access$getProcessedWrites$p(this.this$0).add(this.$write);
                    ResourceWriteOperationQueue.access$sendBroadcast(this.this$0, response);
                    ResourceWriteOperationQueue.access$removeWrite(this.this$0, this.$write);
                }
                ResourceWriteOperationQueue.access$performWrites(this.this$0, this.$writes, this.$callback);
            }
            {
                this.this$0 = resourceWriteOperationQueue;
                this.$write = resourceWriteOperation;
                this.$writes = list;
                this.$callback = function1;
                super(1);
            }
        }));
    }

    private final void performWrite(ResourceWriteOperation write, Function1<? super Response<Unit>, Unit> callback) {
        switch (ResourceWriteOperationQueue$WhenMappings.$EnumSwitchMapping$0[write.getType().ordinal()]) {
            case 1: {
                DocumentClient documentClient = DocumentClient.Companion.getShared();
                Resource resource = write.getResource();
                if (resource == null) {
                    Intrinsics.throwNpe();
                }
                documentClient.createOrReplace$azuredata_release(resource, write.getResourceLocation(), false, write.getHttpHeaders(), (Function1)new Function1<Response<Resource>, Unit>(callback){
                    final /* synthetic */ Function1 $callback;

                    public final void invoke(@NotNull Response<Resource> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        this.$callback.invoke(ResponseKt.map(it, (Function1)performWrite.1.INSTANCE));
                    }
                    {
                        this.$callback = function1;
                        super(1);
                    }
                });
                break;
            }
            case 2: {
                DocumentClient documentClient = DocumentClient.Companion.getShared();
                Resource resource = write.getResource();
                if (resource == null) {
                    Intrinsics.throwNpe();
                }
                documentClient.createOrReplace$azuredata_release(resource, write.getResourceLocation(), true, write.getHttpHeaders(), (Function1)new Function1<Response<Resource>, Unit>(callback){
                    final /* synthetic */ Function1 $callback;

                    public final void invoke(@NotNull Response<Resource> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        this.$callback.invoke(ResponseKt.map(it, (Function1)performWrite.1.INSTANCE));
                    }
                    {
                        this.$callback = function1;
                        super(1);
                    }
                });
                break;
            }
            case 3: {
                DocumentClient documentClient = DocumentClient.Companion.getShared();
                Resource resource = write.getResource();
                if (resource == null) {
                    Intrinsics.throwNpe();
                }
                documentClient.delete(resource, (Function1<? super Response<String>, Unit>)((Function1)performWrite.3.INSTANCE));
            }
        }
    }

    private final void enqueueWrite(ResourceWriteOperation write) {
        this.executor.execute(new Runnable(this, write){
            final /* synthetic */ ResourceWriteOperationQueue this$0;
            final /* synthetic */ ResourceWriteOperation $write;

            public final void run() {
                int index = ResourceWriteOperationQueue.access$getWrites$p(this.this$0).indexOf(this.$write);
                if (index < 0) {
                    ResourceWriteOperationQueue.access$getWrites$p(this.this$0).add(this.$write);
                    ResourceWriteOperationQueue.access$persistWriteOnDisk(this.this$0, this.$write);
                    return;
                }
                ResourceWriteOperation existingWrite = (ResourceWriteOperation)ResourceWriteOperationQueue.access$getWrites$p(this.this$0).get(index);
                Pair pair = new Pair((Object)((Object)existingWrite.getType()), (Object)((Object)this.$write.getType()));
                if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)((Object)ResourceWriteOperationType.Create), (Object)((Object)ResourceWriteOperationType.Replace)))) {
                    ResourceWriteOperationQueue.access$getWrites$p(this.this$0).set(index, ResourceWriteOperationQueueKt.access$withType(this.$write, ResourceWriteOperationType.Create));
                    ResourceWriteOperationQueue.access$removeWriteFromDisk(this.this$0, existingWrite);
                    ResourceWriteOperationQueue.access$persistWriteOnDisk(this.this$0, this.$write);
                } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)((Object)ResourceWriteOperationType.Create), (Object)((Object)ResourceWriteOperationType.Delete)))) {
                    ResourceWriteOperationQueue.access$getWrites$p(this.this$0).remove(index);
                    ResourceWriteOperationQueue.access$removeWriteFromDisk(this.this$0, existingWrite);
                } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)((Object)ResourceWriteOperationType.Replace), (Object)((Object)ResourceWriteOperationType.Delete)))) {
                    ResourceWriteOperationQueue.access$getWrites$p(this.this$0).set(index, this.$write);
                    ResourceWriteOperationQueue.access$removeWriteFromDisk(this.this$0, existingWrite);
                    ResourceWriteOperationQueue.access$persistWriteOnDisk(this.this$0, this.$write);
                } else if (Intrinsics.areEqual((Object)pair, (Object)new Pair((Object)((Object)ResourceWriteOperationType.Replace), (Object)((Object)ResourceWriteOperationType.Replace)))) {
                    ResourceWriteOperationQueue.access$getWrites$p(this.this$0).set(index, this.$write);
                    ResourceWriteOperationQueue.access$removeWriteFromDisk(this.this$0, existingWrite);
                    ResourceWriteOperationQueue.access$persistWriteOnDisk(this.this$0, this.$write);
                }
            }
            {
                this.this$0 = resourceWriteOperationQueue;
                this.$write = resourceWriteOperation;
            }
        });
    }

    private final void removeWrite(ResourceWriteOperation write) {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            int index = this.writes.indexOf(write);
            if (index < 0) {
                this.writes.remove(index);
                this.removeWriteFromDisk(write);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void removeCachedResources() {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            while (!this.processedWrites.isEmpty()) {
                Collection collection = this.processedWrites;
                List<ResourceWriteOperation> list = this.processedWrites;
                int n = collection.size();
                ResourceWriteOperation write = list.remove(n - 1);
                FilesKt.deleteRecursively((File)new File(new URI(ResourceCacheKt.azureDataCacheDir(ContextProvider.Companion.getAppContext()).getAbsolutePath() + '/' + write.getResourceLocalContentPath())));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final <T extends Resource> void createOrReplaceOffline(T resource, ResourceLocation location, boolean replace, Function1<? super Response<T>, Unit> callback) {
        CharSequence request;
        CharSequence charSequence;
        if (!ResourceValidationKt.isValidIdForResource(resource.getId())) {
            callback.invoke(new Response(new DataError(DocumentClientError.Companion.getInvalidId()), null, null, null, false, 30, null));
            return;
        }
        String altLink = location.altLink(resource.getId());
        String knownSelfLink = ResourceOracle.Companion.getShared().getSelfLink(altLink);
        if (replace && ((charSequence = (CharSequence)knownSelfLink) == null || charSequence.length() == 0)) {
            request = new Request.Builder().url("https://localhost/" + altLink).build();
            Response.Builder builder = new Response.Builder().request((Request)request).protocol(Protocol.HTTP_1_1).code(404);
            String string = DocumentClientError.Companion.getNotFound().getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            okhttp3.Response response = builder.message(string).build();
            callback.invoke(new Response(new DataError(DocumentClientError.Companion.getNotFound()), (Request)request, response, null, true, 8, null));
            return;
        }
        if (!replace && !((request = (CharSequence)knownSelfLink) == null || request.length() == 0)) {
            request = new Request.Builder().url("https://localhost/" + altLink).build();
            Response.Builder builder = new Response.Builder().request((Request)request).protocol(Protocol.HTTP_1_1).code(409);
            String string = DocumentClientError.Companion.getConflict().getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            okhttp3.Response response = builder.message(string).build();
            callback.invoke(new Response(new DataError(DocumentClientError.Companion.getConflict()), (Request)request, response, null, true, 8, null));
            return;
        }
        String string = knownSelfLink;
        if (string == null) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
            string = location.selfLink(string2);
        }
        if (string != null) {
            CharSequence selfLink = charSequence = string;
            boolean bl = false;
            ResourceOracle.Companion.getShared().storeLinks((String)selfLink, altLink);
            resource.setAltLink(altLink);
            ResourceCache.Companion.getShared().cache(resource);
            Request request2 = new Request.Builder().url("https://localhost/" + (String)selfLink).build();
            okhttp3.Response response = new Response.Builder().request(request2).protocol(Protocol.HTTP_1_1).code(replace ? 200 : 201).addHeader(MSHttpHeader.MSContentPath.name(), (String)selfLink).addHeader(MSHttpHeader.MSAltContentPath.name(), StringExtensionsKt.ancestorPath(altLink)).message(GsonConfigKt.getGson().toJson(resource)).build();
            callback.invoke(new Response(request2, response, null, new Result(resource, null, 2, null), location, null, true, 36, null));
            return;
        }
        callback.invoke(new Response(new DataError(DocumentClientError.Companion.getInternalError()), null, null, null, false, 30, null));
    }

    static /* synthetic */ void createOrReplaceOffline$default(ResourceWriteOperationQueue resourceWriteOperationQueue, Resource resource, ResourceLocation resourceLocation, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        resourceWriteOperationQueue.createOrReplaceOffline(resource, resourceLocation, bl, function1);
    }

    private final void deleteOffline(ResourceLocation resourceLocation, Function1<? super Response<String>, Unit> callback) {
        String string = ResourceOracle.Companion.getShared().getSelfLink(resourceLocation.link());
        if (string != null) {
            String string2;
            String selfLink = string2 = string;
            boolean bl = false;
            ResourceCache.Companion.getShared().remove(resourceLocation);
            Request request = new Request.Builder().url("https://com.azuredata.cache/" + selfLink).build();
            okhttp3.Response response = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(204).addHeader(MSHttpHeader.MSContentPath.name(), selfLink).addHeader(MSHttpHeader.MSAltContentPath.name(), StringExtensionsKt.ancestorPath(resourceLocation.link())).message("").build();
            callback.invoke(new Response(request, response, null, new Result("", null, 2, null), resourceLocation, null, true, 36, null));
            return;
        }
        Request request = new Request.Builder().url("https://localhost/" + resourceLocation.link()).build();
        Response.Builder builder = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(404);
        String string3 = DocumentClientError.Companion.getNotFound().getMessage();
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        okhttp3.Response response = builder.message(string3).build();
        callback.invoke(new Response(new DataError(DocumentClientError.Companion.getNotFound()), request, response, null, true, 8, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void persistWriteOnDisk(ResourceWriteOperation write) {
        boolean $i$f$safeExecute = false;
        try {
            Object object;
            boolean bl = false;
            Object object2 = ResourceWriteOperationQueueKt.access$resourceWriteOperationFile(ContextProvider.Companion.getAppContext(), write);
            Object object3 = Charsets.UTF_8;
            int n = 8192;
            Object object4 = object = object2;
            object4 = new FileOutputStream((File)object4);
            object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
            object2 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
            object3 = null;
            try {
                BufferedWriter it = (BufferedWriter)object2;
                boolean bl2 = false;
                it.write(GsonConfigKt.getGson().toJson((Object)write));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void removeWriteFromDisk(ResourceWriteOperation write) {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            ResourceWriteOperationQueueKt.access$resourceWriteOperationFile(ContextProvider.Companion.getAppContext(), write).delete();
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final <T> void sendBroadcast(Response<T> response) {
        Intent intent = new Intent();
        if (response.isSuccessful()) {
            intent.setAction("com.azuredata.data.OFFLINE_RESOURCE_SYNC_SUCCEEDED");
            intent.putExtra("data", response.getJsonData());
        } else {
            intent.setAction("com.azuredata.data.OFFLINE_RESOURCE_SYNC_FAILED");
            intent.putExtra("error", response.getJsonData());
        }
        ContextProvider.Companion.getAppContext().sendBroadcast(intent);
    }

    private final void sendOfflineWriteQueueProcessedBroadcast() {
        ContextProvider.Companion.getAppContext().sendBroadcast(new Intent("com.azuredata.data.OFFLINE_WRITE_OPERATION_QUEUE.PROCESSED"));
    }

    public ResourceWriteOperationQueue() {
        List list;
        ResourceWriteOperationQueue resourceWriteOperationQueue = this;
        resourceWriteOperationQueue.writes = list = (List)new ArrayList();
        resourceWriteOperationQueue = this;
        resourceWriteOperationQueue.processedWrites = list = (List)new ArrayList();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newSingleThreadExecutor()");
        this.executor = executorService;
    }

    static {
        Companion = new Companion(null);
        shared$delegate = LazyKt.lazy((Function0)Companion.shared.2.INSTANCE);
    }

    public static final /* synthetic */ void access$enqueueWrite(ResourceWriteOperationQueue $this, ResourceWriteOperation write) {
        $this.enqueueWrite(write);
    }

    public static final /* synthetic */ boolean access$isSyncing$p(ResourceWriteOperationQueue $this) {
        return $this.isSyncing;
    }

    public static final /* synthetic */ void access$setSyncing$p(ResourceWriteOperationQueue $this, boolean bl) {
        $this.isSyncing = bl;
    }

    public static final /* synthetic */ List access$getWrites$p(ResourceWriteOperationQueue $this) {
        return $this.writes;
    }

    public static final /* synthetic */ void access$setWrites$p(ResourceWriteOperationQueue $this, List list) {
        $this.writes = list;
    }

    public static final /* synthetic */ void access$performWrites(ResourceWriteOperationQueue $this, List writes, Function1 callback) {
        $this.performWrites(writes, (Function1<? super Boolean, Unit>)callback);
    }

    public static final /* synthetic */ void access$sendOfflineWriteQueueProcessedBroadcast(ResourceWriteOperationQueue $this) {
        $this.sendOfflineWriteQueueProcessedBroadcast();
    }

    public static final /* synthetic */ void access$removeCachedResources(ResourceWriteOperationQueue $this) {
        $this.removeCachedResources();
    }

    public static final /* synthetic */ List access$getProcessedWrites$p(ResourceWriteOperationQueue $this) {
        return $this.processedWrites;
    }

    public static final /* synthetic */ void access$setProcessedWrites$p(ResourceWriteOperationQueue $this, List list) {
        $this.processedWrites = list;
    }

    public static final /* synthetic */ void access$sendBroadcast(ResourceWriteOperationQueue $this, Response response) {
        $this.sendBroadcast(response);
    }

    public static final /* synthetic */ void access$removeWrite(ResourceWriteOperationQueue $this, ResourceWriteOperation write) {
        $this.removeWrite(write);
    }

    public static final /* synthetic */ void access$persistWriteOnDisk(ResourceWriteOperationQueue $this, ResourceWriteOperation write) {
        $this.persistWriteOnDisk(write);
    }

    public static final /* synthetic */ void access$removeWriteFromDisk(ResourceWriteOperationQueue $this, ResourceWriteOperation write) {
        $this.removeWriteFromDisk(write);
    }

    public static final /* synthetic */ void access$load(ResourceWriteOperationQueue $this) {
        $this.load();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/azure/data/service/ResourceWriteOperationQueue$Companion;", "", "()V", "shared", "Lcom/azure/data/service/ResourceWriteOperationQueue;", "getShared", "()Lcom/azure/data/service/ResourceWriteOperationQueue;", "shared$delegate", "Lkotlin/Lazy;", "azuredata_release"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "shared", "getShared()Lcom/azure/data/service/ResourceWriteOperationQueue;"))};
        }

        @NotNull
        public final ResourceWriteOperationQueue getShared() {
            Lazy lazy = shared$delegate;
            Companion companion = Companion;
            KProperty kProperty = $$delegatedProperties[0];
            return (ResourceWriteOperationQueue)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

