/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import android.content.Context;
import com.azure.data.service.ResourceCacheKt;
import com.azure.data.service.ResourceWriteOperation;
import com.azure.data.service.ResourceWriteOperationHierarchicalComparator;
import com.azure.data.service.ResourceWriteOperationType;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004*\u00020\u0002H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t*\b\u0012\u0004\u0012\u00020\u00070\tH\u0002\u001a\u0014\u0010\n\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"pendingWritesDir", "Ljava/io/File;", "Landroid/content/Context;", "pendingWritesFiles", "", "resourceWriteOperationFile", "write", "Lcom/azure/data/service/ResourceWriteOperation;", "sortedByResourceType", "", "withType", "type", "Lcom/azure/data/service/ResourceWriteOperationType;", "azuredata_release"})
public final class ResourceWriteOperationQueueKt {
    private static final File resourceWriteOperationFile(@NotNull Context $receiver, ResourceWriteOperation write) {
        return new File(ResourceWriteOperationQueueKt.pendingWritesDir($receiver), write.getResourceLocalContentPath().hashCode() + ".json");
    }

    private static final List<File> pendingWritesFiles(@NotNull Context $receiver) {
        Object[] objectArray = ResourceWriteOperationQueueKt.pendingWritesDir($receiver).listFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"pendingWritesDir().listFiles()");
        return ArraysKt.asList((Object[])objectArray);
    }

    private static final File pendingWritesDir(@NotNull Context $receiver) {
        File directory = new File(ResourceCacheKt.azureDataCacheDir($receiver), "writes");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    private static final ResourceWriteOperation withType(@NotNull ResourceWriteOperation $receiver, ResourceWriteOperationType type) {
        return new ResourceWriteOperation(type, $receiver.getResource(), $receiver.getResourceLocation(), $receiver.getResourceLocalContentPath(), $receiver.getHttpHeaders());
    }

    private static final List<ResourceWriteOperation> sortedByResourceType(@NotNull List<ResourceWriteOperation> $receiver) {
        return CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)$receiver, (Comparator)new ResourceWriteOperationHierarchicalComparator()));
    }

    public static final /* synthetic */ List access$sortedByResourceType(List $receiver) {
        return ResourceWriteOperationQueueKt.sortedByResourceType($receiver);
    }

    public static final /* synthetic */ File access$pendingWritesDir(Context $receiver) {
        return ResourceWriteOperationQueueKt.pendingWritesDir($receiver);
    }

    public static final /* synthetic */ List access$pendingWritesFiles(Context $receiver) {
        return ResourceWriteOperationQueueKt.pendingWritesFiles($receiver);
    }

    public static final /* synthetic */ ResourceWriteOperation access$withType(ResourceWriteOperation $receiver, ResourceWriteOperationType type) {
        return ResourceWriteOperationQueueKt.withType($receiver, type);
    }

    public static final /* synthetic */ File access$resourceWriteOperationFile(Context $receiver, ResourceWriteOperation write) {
        return ResourceWriteOperationQueueKt.resourceWriteOperationFile($receiver, write);
    }
}

