/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import android.content.Context;
import com.azure.core.log.LoggerKt;
import com.azure.data.model.Resource;
import com.azure.data.model.ResourceLocation;
import com.azure.data.model.ResourceType;
import com.azure.data.util.ResourceFilePath;
import com.azure.data.util.ResourceOracle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a$\u0010\u0006\u001a\u0004\u0018\u0001H\u0007\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0080\b\u00a2\u0006\u0002\u0010\n\u001a\u0017\u0010\u000b\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0080\b\u001a\f\u0010\f\u001a\u00020\u0003*\u00020\rH\u0000\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0003*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u0003*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0016"}, d2={"createEmptyChildDirectoriesIfNecessary", "", "parent", "Ljava/io/File;", "resourceType", "Lcom/azure/data/model/ResourceType;", "safe", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "safeExecute", "azureDataCacheDir", "Landroid/content/Context;", "resourceCacheDir", "resource", "Lcom/azure/data/model/Resource;", "resourceLocation", "Lcom/azure/data/model/ResourceLocation;", "resourceCacheFile", "resourceCacheFiles", "", "azuredata_release"})
public final class ResourceCacheKt {
    @Nullable
    public static final File resourceCacheFile(@NotNull Context $receiver, @NotNull Resource resource) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        ResourceFilePath resourceFilePath = ResourceOracle.Companion.getShared().getFilePath(resource);
        if (resourceFilePath != null) {
            ResourceFilePath resourceFilePath2;
            ResourceFilePath it = resourceFilePath2 = resourceFilePath;
            boolean bl = false;
            File directory = new File(ResourceCacheKt.azureDataCacheDir($receiver), it.getDirectory());
            if (!directory.exists()) {
                directory.mkdirs();
            }
            ResourceCacheKt.createEmptyChildDirectoriesIfNecessary(directory, ResourceType.Companion.fromType(resource.getClass()));
            return new File(directory, it.getFile());
        }
        return null;
    }

    private static final File resourceCacheFile(@NotNull Context $receiver, ResourceLocation resourceLocation) {
        ResourceFilePath resourceFilePath = ResourceOracle.Companion.getShared().getFilePath(resourceLocation);
        if (resourceFilePath != null) {
            ResourceFilePath resourceFilePath2;
            ResourceFilePath it = resourceFilePath2 = resourceFilePath;
            boolean bl = false;
            File directory = new File(ResourceCacheKt.azureDataCacheDir($receiver), it.getDirectory());
            if (!directory.exists()) {
                directory.mkdirs();
            }
            ResourceCacheKt.createEmptyChildDirectoriesIfNecessary(directory, resourceLocation.getResourceType());
            return new File(directory, it.getFile());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<File> resourceCacheFiles(@NotNull Context $receiver, ResourceLocation resourceLocation) {
        File file = ResourceCacheKt.resourceCacheDir($receiver, resourceLocation);
        if (file != null) {
            void $receiver$iv$iv;
            File[] $receiver$iv;
            File file2;
            File it = file2 = file;
            boolean bl = false;
            File[] fileArray = it.listFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"it.listFiles()");
            File[] fileArray2 = $receiver$iv = fileArray;
            Collection destination$iv$iv = new ArrayList($receiver$iv.length);
            void var8_8 = $receiver$iv$iv;
            int n = ((void)var8_8).length;
            for (int i = 0; i < n; ++i) {
                void it2;
                void item$iv$iv;
                void var12_12 = item$iv$iv = var8_8[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                StringBuilder stringBuilder = new StringBuilder();
                void v3 = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                File file3 = new File((File)it2, stringBuilder.append(v3.getName()).append(".json").toString());
                collection.add(file3);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    private static final File resourceCacheDir(@NotNull Context $receiver, Resource resource) {
        ResourceFilePath resourceFilePath = ResourceOracle.Companion.getShared().getFilePath(resource);
        if (resourceFilePath != null) {
            ResourceFilePath resourceFilePath2;
            ResourceFilePath it = resourceFilePath2 = resourceFilePath;
            boolean bl = false;
            File directory = new File(ResourceCacheKt.azureDataCacheDir($receiver), it.getDirectory());
            if (!directory.exists()) {
                directory.mkdirs();
            }
            return directory;
        }
        return null;
    }

    private static final File resourceCacheDir(@NotNull Context $receiver, ResourceLocation resourceLocation) {
        String string = ResourceOracle.Companion.getShared().getDirectoryPath(resourceLocation);
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            File directory = new File(ResourceCacheKt.azureDataCacheDir($receiver), it);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            return directory;
        }
        return null;
    }

    @NotNull
    public static final File azureDataCacheDir(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        File directory = new File($receiver.getCacheDir(), "com.azuredata.data");
        if (!directory.exists()) {
            directory.mkdir();
        }
        return directory;
    }

    private static final void createEmptyChildDirectoriesIfNecessary(File parent, ResourceType resourceType) {
        Iterable $receiver$iv = resourceType.getChildren();
        for (Object element$iv : $receiver$iv) {
            ResourceType it = (ResourceType)((Object)element$iv);
            boolean bl = false;
            File childDirectory = new File(parent, it.getPath());
            if (childDirectory.exists()) continue;
            childDirectory.mkdirs();
        }
    }

    @Nullable
    public static final <T> T safe(@NotNull Function0<? extends T> block) {
        Object object;
        int $i$f$safe = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            object = block.invoke();
        }
        catch (Exception ex) {
            boolean $i$f$e = false;
            int level$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex);
            }
            object = null;
        }
        return (T)object;
    }

    public static final void safeExecute(@NotNull Function0<Unit> block) {
        int $i$f$safeExecute = 0;
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        try {
            Unit unit = (Unit)block.invoke();
        }
        catch (Exception ex) {
            boolean $i$f$e = false;
            int level$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ File access$resourceCacheFile(Context $receiver, ResourceLocation resourceLocation) {
        return ResourceCacheKt.resourceCacheFile($receiver, resourceLocation);
    }

    public static final /* synthetic */ List access$resourceCacheFiles(Context $receiver, ResourceLocation resourceLocation) {
        return ResourceCacheKt.resourceCacheFiles($receiver, resourceLocation);
    }

    public static final /* synthetic */ File access$resourceCacheDir(Context $receiver, Resource resource) {
        return ResourceCacheKt.resourceCacheDir($receiver, resource);
    }

    public static final /* synthetic */ File access$resourceCacheDir(Context $receiver, ResourceLocation resourceLocation) {
        return ResourceCacheKt.resourceCacheDir($receiver, resourceLocation);
    }
}

