/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.model;

import com.azure.data.model.ResourceType;
import com.azure.data.util.ResourceExtensionsKt;
import com.azure.data.util.ResourceOracle;
import com.azure.data.util.StringExtensionsKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\f\u001c\u001d\u001e\u001f !\"#$%&'B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u0012J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u0014\u001a\u00020\u0005J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0002J\u0006\u0010\u0016\u001a\u00020\u0005J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0005J\u0006\u0010\u0019\u001a\u00020\u0005J\f\u0010\u0016\u001a\u00020\u0005*\u0004\u0018\u00010\u0005J\u0016\u0010\u001a\u001a\u00020\u0005*\u0004\u0018\u00010\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u0082\u0001\f()*+,-./0123\u00a8\u00064"}, d2={"Lcom/azure/data/model/ResourceLocation;", "", "resourceType", "Lcom/azure/data/model/ResourceType;", "id", "", "(Lcom/azure/data/model/ResourceType;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "isFeed", "", "()Z", "getResourceType", "()Lcom/azure/data/model/ResourceType;", "supportsPermissionToken", "getSupportsPermissionToken", "altLink", "ancestorIds", "", "directory", "link", "parentSelfLink", "path", "selfLink", "resourceId", "type", "pathIn", "parent", "Attachment", "Child", "Collection", "Database", "Document", "Offer", "Permission", "Resource", "StoredProcedure", "Trigger", "Udf", "User", "Lcom/azure/data/model/ResourceLocation$Database;", "Lcom/azure/data/model/ResourceLocation$User;", "Lcom/azure/data/model/ResourceLocation$Permission;", "Lcom/azure/data/model/ResourceLocation$Collection;", "Lcom/azure/data/model/ResourceLocation$StoredProcedure;", "Lcom/azure/data/model/ResourceLocation$Trigger;", "Lcom/azure/data/model/ResourceLocation$Udf;", "Lcom/azure/data/model/ResourceLocation$Document;", "Lcom/azure/data/model/ResourceLocation$Attachment;", "Lcom/azure/data/model/ResourceLocation$Offer;", "Lcom/azure/data/model/ResourceLocation$Resource;", "Lcom/azure/data/model/ResourceLocation$Child;", "azuredata_release"})
public abstract class ResourceLocation {
    @NotNull
    private final ResourceType resourceType;
    @Nullable
    private final String id;

    @NotNull
    public final String path() {
        String string;
        ResourceLocation resourceLocation = this;
        if (resourceLocation instanceof Database) {
            string = "dbs" + this.path(this.id);
        } else if (resourceLocation instanceof User) {
            string = "dbs/" + ((User)this).getDatabaseId() + "/users" + this.path(this.id);
        } else if (resourceLocation instanceof Permission) {
            string = "dbs/" + ((Permission)this).getDatabaseId() + "/users/" + ((Permission)this).getUserId() + "/permissions" + this.path(this.id);
        } else if (resourceLocation instanceof Collection) {
            string = "dbs/" + ((Collection)this).getDatabaseId() + "/colls" + this.path(this.id);
        } else if (resourceLocation instanceof StoredProcedure) {
            string = "dbs/" + ((StoredProcedure)this).getDatabaseId() + "/colls/" + ((StoredProcedure)this).getCollectionId() + "/sprocs" + this.path(this.id);
        } else if (resourceLocation instanceof Trigger) {
            string = "dbs/" + ((Trigger)this).getDatabaseId() + "/colls/" + ((Trigger)this).getCollectionId() + "/triggers" + this.path(this.id);
        } else if (resourceLocation instanceof Udf) {
            string = "dbs/" + ((Udf)this).getDatabaseId() + "/colls/" + ((Udf)this).getCollectionId() + "/udfs" + this.path(this.id);
        } else if (resourceLocation instanceof Document) {
            string = "dbs/" + ((Document)this).getDatabaseId() + "/colls/" + ((Document)this).getCollectionId() + "/docs" + this.path(this.id);
        } else if (resourceLocation instanceof Attachment) {
            string = "dbs/" + ((Attachment)this).getDatabaseId() + "/colls/" + ((Attachment)this).getCollectionId() + "/docs/" + ((Attachment)this).getDocumentId() + "/attachments" + this.path(this.id);
        } else if (resourceLocation instanceof Offer) {
            string = "offers" + this.path(this.id);
        } else if (resourceLocation instanceof Resource) {
            string = ResourceOracle.Companion.getShared().getAltLink(((Resource)this).getResource());
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else if (resourceLocation instanceof Child) {
            string = Intrinsics.stringPlus((String)ResourceOracle.Companion.getShared().getAltLink(((Child)this).getResource()), (Object)('/' + this.resourceType.getPath() + this.path(this.id)));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final String link() {
        String string;
        block9: {
            ResourceLocation resourceLocation;
            block18: {
                block19: {
                    String string2;
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    block13: {
                                        block12: {
                                            block11: {
                                                block10: {
                                                    block8: {
                                                        resourceLocation = this;
                                                        if (!(resourceLocation instanceof Database)) break block8;
                                                        string = this.pathIn(this.id, "dbs");
                                                        break block9;
                                                    }
                                                    if (!(resourceLocation instanceof User)) break block10;
                                                    string = "dbs/" + ((User)this).getDatabaseId() + this.pathIn(this.id, "/users");
                                                    break block9;
                                                }
                                                if (!(resourceLocation instanceof Permission)) break block11;
                                                string = "dbs/" + ((Permission)this).getDatabaseId() + "/users/" + ((Permission)this).getUserId() + this.pathIn(this.id, "/permissions");
                                                break block9;
                                            }
                                            if (!(resourceLocation instanceof Collection)) break block12;
                                            string = "dbs/" + ((Collection)this).getDatabaseId() + this.pathIn(this.id, "/colls");
                                            break block9;
                                        }
                                        if (!(resourceLocation instanceof StoredProcedure)) break block13;
                                        string = "dbs/" + ((StoredProcedure)this).getDatabaseId() + "/colls/" + ((StoredProcedure)this).getCollectionId() + this.pathIn(this.id, "/sprocs");
                                        break block9;
                                    }
                                    if (!(resourceLocation instanceof Trigger)) break block14;
                                    string = "dbs/" + ((Trigger)this).getDatabaseId() + "/colls/" + ((Trigger)this).getCollectionId() + this.pathIn(this.id, "/triggers");
                                    break block9;
                                }
                                if (!(resourceLocation instanceof Udf)) break block15;
                                string = "dbs/" + ((Udf)this).getDatabaseId() + "/colls/" + ((Udf)this).getCollectionId() + this.pathIn(this.id, "/udfs");
                                break block9;
                            }
                            if (!(resourceLocation instanceof Document)) break block16;
                            string = "dbs/" + ((Document)this).getDatabaseId() + "/colls/" + ((Document)this).getCollectionId() + this.pathIn(this.id, "/docs");
                            break block9;
                        }
                        if (!(resourceLocation instanceof Attachment)) break block17;
                        string = "dbs/" + ((Attachment)this).getDatabaseId() + "/colls/" + ((Attachment)this).getCollectionId() + "/docs/" + ((Attachment)this).getDocumentId() + this.pathIn(this.id, "/attachments");
                        break block9;
                    }
                    if (!(resourceLocation instanceof Offer)) break block18;
                    string = this.id;
                    if (string == null) break block19;
                    String string3 = string2 = string;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                    string = string4;
                    if (string4 != null) break block9;
                }
                string = "";
                break block9;
            }
            if (resourceLocation instanceof Resource) {
                string = ResourceOracle.Companion.getShared().getAltLink(((Resource)this).getResource());
                if (string == null) {
                    Intrinsics.throwNpe();
                }
            } else if (resourceLocation instanceof Child) {
                string = Intrinsics.stringPlus((String)ResourceOracle.Companion.getShared().getAltLink(((Child)this).getResource()), (Object)this.pathIn(this.id, '/' + this.resourceType.getPath()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @NotNull
    public final String type() {
        return this.resourceType.getPath();
    }

    @Nullable
    public final String id() {
        ResourceLocation resourceLocation = this;
        return resourceLocation instanceof Resource ? ((Resource)this).getResource().getId() : this.id;
    }

    @NotNull
    public final Map<ResourceType, String> ancestorIds() {
        ResourceLocation resourceLocation = this;
        return resourceLocation instanceof User ? MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)ResourceType.Database), (Object)((User)this).getDatabaseId())) : (resourceLocation instanceof Permission ? MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)ResourceType.Database), (Object)((Permission)this).getDatabaseId()), TuplesKt.to((Object)((Object)ResourceType.User), (Object)((Permission)this).getUserId())}) : (resourceLocation instanceof Collection ? MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)ResourceType.Database), (Object)((Collection)this).getDatabaseId())) : (resourceLocation instanceof StoredProcedure ? MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)ResourceType.Database), (Object)((StoredProcedure)this).getDatabaseId()), TuplesKt.to((Object)((Object)ResourceType.Collection), (Object)((StoredProcedure)this).getCollectionId())}) : (resourceLocation instanceof Trigger ? MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)ResourceType.Database), (Object)((Trigger)this).getDatabaseId()), TuplesKt.to((Object)((Object)ResourceType.Collection), (Object)((Trigger)this).getCollectionId())}) : (resourceLocation instanceof Udf ? MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)ResourceType.Database), (Object)((Udf)this).getDatabaseId()), TuplesKt.to((Object)((Object)ResourceType.Collection), (Object)((Udf)this).getCollectionId())}) : (resourceLocation instanceof Document ? MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)ResourceType.Database), (Object)((Document)this).getDatabaseId()), TuplesKt.to((Object)((Object)ResourceType.Collection), (Object)((Document)this).getCollectionId())}) : (resourceLocation instanceof Attachment ? MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)ResourceType.Database), (Object)((Attachment)this).getDatabaseId()), TuplesKt.to((Object)((Object)ResourceType.Collection), (Object)((Attachment)this).getCollectionId()), TuplesKt.to((Object)((Object)ResourceType.Document), (Object)((Attachment)this).getDocumentId())}) : (resourceLocation instanceof Resource ? ResourceExtensionsKt.ancestorIds$default(((Resource)this).getResource(), false, 1, null) : (resourceLocation instanceof Child ? ResourceExtensionsKt.ancestorIds(((Child)this).getResource(), true) : MapsKt.emptyMap())))))))));
    }

    @NotNull
    public final String altLink(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return StringsKt.equals((String)StringExtensionsKt.lastPathComponent(this.path()), (String)id, (boolean)true) ? this.path() : this.path() + '/' + id;
    }

    @Nullable
    public final String selfLink(@NotNull String resourceId) {
        Intrinsics.checkParameterIsNotNull((Object)resourceId, (String)"resourceId");
        String string = this.directory();
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            return it + '/' + resourceId;
        }
        return null;
    }

    public final boolean getSupportsPermissionToken() {
        return this.resourceType.getSupportsPermissionToken();
    }

    public final boolean isFeed() {
        CharSequence charSequence = this.id;
        return charSequence == null || charSequence.length() == 0;
    }

    @NotNull
    public final String path(@Nullable String $receiver) {
        CharSequence charSequence = $receiver;
        if (!(charSequence == null || charSequence.length() == 0)) {
            return '/' + $receiver;
        }
        return "";
    }

    private final String pathIn(@Nullable String $receiver, String parent) {
        CharSequence charSequence = $receiver;
        if (!(charSequence == null || charSequence.length() == 0) && !((charSequence = (CharSequence)parent).length() == 0)) {
            return parent + '/' + $receiver;
        }
        return "";
    }

    private final String directory() {
        String string = this.parentSelfLink();
        if (string != null) {
            String string2;
            String string3;
            String it = string3 = string;
            boolean bl = false;
            ResourceLocation resourceLocation = this;
            if (resourceLocation instanceof Database) {
                string2 = it;
            } else if (resourceLocation instanceof User) {
                string2 = it + "users";
            } else if (resourceLocation instanceof Collection) {
                string2 = it + "colls";
            } else if (resourceLocation instanceof StoredProcedure) {
                string2 = it + "sprocs";
            } else if (resourceLocation instanceof Trigger) {
                string2 = it + "triggers";
            } else if (resourceLocation instanceof Udf) {
                string2 = it + "udfs";
            } else if (resourceLocation instanceof Document) {
                string2 = it + "docs";
            } else if (resourceLocation instanceof Attachment) {
                string2 = it + "attachments";
            } else if (resourceLocation instanceof Permission) {
                string2 = it + "permissions";
            } else if (resourceLocation instanceof Offer) {
                string2 = it;
            } else if (resourceLocation instanceof Child) {
                string2 = it + this.resourceType.getPath();
            } else if (resourceLocation instanceof Resource) {
                String string4 = ResourceOracle.Companion.getShared().getSelfLink(((Resource)this).getResource());
                string2 = string4 != null ? StringExtensionsKt.lastPathComponentRemoved(string4) : null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string2;
        }
        return null;
    }

    private final String parentSelfLink() {
        String string;
        ResourceLocation resourceLocation = this;
        if (resourceLocation instanceof Database) {
            string = "dbs";
        } else if (resourceLocation instanceof User) {
            string = ResourceOracle.Companion.getShared().getSelfLink(new Database(((User)this).getDatabaseId()));
        } else if (resourceLocation instanceof Collection) {
            string = ResourceOracle.Companion.getShared().getSelfLink(new Database(((Collection)this).getDatabaseId()));
        } else if (resourceLocation instanceof StoredProcedure) {
            string = ResourceOracle.Companion.getShared().getSelfLink(new Collection(((StoredProcedure)this).getDatabaseId(), ((StoredProcedure)this).getCollectionId()));
        } else if (resourceLocation instanceof Trigger) {
            string = ResourceOracle.Companion.getShared().getSelfLink(new Collection(((Trigger)this).getDatabaseId(), ((Trigger)this).getCollectionId()));
        } else if (resourceLocation instanceof Udf) {
            string = ResourceOracle.Companion.getShared().getSelfLink(new Collection(((Udf)this).getDatabaseId(), ((Udf)this).getCollectionId()));
        } else if (resourceLocation instanceof Document) {
            string = ResourceOracle.Companion.getShared().getSelfLink(new Collection(((Document)this).getDatabaseId(), ((Document)this).getCollectionId()));
        } else if (resourceLocation instanceof Attachment) {
            string = ResourceOracle.Companion.getShared().getSelfLink(new Document(((Attachment)this).getDatabaseId(), ((Attachment)this).getCollectionId(), ((Attachment)this).getDocumentId()));
        } else if (resourceLocation instanceof Permission) {
            string = ResourceOracle.Companion.getShared().getSelfLink(new User(((Permission)this).getDatabaseId(), ((Permission)this).getUserId()));
        } else if (resourceLocation instanceof Offer) {
            string = "offers";
        } else if (resourceLocation instanceof Child) {
            string = ResourceOracle.Companion.getShared().getSelfLink(((Child)this).getResource());
        } else if (resourceLocation instanceof Resource) {
            String string2 = ResourceOracle.Companion.getShared().getSelfLink(((Resource)this).getResource());
            string = string2 != null && (string2 = StringExtensionsKt.lastPathComponentRemoved(string2)) != null ? StringExtensionsKt.lastPathComponentRemoved(string2) : null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final ResourceType getResourceType() {
        return this.resourceType;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    private ResourceLocation(ResourceType resourceType, String id) {
        this.resourceType = resourceType;
        this.id = id;
    }

    /* synthetic */ ResourceLocation(ResourceType resourceType, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        this(resourceType, string);
    }

    public /* synthetic */ ResourceLocation(ResourceType resourceType, String id, DefaultConstructorMarker $constructor_marker) {
        this(resourceType, id);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/azure/data/model/ResourceLocation$Database;", "Lcom/azure/data/model/ResourceLocation;", "id", "", "(Ljava/lang/String;)V", "azuredata_release"})
    public static final class Database
    extends ResourceLocation {
        public Database(@Nullable String id) {
            super(ResourceType.Database, id, null);
        }

        public /* synthetic */ Database(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        public Database() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/azure/data/model/ResourceLocation$User;", "Lcom/azure/data/model/ResourceLocation;", "databaseId", "", "id", "(Ljava/lang/String;Ljava/lang/String;)V", "getDatabaseId", "()Ljava/lang/String;", "azuredata_release"})
    public static final class User
    extends ResourceLocation {
        @NotNull
        private final String databaseId;

        @NotNull
        public final String getDatabaseId() {
            return this.databaseId;
        }

        public User(@NotNull String databaseId, @Nullable String id) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            super(ResourceType.User, id, null);
            this.databaseId = databaseId;
        }

        public /* synthetic */ User(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/azure/data/model/ResourceLocation$Permission;", "Lcom/azure/data/model/ResourceLocation;", "databaseId", "", "userId", "id", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDatabaseId", "()Ljava/lang/String;", "getUserId", "azuredata_release"})
    public static final class Permission
    extends ResourceLocation {
        @NotNull
        private final String databaseId;
        @NotNull
        private final String userId;

        @NotNull
        public final String getDatabaseId() {
            return this.databaseId;
        }

        @NotNull
        public final String getUserId() {
            return this.userId;
        }

        public Permission(@NotNull String databaseId, @NotNull String userId, @Nullable String id) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
            super(ResourceType.Permission, id, null);
            this.databaseId = databaseId;
            this.userId = userId;
        }

        public /* synthetic */ Permission(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/azure/data/model/ResourceLocation$Collection;", "Lcom/azure/data/model/ResourceLocation;", "databaseId", "", "id", "(Ljava/lang/String;Ljava/lang/String;)V", "getDatabaseId", "()Ljava/lang/String;", "azuredata_release"})
    public static final class Collection
    extends ResourceLocation {
        @NotNull
        private final String databaseId;

        @NotNull
        public final String getDatabaseId() {
            return this.databaseId;
        }

        public Collection(@NotNull String databaseId, @Nullable String id) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            super(ResourceType.Collection, id, null);
            this.databaseId = databaseId;
        }

        public /* synthetic */ Collection(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/azure/data/model/ResourceLocation$StoredProcedure;", "Lcom/azure/data/model/ResourceLocation;", "databaseId", "", "collectionId", "id", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCollectionId", "()Ljava/lang/String;", "getDatabaseId", "azuredata_release"})
    public static final class StoredProcedure
    extends ResourceLocation {
        @NotNull
        private final String databaseId;
        @NotNull
        private final String collectionId;

        @NotNull
        public final String getDatabaseId() {
            return this.databaseId;
        }

        @NotNull
        public final String getCollectionId() {
            return this.collectionId;
        }

        public StoredProcedure(@NotNull String databaseId, @NotNull String collectionId, @Nullable String id) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            super(ResourceType.StoredProcedure, id, null);
            this.databaseId = databaseId;
            this.collectionId = collectionId;
        }

        public /* synthetic */ StoredProcedure(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/azure/data/model/ResourceLocation$Trigger;", "Lcom/azure/data/model/ResourceLocation;", "databaseId", "", "collectionId", "id", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCollectionId", "()Ljava/lang/String;", "getDatabaseId", "azuredata_release"})
    public static final class Trigger
    extends ResourceLocation {
        @NotNull
        private final String databaseId;
        @NotNull
        private final String collectionId;

        @NotNull
        public final String getDatabaseId() {
            return this.databaseId;
        }

        @NotNull
        public final String getCollectionId() {
            return this.collectionId;
        }

        public Trigger(@NotNull String databaseId, @NotNull String collectionId, @Nullable String id) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            super(ResourceType.Trigger, id, null);
            this.databaseId = databaseId;
            this.collectionId = collectionId;
        }

        public /* synthetic */ Trigger(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/azure/data/model/ResourceLocation$Udf;", "Lcom/azure/data/model/ResourceLocation;", "databaseId", "", "collectionId", "id", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCollectionId", "()Ljava/lang/String;", "getDatabaseId", "azuredata_release"})
    public static final class Udf
    extends ResourceLocation {
        @NotNull
        private final String databaseId;
        @NotNull
        private final String collectionId;

        @NotNull
        public final String getDatabaseId() {
            return this.databaseId;
        }

        @NotNull
        public final String getCollectionId() {
            return this.collectionId;
        }

        public Udf(@NotNull String databaseId, @NotNull String collectionId, @Nullable String id) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            super(ResourceType.Udf, id, null);
            this.databaseId = databaseId;
            this.collectionId = collectionId;
        }

        public /* synthetic */ Udf(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/azure/data/model/ResourceLocation$Document;", "Lcom/azure/data/model/ResourceLocation;", "databaseId", "", "collectionId", "id", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCollectionId", "()Ljava/lang/String;", "getDatabaseId", "azuredata_release"})
    public static final class Document
    extends ResourceLocation {
        @NotNull
        private final String databaseId;
        @NotNull
        private final String collectionId;

        @NotNull
        public final String getDatabaseId() {
            return this.databaseId;
        }

        @NotNull
        public final String getCollectionId() {
            return this.collectionId;
        }

        public Document(@NotNull String databaseId, @NotNull String collectionId, @Nullable String id) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            super(ResourceType.Document, id, null);
            this.databaseId = databaseId;
            this.collectionId = collectionId;
        }

        public /* synthetic */ Document(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/azure/data/model/ResourceLocation$Attachment;", "Lcom/azure/data/model/ResourceLocation;", "databaseId", "", "collectionId", "documentId", "id", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCollectionId", "()Ljava/lang/String;", "getDatabaseId", "getDocumentId", "azuredata_release"})
    public static final class Attachment
    extends ResourceLocation {
        @NotNull
        private final String databaseId;
        @NotNull
        private final String collectionId;
        @NotNull
        private final String documentId;

        @NotNull
        public final String getDatabaseId() {
            return this.databaseId;
        }

        @NotNull
        public final String getCollectionId() {
            return this.collectionId;
        }

        @NotNull
        public final String getDocumentId() {
            return this.documentId;
        }

        public Attachment(@NotNull String databaseId, @NotNull String collectionId, @NotNull String documentId, @Nullable String id) {
            Intrinsics.checkParameterIsNotNull((Object)databaseId, (String)"databaseId");
            Intrinsics.checkParameterIsNotNull((Object)collectionId, (String)"collectionId");
            Intrinsics.checkParameterIsNotNull((Object)documentId, (String)"documentId");
            super(ResourceType.Attachment, id, null);
            this.databaseId = databaseId;
            this.collectionId = collectionId;
            this.documentId = documentId;
        }

        public /* synthetic */ Attachment(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string4 = null;
            }
            this(string, string2, string3, string4);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/azure/data/model/ResourceLocation$Offer;", "Lcom/azure/data/model/ResourceLocation;", "id", "", "(Ljava/lang/String;)V", "azuredata_release"})
    public static final class Offer
    extends ResourceLocation {
        public Offer(@Nullable String id) {
            super(ResourceType.Offer, id, null);
        }

        public /* synthetic */ Offer(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        public Offer() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/azure/data/model/ResourceLocation$Resource;", "Lcom/azure/data/model/ResourceLocation;", "resource", "Lcom/azure/data/model/Resource;", "(Lcom/azure/data/model/Resource;)V", "getResource", "()Lcom/azure/data/model/Resource;", "azuredata_release"})
    public static final class Resource
    extends ResourceLocation {
        @NotNull
        private final com.azure.data.model.Resource resource;

        @NotNull
        public final com.azure.data.model.Resource getResource() {
            return this.resource;
        }

        public Resource(@NotNull com.azure.data.model.Resource resource) {
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            super(ResourceType.Companion.fromType(resource.getClass()), resource.getId(), null);
            this.resource = resource;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/azure/data/model/ResourceLocation$Child;", "Lcom/azure/data/model/ResourceLocation;", "resourceType", "Lcom/azure/data/model/ResourceType;", "resource", "Lcom/azure/data/model/Resource;", "id", "", "(Lcom/azure/data/model/ResourceType;Lcom/azure/data/model/Resource;Ljava/lang/String;)V", "getResource", "()Lcom/azure/data/model/Resource;", "azuredata_release"})
    public static final class Child
    extends ResourceLocation {
        @NotNull
        private final com.azure.data.model.Resource resource;

        @NotNull
        public final com.azure.data.model.Resource getResource() {
            return this.resource;
        }

        public Child(@NotNull ResourceType resourceType, @NotNull com.azure.data.model.Resource resource, @Nullable String id) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)resourceType), (String)"resourceType");
            Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
            super(resourceType, id, null);
            this.resource = resource;
        }

        public /* synthetic */ Child(ResourceType resourceType, com.azure.data.model.Resource resource, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string = null;
            }
            this(resourceType, resource, string);
        }
    }
}

