/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import com.azure.core.log.LoggerKt;
import com.azure.core.util.ContextProvider;
import com.azure.data.model.Resource;
import com.azure.data.model.ResourceList;
import com.azure.data.model.ResourceLocation;
import com.azure.data.service.ResourceCacheKt;
import com.azure.data.service.ResourceEncryptor;
import com.azure.data.util.ResourceOracle;
import com.azure.data.util.json.GsonConfigKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0015J\u001e\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J-\u0010\u001c\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00120 \u00a2\u0006\u0002\u0010!J,\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0017\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00120 J\u0006\u0010#\u001a\u00020\u0011J\u000e\u0010$\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u001eJ\u001d\u0010&\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006("}, d2={"Lcom/azure/data/service/ResourceCache;", "", "()V", "executor", "Ljava/util/concurrent/ExecutorService;", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "resourceEncryptor", "Lcom/azure/data/service/ResourceEncryptor;", "getResourceEncryptor", "()Lcom/azure/data/service/ResourceEncryptor;", "setResourceEncryptor", "(Lcom/azure/data/service/ResourceEncryptor;)V", "cache", "", "T", "Lcom/azure/data/model/Resource;", "resource", "(Lcom/azure/data/model/Resource;)V", "resources", "Lcom/azure/data/model/ResourceList;", "decrypt", "", "data", "encrypt", "getResourceAt", "location", "Lcom/azure/data/model/ResourceLocation;", "resourceClass", "Ljava/lang/Class;", "(Lcom/azure/data/model/ResourceLocation;Ljava/lang/Class;)Lcom/azure/data/model/Resource;", "getResourcesAt", "purge", "remove", "resourceLocation", "replace", "Companion", "azuredata_release"})
public final class ResourceCache {
    private boolean isEnabled = true;
    @Nullable
    private ResourceEncryptor resourceEncryptor;
    private ExecutorService executor;
    @NotNull
    private static ResourceCache shared;
    public static final Companion Companion;

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    @Nullable
    public final ResourceEncryptor getResourceEncryptor() {
        return this.resourceEncryptor;
    }

    public final void setResourceEncryptor(@Nullable ResourceEncryptor resourceEncryptor2) {
        this.resourceEncryptor = resourceEncryptor2;
    }

    public final <T extends Resource> void cache(@NotNull T resource) {
        Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
        ResourceOracle.Companion.getShared().storeLinks(resource);
        if (this.isEnabled) {
            this.executor.execute(new Runnable(this, resource){
                final /* synthetic */ ResourceCache this$0;
                final /* synthetic */ Resource $resource;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    boolean $i$f$safeExecute = false;
                    try {
                        boolean bl = false;
                        File file = ResourceCacheKt.resourceCacheFile(ContextProvider.Companion.getAppContext(), this.$resource);
                        if (file != null) {
                            Object object;
                            File file2;
                            File it = file2 = file;
                            boolean bl2 = false;
                            Object object2 = it;
                            Object object3 = Charsets.UTF_8;
                            int n = 8192;
                            Object object4 = object = object2;
                            object = new OutputStreamWriter((OutputStream)(object4 = (OutputStream)new FileOutputStream((File)object4)), (Charset)object3);
                            object2 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
                            object3 = null;
                            try {
                                BufferedWriter it2 = (BufferedWriter)object2;
                                boolean bl3 = false;
                                String string = GsonConfigKt.getGson().toJson((Object)this.$resource);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(resource)");
                                it2.write(ResourceCache.access$encrypt(this.this$0, string));
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable) {
                                object3 = throwable;
                                throw throwable;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Exception ex$iv) {
                        boolean $i$f$e = false;
                        int level$iv$iv$iv = 6;
                        boolean $i$f$log = false;
                        if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                            boolean bl = false;
                            Timber.e((Throwable)ex$iv);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
                {
                    this.this$0 = resourceCache;
                    this.$resource = resource;
                }
            });
        }
    }

    public final <T extends Resource> void cache(@NotNull ResourceList<T> resources) {
        Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
        ResourceOracle.Companion.getShared().storeLinks(resources);
        Iterable $receiver$iv = resources.getItems();
        for (Object element$iv : $receiver$iv) {
            Resource it = (Resource)element$iv;
            boolean bl = false;
            this.cache(it);
        }
    }

    public final <T extends Resource> void replace(@NotNull T resource) {
        Intrinsics.checkParameterIsNotNull(resource, (String)"resource");
        this.remove(resource);
        this.cache(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T extends Resource> T getResourceAt(@NotNull ResourceLocation location, @NotNull Class<T> resourceClass) {
        Resource resource;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull(resourceClass, (String)"resourceClass");
        if (!this.isEnabled) {
            return null;
        }
        boolean $i$f$safe = false;
        try {
            Resource resource2;
            boolean bl = false;
            File file = ResourceCacheKt.access$resourceCacheFile(ContextProvider.Companion.getAppContext(), location);
            if (file != null) {
                Object object;
                File file2;
                File it = file2 = file;
                boolean bl2 = false;
                Object object2 = it;
                Object object3 = Charsets.UTF_8;
                int n = 8192;
                Object object4 = object = object2;
                object = new InputStreamReader((InputStream)(object4 = (InputStream)new FileInputStream((File)object4)), (Charset)object3);
                object2 = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
                object3 = null;
                try {
                    BufferedReader it2 = (BufferedReader)object2;
                    boolean bl3 = false;
                    Resource resource3 = (Resource)GsonConfigKt.getGson().fromJson(this.decrypt(TextStreamsKt.readText((Reader)it2)), resourceClass);
                    resource2 = resource3;
                }
                catch (Throwable throwable) {
                    object3 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                }
            } else {
                resource2 = null;
            }
            resource = resource2;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            resource = null;
        }
        return (T)resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends Resource> ResourceList<T> getResourcesAt(@NotNull ResourceLocation location, @NotNull Class<T> resourceClass) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull(resourceClass, (String)"resourceClass");
        ResourceList resources = new ResourceList();
        if (this.isEnabled) {
            boolean $i$f$safeExecute = false;
            try {
                Collection<Resource> collection;
                void $receiver$iv$iv;
                void $receiver$iv;
                boolean bl = false;
                Iterable iterable = ResourceCacheKt.access$resourceCacheFiles(ContextProvider.Companion.getAppContext(), location);
                ResourceList resourceList = resources;
                void var8_8 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    Resource resource;
                    void it;
                    File file = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    Closeable closeable = it;
                    Object object = Charsets.UTF_8;
                    int n = 8192;
                    Reader reader = closeable;
                    InputStream inputStream = reader;
                    reader = new InputStreamReader(inputStream = (InputStream)new FileInputStream((File)((Object)inputStream)), (Charset)object);
                    closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                    object = null;
                    try {
                        BufferedReader it2 = (BufferedReader)closeable;
                        boolean bl3 = false;
                        resource = (Resource)GsonConfigKt.getGson().fromJson(this.decrypt(TextStreamsKt.readText((Reader)it2)), resourceClass);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    }
                    Resource resource2 = resource;
                    collection.add(resource2);
                }
                collection = (List)destination$iv$iv;
                resourceList.setItems(collection);
                iterable = resources.getItems();
                resourceList = resources;
                int n = iterable.size();
                resourceList.setCount(n);
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception ex$iv) {
                boolean $i$f$e = false;
                int level$iv$iv$iv = 6;
                boolean $i$f$log = false;
                if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Timber.e((Throwable)ex$iv);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return resources;
    }

    public final void remove(@NotNull Resource resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        ResourceOracle.removeLinks$default(ResourceOracle.Companion.getShared(), resource, false, 2, null);
        if (this.isEnabled) {
            boolean $i$f$safeExecute = false;
            try {
                boolean bl = false;
                this.executor.execute(new Runnable(this, resource){
                    final /* synthetic */ ResourceCache this$0;
                    final /* synthetic */ Resource $resource$inlined;
                    {
                        this.this$0 = resourceCache;
                        this.$resource$inlined = resource;
                    }

                    public final void run() {
                        block0: {
                            File file;
                            File file2 = ResourceCacheKt.access$resourceCacheDir(ContextProvider.Companion.getAppContext(), this.$resource$inlined);
                            if (file2 == null) break block0;
                            File it = file = file2;
                            boolean bl = false;
                            FilesKt.deleteRecursively((File)it);
                        }
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception ex$iv) {
                boolean $i$f$e = false;
                int level$iv$iv$iv = 6;
                boolean $i$f$log = false;
                if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Timber.e((Throwable)ex$iv);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void remove(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        ResourceOracle.removeLinks$default(ResourceOracle.Companion.getShared(), resourceLocation, false, 2, null);
        if (this.isEnabled) {
            boolean $i$f$safeExecute = false;
            try {
                boolean bl = false;
                this.executor.execute(new Runnable(this, resourceLocation){
                    final /* synthetic */ ResourceCache this$0;
                    final /* synthetic */ ResourceLocation $resourceLocation$inlined;
                    {
                        this.this$0 = resourceCache;
                        this.$resourceLocation$inlined = resourceLocation;
                    }

                    public final void run() {
                        block0: {
                            File file;
                            File file2 = ResourceCacheKt.access$resourceCacheDir(ContextProvider.Companion.getAppContext(), this.$resourceLocation$inlined);
                            if (file2 == null) break block0;
                            File it = file = file2;
                            boolean bl = false;
                            FilesKt.deleteRecursively((File)it);
                        }
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Exception ex$iv) {
                boolean $i$f$e = false;
                int level$iv$iv$iv = 6;
                boolean $i$f$log = false;
                if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Timber.e((Throwable)ex$iv);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void purge() {
        boolean $i$f$safeExecute = false;
        try {
            boolean bl = false;
            ResourceOracle.Companion.getShared().purge();
            File databasesDir = new File(ResourceCacheKt.azureDataCacheDir(ContextProvider.Companion.getAppContext()), "dbs");
            File offersDir = new File(ResourceCacheKt.azureDataCacheDir(ContextProvider.Companion.getAppContext()), "offers");
            if (databasesDir.exists() && databasesDir.isDirectory()) {
                FilesKt.deleteRecursively((File)databasesDir);
            }
            if (offersDir.exists() && offersDir.isDirectory()) {
                FilesKt.deleteRecursively((File)offersDir);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception ex$iv) {
            boolean $i$f$e = false;
            int level$iv$iv$iv = 6;
            boolean $i$f$log = false;
            if (level$iv$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                boolean bl = false;
                Timber.e((Throwable)ex$iv);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String encrypt(String data) {
        ResourceEncryptor resourceEncryptor2 = this.resourceEncryptor;
        if (resourceEncryptor2 != null) {
            ResourceEncryptor resourceEncryptor3;
            ResourceEncryptor it = resourceEncryptor3 = resourceEncryptor2;
            boolean bl = false;
            return it.encrypt(data);
        }
        return data;
    }

    private final String decrypt(String data) {
        ResourceEncryptor resourceEncryptor2 = this.resourceEncryptor;
        if (resourceEncryptor2 != null) {
            ResourceEncryptor resourceEncryptor3;
            ResourceEncryptor it = resourceEncryptor3 = resourceEncryptor2;
            boolean bl = false;
            return it.decrypt(data);
        }
        return data;
    }

    private ResourceCache() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"Executors.newCachedThreadPool()");
        this.executor = executorService;
    }

    static {
        Companion = new Companion(null);
        shared = new ResourceCache();
    }

    public static final /* synthetic */ String access$encrypt(ResourceCache $this, String data) {
        return $this.encrypt(data);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/azure/data/service/ResourceCache$Companion;", "", "()V", "shared", "Lcom/azure/data/service/ResourceCache;", "getShared", "()Lcom/azure/data/service/ResourceCache;", "setShared", "(Lcom/azure/data/service/ResourceCache;)V", "azuredata_release"})
    public static final class Companion {
        @NotNull
        public final ResourceCache getShared() {
            return shared;
        }

        public final void setShared(@NotNull ResourceCache resourceCache) {
            Intrinsics.checkParameterIsNotNull((Object)resourceCache, (String)"<set-?>");
            shared = resourceCache;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

