/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.model;

import com.azure.data.model.Attachment;
import com.azure.data.model.Database;
import com.azure.data.model.Document;
import com.azure.data.model.DocumentCollection;
import com.azure.data.model.Offer;
import com.azure.data.model.Permission;
import com.azure.data.model.Resource;
import com.azure.data.model.ResourceList;
import com.azure.data.model.ResourceType$WhenMappings;
import com.azure.data.model.StoredProcedure;
import com.azure.data.model.Trigger;
import com.azure.data.model.User;
import com.azure.data.model.UserDefinedFunction;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u0086\u0001\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001%B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011j\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$\u00a8\u0006&"}, d2={"Lcom/azure/data/model/ResourceType;", "", "path", "", "fullname", "type", "Ljava/lang/reflect/Type;", "listType", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/reflect/Type;Ljava/lang/reflect/Type;)V", "children", "", "getChildren", "()Ljava/util/List;", "listName", "getListName", "()Ljava/lang/String;", "getListType", "()Ljava/lang/reflect/Type;", "getPath", "supportsPermissionToken", "", "getSupportsPermissionToken", "()Z", "getType", "isAncestorOf", "resourceType", "isDecendentOf", "Database", "User", "Permission", "Collection", "StoredProcedure", "Trigger", "Udf", "Document", "Attachment", "Offer", "Companion", "azuredata_release"})
public final class ResourceType
extends Enum<ResourceType> {
    public static final /* enum */ ResourceType Database;
    public static final /* enum */ ResourceType User;
    public static final /* enum */ ResourceType Permission;
    public static final /* enum */ ResourceType Collection;
    public static final /* enum */ ResourceType StoredProcedure;
    public static final /* enum */ ResourceType Trigger;
    public static final /* enum */ ResourceType Udf;
    public static final /* enum */ ResourceType Document;
    public static final /* enum */ ResourceType Attachment;
    public static final /* enum */ ResourceType Offer;
    private static final /* synthetic */ ResourceType[] $VALUES;
    @NotNull
    private final String listName;
    @NotNull
    private final String path;
    @NotNull
    private final Type type;
    @NotNull
    private final Type listType;
    @NotNull
    private static final List<ResourceType> ancestors;
    public static final Companion Companion;

    static {
        ResourceType[] resourceTypeArray = new ResourceType[10];
        ResourceType[] resourceTypeArray2 = resourceTypeArray;
        Type type = new TypeToken<Database>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type, (String)"object : TypeToken<Db>() {}.type");
        Type type2 = new TypeToken<ResourceList<Database>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<ResourceList<Db>>() {}.type");
        resourceTypeArray[0] = Database = new ResourceType("dbs", "Datebase", type, type2);
        Type type3 = new TypeToken<User>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"object : TypeToken<Usr>() {}.type");
        Type type4 = new TypeToken<ResourceList<User>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"object : TypeToken<ResourceList<Usr>>() {}.type");
        resourceTypeArray[1] = User = new ResourceType("users", "User", type3, type4);
        Type type5 = new TypeToken<Permission>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<Perm>() {}.type");
        Type type6 = new TypeToken<ResourceList<Permission>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"object : TypeToken<ResourceList<Perm>>() {}.type");
        resourceTypeArray[2] = Permission = new ResourceType("permissions", "Permission", type5, type6);
        Type type7 = new TypeToken<DocumentCollection>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type7, (String)"object : TypeToken<Coll>() {}.type");
        Type type8 = new TypeToken<ResourceList<DocumentCollection>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type8, (String)"object : TypeToken<ResourceList<Coll>>() {}.type");
        resourceTypeArray[3] = Collection = new ResourceType("colls", "DocumentCollection", type7, type8);
        Type type9 = new TypeToken<StoredProcedure>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type9, (String)"object : TypeToken<Sproc>() {}.type");
        Type type10 = new TypeToken<ResourceList<StoredProcedure>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type10, (String)"object : TypeToken<ResourceList<Sproc>>() {}.type");
        resourceTypeArray[4] = StoredProcedure = new ResourceType("sprocs", "StoredProcedure", type9, type10);
        Type type11 = new TypeToken<Trigger>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type11, (String)"object : TypeToken<Trggr>() {}.type");
        Type type12 = new TypeToken<ResourceList<Trigger>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type12, (String)"object : TypeToken<ResourceList<Trggr>>() {}.type");
        resourceTypeArray[5] = Trigger = new ResourceType("triggers", "Trigger", type11, type12);
        Type type13 = new TypeToken<UserDefinedFunction>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type13, (String)"object : TypeToken<UDF>() {}.type");
        Type type14 = new TypeToken<ResourceList<UserDefinedFunction>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type14, (String)"object : TypeToken<ResourceList<UDF>>() {}.type");
        resourceTypeArray[6] = Udf = new ResourceType("udfs", "UserDefinedFunction", type13, type14);
        Type type15 = new TypeToken<Document>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type15, (String)"object : TypeToken<Doc>() {}.type");
        Type type16 = new TypeToken<ResourceList<Document>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type16, (String)"object : TypeToken<ResourceList<Doc>>() {}.type");
        resourceTypeArray[7] = Document = new ResourceType("docs", "Document", type15, type16);
        Type type17 = new TypeToken<Attachment>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type17, (String)"object : TypeToken<Atch>() {}.type");
        Type type18 = new TypeToken<ResourceList<Attachment>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type18, (String)"object : TypeToken<ResourceList<Atch>>() {}.type");
        resourceTypeArray[8] = Attachment = new ResourceType("attachments", "Attachment", type17, type18);
        Type type19 = new TypeToken<Offer>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type19, (String)"object : TypeToken<Ofr>() {}.type");
        Type type20 = new TypeToken<ResourceList<Offer>>(){}.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)type20, (String)"object : TypeToken<ResourceList<Ofr>>() {}.type");
        resourceTypeArray[9] = Offer = new ResourceType("offers", "Offer", type19, type20);
        $VALUES = resourceTypeArray;
        Companion = new Companion(null);
        ancestors = CollectionsKt.listOf((Object[])new ResourceType[]{Database, User, Collection, Document});
    }

    @NotNull
    public final String getListName() {
        return this.listName;
    }

    public final boolean isDecendentOf(@NotNull ResourceType resourceType) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)((Object)resourceType), (String)"resourceType");
        switch (ResourceType$WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: 
            case 2: {
                bl = false;
                break;
            }
            case 3: 
            case 4: {
                if (resourceType == Database) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (resourceType == Collection || resourceType == Database) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 9: {
                if (resourceType == User || resourceType == Database) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 10: {
                if (resourceType == Document || resourceType == Collection || resourceType == Database) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean isAncestorOf(@NotNull ResourceType resourceType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)resourceType), (String)"resourceType");
        return resourceType.isDecendentOf(this);
    }

    public final boolean getSupportsPermissionToken() {
        boolean bl;
        switch (ResourceType$WhenMappings.$EnumSwitchMapping$1[this.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final List<ResourceType> getChildren() {
        List list;
        switch (ResourceType$WhenMappings.$EnumSwitchMapping$2[this.ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object[])new ResourceType[]{Collection, User});
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)((Object)Permission));
                break;
            }
            case 3: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 4: {
                list = CollectionsKt.listOf((Object[])new ResourceType[]{Document, StoredProcedure, Trigger, Udf});
                break;
            }
            case 5: {
                list = CollectionsKt.listOf((Object)((Object)Attachment));
                break;
            }
            case 6: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 7: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 8: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 9: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @NotNull
    public final Type getListType() {
        return this.listType;
    }

    private ResourceType(String path, String fullname, Type type, Type listType) {
        this.path = path;
        this.type = type;
        this.listType = listType;
        this.listName = fullname + 's';
    }

    public static ResourceType[] values() {
        return (ResourceType[])$VALUES.clone();
    }

    public static ResourceType valueOf(String string) {
        return Enum.valueOf(ResourceType.class, string);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u0005\"\b\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/azure/data/model/ResourceType$Companion;", "", "()V", "ancestors", "", "Lcom/azure/data/model/ResourceType;", "getAncestors", "()Ljava/util/List;", "fromListName", "name", "", "fromType", "T", "Lcom/azure/data/model/Resource;", "clazz", "Ljava/lang/Class;", "azuredata_release"})
    public static final class Companion {
        @NotNull
        public final <T extends Resource> ResourceType fromType(@NotNull Class<T> clazz) {
            ResourceType resourceType;
            block3: {
                ResourceType[] resourceTypeArray;
                ResourceType[] resourceTypeArray2;
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                if (Document.class.isAssignableFrom(clazz)) {
                    return Document;
                }
                ResourceType[] resourceTypeArray3 = resourceTypeArray2 = (resourceTypeArray = ResourceType.values());
                int n = resourceTypeArray3.length;
                for (int i = 0; i < n; ++i) {
                    ResourceType resourceType2;
                    ResourceType it = resourceType2 = resourceTypeArray3[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), clazz)) continue;
                    resourceType = resourceType2;
                    break block3;
                }
                resourceType = null;
            }
            if (resourceType == null) {
                throw (Throwable)new Exception("Unable to determine resource type requested");
            }
            return resourceType;
        }

        @NotNull
        public final ResourceType fromListName(@NotNull String name) {
            ResourceType resourceType;
            block2: {
                ResourceType[] resourceTypeArray;
                ResourceType[] resourceTypeArray2;
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                ResourceType[] resourceTypeArray3 = resourceTypeArray2 = (resourceTypeArray = ResourceType.values());
                int n = resourceTypeArray3.length;
                for (int i = 0; i < n; ++i) {
                    ResourceType resourceType2;
                    ResourceType it = resourceType2 = resourceTypeArray3[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getListName(), (Object)name)) continue;
                    resourceType = resourceType2;
                    break block2;
                }
                resourceType = null;
            }
            if (resourceType == null) {
                throw (Throwable)new Exception("Unable to determine resource type requested");
            }
            return resourceType;
        }

        @NotNull
        public final List<ResourceType> getAncestors() {
            return ancestors;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

