/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.util.json;

import com.azure.data.model.Resource;
import com.azure.data.model.ResourceLocation;
import com.azure.data.service.ResourceWriteOperation;
import com.azure.data.service.ResourceWriteOperationType;
import com.azure.data.util.json.GsonConfigKt;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u000eH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J&\u0010\u0013\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00022\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/azure/data/util/json/ResourceWriteOperationAdapter;", "Lcom/google/gson/JsonSerializer;", "Lcom/azure/data/service/ResourceWriteOperation;", "Lcom/google/gson/JsonDeserializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "deserializeHeaders", "Lokhttp3/Headers;", "Lcom/google/gson/JsonObject;", "deserializeLocation", "Lcom/azure/data/model/ResourceLocation;", "deserializeResource", "Lcom/azure/data/model/Resource;", "serialize", "resource", "location", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "headers", "azuredata_release"})
public final class ResourceWriteOperationAdapter
implements JsonSerializer<ResourceWriteOperation>,
JsonDeserializer<ResourceWriteOperation> {
    @NotNull
    public JsonElement serialize(@Nullable ResourceWriteOperation src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
        ResourceWriteOperation resourceWriteOperation = src;
        if (resourceWriteOperation != null) {
            ResourceWriteOperation resourceWriteOperation2;
            ResourceWriteOperation it = resourceWriteOperation2 = resourceWriteOperation;
            JsonObject json = new JsonObject();
            json.addProperty("type", it.getType().toString());
            json.add("resource", this.serialize(it.getResource()));
            json.add("location", this.serialize(it.getResourceLocation()));
            json.addProperty("path", it.getResourceLocalContentPath());
            json.add("headers", this.serialize(it.getHttpHeaders()));
            return (JsonElement)json;
        }
        JsonNull jsonNull = JsonNull.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
        return (JsonElement)jsonNull;
    }

    @Nullable
    public ResourceWriteOperation deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
        JsonElement jsonElement = json;
        if (jsonElement != null && (jsonElement = jsonElement.getAsJsonObject()) != null) {
            Resource resource;
            JsonElement jsonElement2;
            JsonElement it = jsonElement2 = jsonElement;
            JsonPrimitive jsonPrimitive = it.getAsJsonPrimitive("type");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"it.getAsJsonPrimitive(\"type\")");
            String type = jsonPrimitive.getAsString();
            JsonElement jsonElement3 = it.get("resource");
            if (jsonElement3 != null) {
                JsonElement jsonElement4;
                JsonElement it2 = jsonElement4 = jsonElement3;
                resource = this.deserializeResource(it2);
            } else {
                resource = null;
            }
            Resource resource2 = resource;
            JsonObject jsonObject = it.getAsJsonObject("location");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"it.getAsJsonObject(\"location\")");
            ResourceLocation location = this.deserializeLocation(jsonObject);
            JsonPrimitive jsonPrimitive2 = it.getAsJsonPrimitive("path");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive2, (String)"it.getAsJsonPrimitive(\"path\")");
            String path = jsonPrimitive2.getAsString();
            JsonObject jsonObject2 = it.getAsJsonObject("headers");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject2, (String)"it.getAsJsonObject(\"headers\")");
            Headers headers2 = this.deserializeHeaders(jsonObject2);
            String string = type;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type");
            ResourceWriteOperationType resourceWriteOperationType = ResourceWriteOperationType.valueOf(string);
            String string2 = path;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
            return new ResourceWriteOperation(resourceWriteOperationType, resource2, location, string2, headers2);
        }
        return null;
    }

    private final JsonElement serialize(Resource resource) {
        Resource resource2 = resource;
        if (resource2 != null) {
            Resource resource3;
            Resource it = resource3 = resource2;
            JsonObject json = new JsonObject();
            json.addProperty("_class", it.getClass().getName());
            json.addProperty("resource", GsonConfigKt.getGson().toJson(it.getClass().cast(it)));
            return (JsonElement)json;
        }
        JsonNull jsonNull = JsonNull.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonNull, (String)"JsonNull.INSTANCE");
        return (JsonElement)jsonNull;
    }

    private final Resource deserializeResource(JsonElement json) {
        JsonElement jsonElement = json;
        if (!(jsonElement instanceof JsonNull)) {
            if (jsonElement instanceof JsonObject) {
                JsonPrimitive jsonPrimitive = ((JsonObject)json).getAsJsonPrimitive("_class");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"json.getAsJsonPrimitive(\"_class\")");
                Class<?> resourceClass = Class.forName(jsonPrimitive.getAsString());
                Gson gson = GsonConfigKt.getGson();
                JsonPrimitive jsonPrimitive2 = ((JsonObject)json).getAsJsonPrimitive("resource");
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive2, (String)"json.getAsJsonPrimitive(\"resource\")");
                Object object = gson.fromJson(jsonPrimitive2.getAsString(), resourceClass);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.azure.data.model.Resource");
                }
                return (Resource)object;
            }
            return null;
        }
        return null;
    }

    private final JsonElement serialize(ResourceLocation location) {
        JsonObject json = new JsonObject();
        json.addProperty("_class", location.getClass().getName());
        json.addProperty("location", GsonConfigKt.getGson().toJson(location.getClass().cast(location)));
        return (JsonElement)json;
    }

    private final ResourceLocation deserializeLocation(JsonObject json) {
        JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive("_class");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"json.getAsJsonPrimitive(\"_class\")");
        Class<?> locationClass = Class.forName(jsonPrimitive.getAsString());
        Gson gson = GsonConfigKt.getGson();
        JsonPrimitive jsonPrimitive2 = json.getAsJsonPrimitive("location");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive2, (String)"json.getAsJsonPrimitive(\"location\")");
        Object object = gson.fromJson(jsonPrimitive2.getAsString(), locationClass);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.azure.data.model.ResourceLocation");
        }
        return (ResourceLocation)object;
    }

    private final JsonElement serialize(Headers headers2) {
        JsonObject json = new JsonObject();
        Set set = headers2.names();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"headers.names()");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            String header = (String)element$iv;
            json.addProperty(header, headers2.get(header));
        }
        return (JsonElement)json;
    }

    private final Headers deserializeHeaders(JsonObject json) {
        Map headers2 = new LinkedHashMap();
        Set set = json.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"json.keySet()");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            String string;
            String string2;
            String it = (String)element$iv;
            Map map = headers2;
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive(it);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive, (String)"json.getAsJsonPrimitive(it)");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive.getAsString(), (String)"json.getAsJsonPrimitive(it).asString");
            map.put(string2, string);
        }
        Headers headers3 = Headers.of((Map)headers2);
        Intrinsics.checkExpressionValueIsNotNull((Object)headers3, (String)"Headers.of(headers)");
        return headers3;
    }
}

