/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.util.json;

import com.azure.core.log.LoggerKt;
import com.azure.core.util.DateTypeAdapter;
import com.azure.data.model.DictionaryDocument;
import com.azure.data.model.Timestamp;
import com.azure.data.service.ResourceWriteOperation;
import com.azure.data.util.json.DocumentAdapter;
import com.azure.data.util.json.ResourceWriteOperationAdapter;
import com.azure.data.util.json.TimestampAdapter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\b\u001a\u00020\u0005*\u00020\u0005\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gsonBuilder", "Lcom/google/gson/GsonBuilder;", "getGsonBuilder", "()Lcom/google/gson/GsonBuilder;", "checkVerboseMode", "azuredata_release"})
public final class GsonConfigKt {
    @NotNull
    private static final GsonBuilder gsonBuilder;
    @NotNull
    private static final Gson gson;

    @NotNull
    public static final GsonBuilder getGsonBuilder() {
        return gsonBuilder;
    }

    @NotNull
    public static final Gson getGson() {
        return gson;
    }

    @NotNull
    public static final GsonBuilder checkVerboseMode(@NotNull GsonBuilder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (LoggerKt.getLogLevel() <= 3) {
            $receiver.setPrettyPrinting();
        }
        return $receiver;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder().disableHtmlEscaping();
        Intrinsics.checkExpressionValueIsNotNull((Object)gsonBuilder, (String)"GsonBuilder()\n        .disableHtmlEscaping()");
        GsonBuilder gsonBuilder2 = GsonConfigKt.checkVerboseMode(gsonBuilder).registerTypeAdapter((Type)((Object)Date.class), (Object)new DateTypeAdapter()).registerTypeAdapter((Type)((Object)Timestamp.class), (Object)new TimestampAdapter()).registerTypeAdapter((Type)((Object)DictionaryDocument.class), (Object)new DocumentAdapter()).registerTypeAdapter((Type)((Object)ResourceWriteOperation.class), (Object)new ResourceWriteOperationAdapter());
        if (gsonBuilder2 == null) {
            Intrinsics.throwNpe();
        }
        GsonConfigKt.gsonBuilder = gsonBuilder2;
        Gson gson = GsonConfigKt.gsonBuilder.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)gson, (String)"gsonBuilder.create()");
        GsonConfigKt.gson = gson;
    }
}

