/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.util.json;

import com.azure.core.util.RoundtripDateConverter;
import com.azure.data.model.DictionaryDocument;
import com.azure.data.model.Resource;
import com.azure.data.model.Timestamp;
import com.azure.data.util.json.DocumentAdapter$WhenMappings;
import com.azure.data.util.json.GsonConfigKt;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J$\u0010\u0007\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t0\bj\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\t0\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/azure/data/util/json/DocumentAdapter;", "Lcom/google/gson/TypeAdapter;", "Lcom/azure/data/model/DictionaryDocument;", "()V", "read", "reader", "Lcom/google/gson/stream/JsonReader;", "readArray", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "readObject", "", "", "readValue", "jToken", "Lcom/google/gson/stream/JsonToken;", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "azuredata_release"})
public final class DocumentAdapter
extends TypeAdapter<DictionaryDocument> {
    @Nullable
    public DictionaryDocument read(@NotNull JsonReader reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        DictionaryDocument doc = null;
        reader.beginObject();
        block16: while (reader.hasNext()) {
            String name;
            JsonToken jToken;
            Intrinsics.checkExpressionValueIsNotNull((Object)reader.nextName(), (String)"reader.nextName()");
            Intrinsics.checkExpressionValueIsNotNull((Object)reader.peek(), (String)"reader.peek()");
            if (jToken == JsonToken.NULL) {
                reader.nextNull();
                continue;
            }
            switch (name) {
                case "id": {
                    doc = new DictionaryDocument(reader.nextString());
                    continue block16;
                }
                case "_rid": {
                    DictionaryDocument dictionaryDocument = doc;
                    if (dictionaryDocument == null) continue block16;
                    dictionaryDocument.setResourceId(reader.nextString());
                    continue block16;
                }
                case "_etag": {
                    DictionaryDocument dictionaryDocument = doc;
                    if (dictionaryDocument == null) continue block16;
                    dictionaryDocument.setEtag(reader.nextString());
                    continue block16;
                }
                case "_self": {
                    DictionaryDocument dictionaryDocument = doc;
                    if (dictionaryDocument == null) continue block16;
                    dictionaryDocument.setSelfLink(reader.nextString());
                    continue block16;
                }
                case "_ts": {
                    DictionaryDocument dictionaryDocument = doc;
                    if (dictionaryDocument == null) continue block16;
                    dictionaryDocument.setTimestamp(new Timestamp(reader.nextLong() * (long)1000));
                    continue block16;
                }
                case "_attachments": {
                    DictionaryDocument dictionaryDocument = doc;
                    if (dictionaryDocument == null) continue block16;
                    dictionaryDocument.setAttachmentsLink(reader.nextString());
                    continue block16;
                }
            }
            Object value = this.readValue(reader, jToken);
            Object object = doc;
            if (object == null || (object = ((DictionaryDocument)object).getData$azuredata_release()) == null) continue;
            Map map = (Map)object;
            map.put(name, value);
        }
        reader.endObject();
        return doc;
    }

    private final Object readValue(JsonReader reader, JsonToken jToken) {
        Object object;
        switch (DocumentAdapter$WhenMappings.$EnumSwitchMapping$0[jToken.ordinal()]) {
            case 1: {
                object = this.readArray(reader);
                break;
            }
            case 2: {
                object = this.readObject(reader);
                break;
            }
            case 3: {
                String string = reader.nextString();
                if (string.length() == 33) {
                    try {
                        return RoundtripDateConverter.Companion.toDate(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return string;
            }
            case 4: {
                object = reader.nextBoolean();
                break;
            }
            case 5: {
                String string = reader.nextString();
                object = NumberFormat.getInstance().parse(string);
                break;
            }
            case 6: {
                reader.nextNull();
                object = null;
                break;
            }
            case 7: {
                throw (Throwable)new Exception("Malformed JSON?  Not expecting another name at this position");
            }
            case 8: {
                throw (Throwable)new Exception("Unexpected END_DOCUMENT JSON...");
            }
            default: {
                throw (Throwable)new Exception("Unexpected null token or other error");
            }
        }
        return object;
    }

    private final ArrayList<Object> readArray(JsonReader reader) {
        ArrayList<Object> array = new ArrayList<Object>();
        reader.beginArray();
        while (reader.hasNext()) {
            JsonToken jToken;
            JsonToken jsonToken = jToken = reader.peek();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonToken, (String)"jToken");
            array.add(this.readValue(reader, jsonToken));
        }
        reader.endArray();
        return array;
    }

    private final Map<String, Object> readObject(JsonReader reader) {
        Map map = new LinkedHashMap();
        reader.beginObject();
        while (reader.hasNext()) {
            String string;
            String name = reader.nextName();
            String value = reader.nextString();
            Map map2 = map;
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"name");
            String string2 = value;
            map2.put(string, string2);
        }
        reader.endObject();
        return map;
    }

    public void write(@NotNull JsonWriter out, @Nullable DictionaryDocument value) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.beginObject();
        DictionaryDocument dictionaryDocument = value;
        if (dictionaryDocument != null) {
            DictionaryDocument dictionaryDocument2;
            DictionaryDocument it = dictionaryDocument2 = dictionaryDocument;
            for (String string : Resource.Companion.Keys.INSTANCE.getList()) {
                out.name(string);
                switch (string) {
                    case "id": {
                        out.value(it.getId());
                        break;
                    }
                    case "_rid": {
                        out.value(it.getResourceId());
                        break;
                    }
                    case "_etag": {
                        out.value(it.getEtag());
                        break;
                    }
                    case "_self": {
                        out.value(it.getSelfLink());
                        break;
                    }
                    case "_ts": {
                        out.jsonValue(GsonConfigKt.getGson().toJson((Object)it.getTimestamp()));
                    }
                }
            }
            out.name("_attachments").value(it.getAttachmentsLink());
            Object object = it.getData$azuredata_release();
            for (Map.Entry entry : object.entrySet()) {
                out.name((String)entry.getKey());
                object = entry.getValue();
                if (object instanceof String) {
                    Object v = entry.getValue();
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                    }
                    out.value((String)v);
                    continue;
                }
                if (object instanceof Double || object instanceof Float) {
                    Object v = entry.getValue();
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                    }
                    out.value(((Double)v).doubleValue());
                    continue;
                }
                if (object instanceof Long) {
                    Object v = entry.getValue();
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Long");
                    }
                    out.value(((Long)v).longValue());
                    continue;
                }
                if (object instanceof Number) {
                    Object v = entry.getValue();
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
                    }
                    out.value((Number)v);
                    continue;
                }
                if (object instanceof Boolean) {
                    Object v = entry.getValue();
                    if (v == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    out.value(((Boolean)v).booleanValue());
                    continue;
                }
                String jsonValue = GsonConfigKt.getGson().toJson(entry.getValue());
                out.jsonValue(jsonValue);
            }
        }
        out.endObject();
    }
}

