/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.service;

import com.azure.core.crypto.CryptoProvider;
import com.azure.core.http.HttpMethod;
import com.azure.core.log.LoggerKt;
import com.azure.core.util.DateUtil;
import com.azure.data.model.PermissionMode;
import com.azure.data.model.ResourceLocation;
import com.azure.data.model.ResourceToken;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/azure/data/service/ResourceTokenProvider;", "", "masterKey", "", "permissionMode", "Lcom/azure/data/model/PermissionMode;", "(Ljava/lang/String;Lcom/azure/data/model/PermissionMode;)V", "dateFormatter", "Ljava/text/SimpleDateFormat;", "tokenVersion", "getToken", "Lcom/azure/data/model/ResourceToken;", "resourceLocation", "Lcom/azure/data/model/ResourceLocation;", "method", "Lcom/azure/core/http/HttpMethod;", "azuredata_release"})
public final class ResourceTokenProvider {
    private final String tokenVersion = "1.0";
    private final SimpleDateFormat dateFormatter;
    private final String masterKey;
    private final PermissionMode permissionMode;

    @Nullable
    public final ResourceToken getToken(@NotNull ResourceLocation resourceLocation, @NotNull HttpMethod method) {
        String authStringEncoded;
        Intrinsics.checkParameterIsNotNull((Object)resourceLocation, (String)"resourceLocation");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        if (!method.isRead() && this.permissionMode != PermissionMode.All) {
            return null;
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s %s";
        Object object = new Object[]{this.dateFormatter.format(new Date()), "GMT"};
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        String dateString = string2;
        string = StringCompanionObject.INSTANCE;
        object = "%s\n%s\n%s\n%s\n\n";
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = method.name();
        Locale locale = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
        Object object2 = locale;
        int n = 0;
        Object[] objectArray3 = objectArray;
        Object[] objectArray4 = objectArray;
        if (objectArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = objectArray2.toLowerCase((Locale)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string4 = string3;
        objectArray3[n] = string4;
        objectArray2 = resourceLocation.type();
        Locale locale2 = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.ROOT");
        object2 = locale2;
        n = 1;
        objectArray3 = objectArray4;
        if (objectArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = objectArray2.toLowerCase((Locale)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
        string4 = string5;
        objectArray3[n] = string4;
        objectArray4[2] = resourceLocation.link();
        objectArray2 = dateString;
        Locale locale3 = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.ROOT");
        object2 = locale3;
        n = 3;
        objectArray4 = objectArray3 = objectArray4;
        if (objectArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = objectArray2.toLowerCase((Locale)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
        string4 = string6;
        objectArray3[n] = string4;
        objectArray2 = objectArray4;
        String string7 = String.format((String)object, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"java.lang.String.format(format, *args)");
        String it = string = string7;
        int level$iv$iv = 3;
        if (level$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
            Timber.d((String)it, (Object[])new Object[0]);
        }
        String payload = string;
        String signature = CryptoProvider.Companion.hmacEncrypt$default((CryptoProvider.Companion)CryptoProvider.Companion, (String)payload, (String)this.masterKey, null, (int)4, null);
        StringCompanionObject stringCompanionObject2 = StringCompanionObject.INSTANCE;
        object2 = "type=master&ver=%s&sig=%s";
        Object[] objectArray5 = new Object[]{this.tokenVersion, signature};
        String string8 = String.format((String)object2, Arrays.copyOf(objectArray5, objectArray5.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"java.lang.String.format(format, *args)");
        String string9 = authStringEncoded = URLEncoder.encode(string8, "UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"authStringEncoded");
        return new ResourceToken(string9, dateString);
    }

    public ResourceTokenProvider(@NotNull String masterKey, @NotNull PermissionMode permissionMode) {
        Intrinsics.checkParameterIsNotNull((Object)masterKey, (String)"masterKey");
        Intrinsics.checkParameterIsNotNull((Object)((Object)permissionMode), (String)"permissionMode");
        this.masterKey = masterKey;
        this.permissionMode = permissionMode;
        this.tokenVersion = "1.0";
        this.dateFormatter = DateUtil.Companion.getDateFromatter(DateUtil.Format.Rfc1123Format);
    }
}

