/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.crypto;

import com.azure.core.crypto.HmacAlgorithm;
import com.azure.core.log.LoggerKt;
import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/azure/core/crypto/CryptoProvider;", "", "()V", "Companion", "azurecore_release"})
public final class CryptoProvider {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/azure/core/crypto/CryptoProvider$Companion;", "", "()V", "hmacEncrypt", "", "data", "key", "algorithm", "Lcom/azure/core/crypto/HmacAlgorithm;", "azurecore_release"})
    public static final class Companion {
        @Nullable
        public final String hmacEncrypt(@NotNull String data, @NotNull String key, @NotNull HmacAlgorithm algorithm) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)((Object)algorithm), (String)"algorithm");
            try {
                Object object;
                String string = key;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] decodedKey = Base64.decodeBase64((byte[])byArray);
                Mac hmac = Mac.getInstance(algorithm.getValue());
                SecretKeySpec keySpec = new SecretKeySpec(decodedKey, algorithm.getValue());
                hmac.init(keySpec);
                String string2 = data;
                Object object2 = "UTF-8";
                Mac mac = hmac;
                boolean bl2 = false;
                Charset charset2 = Charset.forName((String)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"Charset.forName(charsetName)");
                object2 = object = charset2;
                bl2 = false;
                byte[] byArray2 = string2.getBytes((Charset)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
                object = byArray2;
                byte[] hashPayLoad = mac.doFinal((byte[])object);
                String string3 = android.util.Base64.encodeToString((byte[])hashPayLoad, (int)0);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Base64.encodeToString(hashPayLoad, Base64.DEFAULT)");
                return StringsKt.replace$default((String)string3, (String)"\n", (String)"", (boolean)false, (int)4, null);
            }
            catch (Exception ex) {
                boolean $i$f$e = false;
                int level$iv$iv = 6;
                boolean $i$f$log = false;
                if (level$iv$iv >= LoggerKt.getLogLevel() && Timber.treeCount() > 0) {
                    boolean bl = false;
                    Timber.e((Throwable)ex);
                }
                return null;
            }
        }

        public static /* synthetic */ String hmacEncrypt$default(Companion companion, String string, String string2, HmacAlgorithm hmacAlgorithm, int n, Object object) {
            if ((n & 4) != 0) {
                hmacAlgorithm = HmacAlgorithm.SHA256;
            }
            return companion.hmacEncrypt(string, string2, hmacAlgorithm);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

