/*
 * Decompiled with CFR 0.152.
 */
import android.app.UiModeManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import com.azure.core.http.HttpHeader;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u00a8\u0006\u0007"}, d2={"getCurrentLocale", "Ljava/util/Locale;", "Landroid/content/Context;", "getDefaultHeaders", "Lokhttp3/Headers;", "getUserAgentString", "", "azurecore_release"})
public final class ContextExtensionsKt {
    @NotNull
    public static final Locale getCurrentLocale(@NotNull Context $this$getCurrentLocale) {
        Locale locale;
        Intrinsics.checkParameterIsNotNull((Object)$this$getCurrentLocale, (String)"$this$getCurrentLocale");
        if (Build.VERSION.SDK_INT >= 24) {
            Resources resources = $this$getCurrentLocale.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"this.resources");
            Configuration configuration = resources.getConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"this.resources.configuration");
            Locale locale2 = configuration.getLocales().get(0);
            locale = locale2;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"this.resources.configuration.locales[0]");
        } else {
            Resources resources = $this$getCurrentLocale.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"this.resources");
            Locale locale3 = resources.getConfiguration().locale;
            locale = locale3;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"this.resources.configuration.locale");
        }
        return locale;
    }

    @NotNull
    public static final Headers getDefaultHeaders(@NotNull Context $this$getDefaultHeaders) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getDefaultHeaders, (String)"$this$getDefaultHeaders");
        Headers.Builder builder = new Headers.Builder();
        builder.add(HttpHeader.AcceptEncoding.getValue(), "gzip;q=1.0, compress;q=0.5");
        Locale currentLocale = ContextExtensionsKt.getCurrentLocale($this$getDefaultHeaders);
        builder.add(HttpHeader.AcceptLanguage.getValue(), currentLocale.getLanguage());
        builder.add(HttpHeader.UserAgent.getValue(), ContextExtensionsKt.getUserAgentString($this$getDefaultHeaders));
        Headers headers = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)headers, (String)"builder.build()");
        return headers;
    }

    @NotNull
    public static final String getUserAgentString(@NotNull Context $this$getUserAgentString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getUserAgentString, (String)"$this$getUserAgentString");
        try {
            Object object;
            Object appName;
            PackageManager pkgManager = $this$getUserAgentString.getPackageManager();
            String pkgName = $this$getUserAgentString.getPackageName();
            PackageInfo pInfo = pkgManager.getPackageInfo(pkgName, 0);
            Object object2 = pInfo;
            if (object2 == null || (object2 = object2.applicationInfo) == null || (object2 = object2.loadLabel(pkgManager)) == null) {
                object2 = appName = (CharSequence)"Unknown";
            }
            if ((object = pInfo) == null || (object = object.versionName) == null) {
                object = "Unknown";
            }
            Object appVersion = object;
            PackageInfo packageInfo = pInfo;
            Object appVersionCode = packageInfo != null ? Integer.valueOf(packageInfo.versionCode) : "Unknown";
            String os = "Android";
            Object object3 = $this$getUserAgentString.getSystemService("uimode");
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.app.UiModeManager");
            }
            UiModeManager uiModeManager = (UiModeManager)object3;
            if (uiModeManager.getCurrentModeType() == 4) {
                os = os + " TV";
            } else if (uiModeManager.getCurrentModeType() == 6) {
                os = os + " Wear";
            } else if (uiModeManager.getCurrentModeType() == 3) {
                os = os + " Auto";
            } else if (uiModeManager.getCurrentModeType() == 5) {
                os = os + " IOT";
            } else if (uiModeManager.getCurrentModeType() == 7) {
                os = os + " VR";
            }
            String osDetails = os + ' ' + Build.VERSION.RELEASE;
            String azureDataVersion = "AzureData/0.3.0";
            return (CharSequence)appName + '/' + (String)appVersion + " (" + pkgName + "; build:" + appVersionCode + "; " + osDetails + ") " + azureDataVersion;
        }
        catch (Exception e) {
            return "AzureMobile.Data";
        }
    }
}

