/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.core.util;

import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;

public final class UnixTime {
    private final OffsetDateTime dateTime;

    public UnixTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public UnixTime(long unixSeconds) {
        this.dateTime = OffsetDateTime.ofInstant((Instant)Instant.ofEpochSecond((long)unixSeconds), (ZoneId)ZoneOffset.UTC);
    }

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public String toString() {
        return String.valueOf(this.dateTime.toEpochSecond());
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnixTime)) {
            return false;
        }
        UnixTime rhs = (UnixTime)obj;
        return this.dateTime.equals((Object)rhs.getDateTime());
    }
}

