/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.core.util;

import java.util.NoSuchElementException;

public final class Option<T> {
    private static final Option<?> UNINITIALIZED = new Option();
    private static final Option<?> EMPTY = new Option<Object>(null);
    private final boolean isInitialized;
    private final T value;

    public static <T> Option<T> of(T value) {
        return value == null ? Option.empty() : new Option<T>(value);
    }

    public static <T> Option<T> empty() {
        Option<?> empty = EMPTY;
        return empty;
    }

    public static <T> Option<T> uninitialized() {
        Option<?> uninitialized = UNINITIALIZED;
        return uninitialized;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public T getValue() {
        if (!this.isInitialized) {
            throw new NoSuchElementException("No value initialized");
        }
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Option)) {
            return false;
        }
        Option other = (Option)obj;
        if (this.isInitialized ^ other.isInitialized) {
            return false;
        }
        return this.value == other.value || this.value != null && this.value.equals(other.value);
    }

    public int hashCode() {
        if (!this.isInitialized) {
            return -1;
        }
        return this.value != null ? this.value.hashCode() : 0;
    }

    private Option() {
        this.isInitialized = false;
        this.value = null;
    }

    private Option(T value) {
        this.isInitialized = true;
        this.value = value;
    }
}

