/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.core.util;

import java.util.Locale;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;

public final class DateTimeRfc1123 {
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZone(ZoneId.of((String)"UTC")).withLocale(Locale.US);
    private final OffsetDateTime dateTime;

    public DateTimeRfc1123(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public DateTimeRfc1123(String formattedString) {
        this.dateTime = OffsetDateTime.parse((CharSequence)formattedString, (DateTimeFormatter)DateTimeFormatter.RFC_1123_DATE_TIME);
    }

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public String toString() {
        return RFC1123_DATE_TIME_FORMATTER.format((TemporalAccessor)this.dateTime);
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeRfc1123)) {
            return false;
        }
        DateTimeRfc1123 rhs = (DateTimeRfc1123)obj;
        return this.dateTime.equals((Object)rhs.getDateTime());
    }
}

