/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.core.util;

import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.util.Option;

public class Context {
    private final ClientLogger logger = new ClientLogger(Context.class);
    public static final Context NONE = new Context(null, null, null);
    private final Context parent;
    private final Object key;
    private final Object value;

    public Context(Object key, Object value) {
        this.parent = null;
        if (key == null) {
            throw new NullPointerException("'key' cannot be null.");
        }
        this.key = key;
        this.value = value;
    }

    private Context(Context parent, Object key, Object value) {
        this.parent = parent;
        this.key = key;
        this.value = value;
    }

    public Context addData(Object key, Object value) {
        if (key == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("key cannot be null"));
        }
        return new Context(this, key, value);
    }

    public Option<Object> getData(Object key) {
        if (key == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("key cannot be null"));
        }
        Context c = this;
        while (c != null) {
            if (key.equals(c.key)) {
                return Option.of(c.value);
            }
            c = c.parent;
        }
        return Option.uninitialized();
    }
}

