/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.core.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class CancellationToken {
    private volatile OnCancelNode onCancelNodes;
    private static final AtomicReferenceFieldUpdater<CancellationToken, OnCancelNode> ON_CANCEL_NODES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CancellationToken.class, OnCancelNode.class, "onCancelNodes");
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    public static final CancellationToken NONE = new CancellationToken();

    public void cancel() {
        if (this == NONE) {
            return;
        }
        if (this.isCancelled.compareAndSet(false, true)) {
            this.invokeCallbacks();
        }
    }

    public boolean isCancellationRequested() {
        return this.isCancelled.get();
    }

    public void registerOnCancel(Runnable onCancel) {
        if (this == NONE) {
            return;
        }
        OnCancelNode node = new OnCancelNode(onCancel);
        boolean added = this.tryAddOnCancelNode(node);
        if (!added) {
            node.invokeOnCancel();
        }
    }

    public void registerOnCancel(String id, Runnable onCancel) {
        if (this == NONE) {
            return;
        }
        OnCancelNode node = new OnCancelNode(id, onCancel);
        boolean added = this.tryAddOnCancelNode(node);
        if (!added) {
            node.invokeOnCancel();
        }
    }

    public void unregisterOnCancel(String id) {
        boolean hadRace;
        if (this == NONE) {
            return;
        }
        OnCancelNode itr = this.onCancelNodes;
        while (itr != null) {
            if (this.onCancelNodes == OnCancelNode.FROZEN) {
                return;
            }
            if (itr.id != null && itr.id.equals(id)) {
                itr.markDeleted();
                break;
            }
            itr = itr.next;
        }
        if (itr == null) {
            return;
        }
        block1: do {
            hadRace = false;
            OnCancelNode predecessor = null;
            OnCancelNode current = this.onCancelNodes;
            if (current == OnCancelNode.FROZEN) {
                return;
            }
            while (current != null) {
                OnCancelNode successor = current.next;
                if (current.isDeleted()) {
                    if (predecessor == null) {
                        if (!ON_CANCEL_NODES_UPDATER.compareAndSet(this, current, successor)) {
                            hadRace = true;
                            continue block1;
                        }
                    } else {
                        predecessor.next = successor;
                        if (predecessor.isDeleted()) {
                            hadRace = true;
                            continue block1;
                        }
                    }
                } else {
                    predecessor = current;
                }
                current = successor;
            }
        } while (hadRace);
    }

    private boolean tryAddOnCancelNode(OnCancelNode newNode) {
        OnCancelNode headNode = this.onCancelNodes;
        if (headNode == OnCancelNode.FROZEN) {
            return false;
        }
        do {
            newNode.next = headNode;
            if (ON_CANCEL_NODES_UPDATER.compareAndSet(this, headNode, newNode)) {
                return true;
            }
            headNode = this.onCancelNodes;
        } while (headNode != OnCancelNode.FROZEN);
        return false;
    }

    private OnCancelNode freezeCallbackNodes() {
        OnCancelNode headNode;
        while (!ON_CANCEL_NODES_UPDATER.compareAndSet(this, headNode = this.onCancelNodes, OnCancelNode.FROZEN)) {
        }
        return headNode;
    }

    private OnCancelNode freezeAndGetCallbackNodes() {
        OnCancelNode current = this.freezeCallbackNodes();
        OnCancelNode reversed = null;
        while (current != null) {
            OnCancelNode tmp = current;
            current = current.next;
            tmp.next = reversed;
            reversed = tmp;
        }
        return reversed;
    }

    private void invokeCallbacks() {
        OnCancelNode next = this.freezeAndGetCallbackNodes();
        while (next != null) {
            next.invokeOnCancel();
            next = next.next;
        }
    }

    private static final class OnCancelNode {
        static final OnCancelNode FROZEN = new OnCancelNode(null);
        private final String id;
        private final Runnable onCancel;
        private volatile boolean isDeleted = false;
        volatile OnCancelNode next;

        OnCancelNode(Runnable onCancel) {
            this.id = null;
            this.onCancel = onCancel;
        }

        OnCancelNode(String id, Runnable onCancel) {
            if (id == null) {
                throw new NullPointerException("'id' is required and cannot be null.");
            }
            this.id = id;
            this.onCancel = onCancel;
        }

        void invokeOnCancel() {
            if (this.isDeleted) {
                return;
            }
            this.onCancel.run();
        }

        void markDeleted() {
            this.isDeleted = true;
        }

        boolean isDeleted() {
            return this.isDeleted;
        }
    }
}

