/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.core.util;

import com.azure.android.core.logging.ClientLogger;
import com.azure.android.core.util.Option;

public class RequestContext {
    private final ClientLogger logger = new ClientLogger(RequestContext.class);
    public static final RequestContext NONE = new RequestContext(null, null, null);
    private final RequestContext parent;
    private final Object key;
    private final Object value;

    public RequestContext(Object key, Object value) {
        this.parent = null;
        if (key == null) {
            throw new NullPointerException("'key' cannot be null.");
        }
        this.key = key;
        this.value = value;
    }

    private RequestContext(RequestContext parent, Object key, Object value) {
        this.parent = parent;
        this.key = key;
        this.value = value;
    }

    public RequestContext addData(Object key, Object value) {
        if (key == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("key cannot be null"));
        }
        return new RequestContext(this, key, value);
    }

    public Option<Object> getData(Object key) {
        if (key == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("key cannot be null"));
        }
        RequestContext c = this;
        while (c != null) {
            if (key.equals(c.key)) {
                return Option.of(c.value);
            }
            c = c.parent;
        }
        return Option.uninitialized();
    }
}

