/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.core.util;

import com.azure.android.core.logging.ClientLogger;
import java.util.Locale;
import org.threeten.bp.DateTimeException;
import org.threeten.bp.DayOfWeek;
import org.threeten.bp.Month;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;

public final class DateTimeRfc1123 {
    private static final ClientLogger LOGGER = new ClientLogger(DateTimeRfc1123.class);
    private static final DateTimeFormatter RFC1123_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withZone(ZoneId.of((String)"UTC")).withLocale(Locale.US);
    private final OffsetDateTime dateTime;

    public DateTimeRfc1123(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public DateTimeRfc1123(String formattedString) {
        this.dateTime = DateTimeRfc1123.parse(formattedString);
    }

    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    private static OffsetDateTime parse(String date) {
        try {
            return OffsetDateTime.of((int)DateTimeRfc1123.parseInt(date, 12, 16), (int)DateTimeRfc1123.parseMonth(date, 8), (int)DateTimeRfc1123.parseInt(date, 5, 7), (int)DateTimeRfc1123.parseInt(date, 17, 19), (int)DateTimeRfc1123.parseInt(date, 20, 22), (int)DateTimeRfc1123.parseInt(date, 23, 25), (int)0, (ZoneOffset)ZoneOffset.UTC);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | DateTimeException e) {
            return OffsetDateTime.parse((CharSequence)date, (DateTimeFormatter)DateTimeFormatter.RFC_1123_DATE_TIME);
        }
    }

    private static int parseInt(CharSequence date, int beginIndex, int endIndex) {
        int num = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = date.charAt(i);
            if (c < '0' || c > '9') {
                throw LOGGER.logExceptionAsError((RuntimeException)((Object)new DateTimeException("Invalid date time: " + date)));
            }
            num = num * 10 + (c - 48);
        }
        return num;
    }

    private static int parseMonth(CharSequence date, int beginIndex) {
        switch (date.charAt(beginIndex)) {
            case 'J': {
                switch (date.charAt(beginIndex + 1)) {
                    case 'a': {
                        return 1;
                    }
                    case 'u': {
                        switch (date.charAt(beginIndex + 2)) {
                            case 'n': {
                                return 6;
                            }
                            case 'l': {
                                return 7;
                            }
                        }
                        throw new IllegalArgumentException("Unknown month " + date);
                    }
                }
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown month " + date));
            }
            case 'F': {
                return 2;
            }
            case 'M': {
                switch (date.charAt(beginIndex + 2)) {
                    case 'r': {
                        return 3;
                    }
                    case 'y': {
                        return 5;
                    }
                }
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown month " + date));
            }
            case 'A': {
                switch (date.charAt(beginIndex + 2)) {
                    case 'r': {
                        return 4;
                    }
                    case 'g': {
                        return 8;
                    }
                }
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown month " + date));
            }
            case 'S': {
                return 9;
            }
            case 'O': {
                return 10;
            }
            case 'N': {
                return 11;
            }
            case 'D': {
                return 12;
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown month " + date));
    }

    public static String toRfc1123String(OffsetDateTime dateTime) {
        dateTime = dateTime.withOffsetSameInstant(ZoneOffset.UTC);
        StringBuilder sb = new StringBuilder(32);
        DayOfWeek dayOfWeek = dateTime.getDayOfWeek();
        switch (dayOfWeek) {
            case MONDAY: {
                sb.append("Mon, ");
                break;
            }
            case TUESDAY: {
                sb.append("Tue, ");
                break;
            }
            case WEDNESDAY: {
                sb.append("Wed, ");
                break;
            }
            case THURSDAY: {
                sb.append("Thu, ");
                break;
            }
            case FRIDAY: {
                sb.append("Fri, ");
                break;
            }
            case SATURDAY: {
                sb.append("Sat, ");
                break;
            }
            case SUNDAY: {
                sb.append("Sun, ");
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown day of week " + dayOfWeek));
            }
        }
        DateTimeRfc1123.zeroPad(dateTime.getDayOfMonth(), sb);
        Month month = dateTime.getMonth();
        switch (month) {
            case JANUARY: {
                sb.append(" Jan ");
                break;
            }
            case FEBRUARY: {
                sb.append(" Feb ");
                break;
            }
            case MARCH: {
                sb.append(" Mar ");
                break;
            }
            case APRIL: {
                sb.append(" Apr ");
                break;
            }
            case MAY: {
                sb.append(" May ");
                break;
            }
            case JUNE: {
                sb.append(" Jun ");
                break;
            }
            case JULY: {
                sb.append(" Jul ");
                break;
            }
            case AUGUST: {
                sb.append(" Aug ");
                break;
            }
            case SEPTEMBER: {
                sb.append(" Sep ");
                break;
            }
            case OCTOBER: {
                sb.append(" Oct ");
                break;
            }
            case NOVEMBER: {
                sb.append(" Nov ");
                break;
            }
            case DECEMBER: {
                sb.append(" Dec ");
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown month " + month));
            }
        }
        sb.append(dateTime.getYear());
        sb.append(" ");
        DateTimeRfc1123.zeroPad(dateTime.getHour(), sb);
        sb.append(":");
        DateTimeRfc1123.zeroPad(dateTime.getMinute(), sb);
        sb.append(":");
        DateTimeRfc1123.zeroPad(dateTime.getSecond(), sb);
        sb.append(" GMT");
        return sb.toString();
    }

    private static void zeroPad(int value, StringBuilder sb) {
        if (value < 10) {
            sb.append("0");
        }
        sb.append(value);
    }

    public String toString() {
        return RFC1123_DATE_TIME_FORMATTER.format((TemporalAccessor)this.dateTime);
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeRfc1123)) {
            return false;
        }
        DateTimeRfc1123 rhs = (DateTimeRfc1123)obj;
        return this.dateTime.equals((Object)rhs.getDateTime());
    }
}

