/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.core.logging.implementation;

import android.util.Log;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public final class DefaultLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;

    public DefaultLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public DefaultLogger(String name) {
        this.name = name;
    }

    public boolean isTraceEnabled() {
        return Log.isLoggable((String)this.name, (int)2);
    }

    public void trace(String msg) {
        Log.v((String)this.name, (String)msg);
    }

    public void trace(String format, Object param1) {
        Log.v((String)this.name, (String)this.format(format, param1, null));
    }

    public void trace(String format, Object param1, Object param2) {
        Log.v((String)this.name, (String)this.format(format, param1, param2));
    }

    public void trace(String format, Object[] argArray) {
        Log.v((String)this.name, (String)this.format(format, argArray));
    }

    public void trace(String msg, Throwable t) {
        Log.v((String)this.name, (String)msg, (Throwable)t);
    }

    public boolean isDebugEnabled() {
        return Log.isLoggable((String)this.name, (int)3);
    }

    public void debug(String msg) {
        Log.d((String)this.name, (String)msg);
    }

    public void debug(String format, Object arg1) {
        Log.d((String)this.name, (String)this.format(format, arg1, null));
    }

    public void debug(String format, Object param1, Object param2) {
        Log.d((String)this.name, (String)this.format(format, param1, param2));
    }

    public void debug(String format, Object[] argArray) {
        Log.d((String)this.name, (String)this.format(format, argArray));
    }

    public void debug(String msg, Throwable t) {
        Log.d((String)this.name, (String)msg, (Throwable)t);
    }

    public boolean isInfoEnabled() {
        return Log.isLoggable((String)this.name, (int)4);
    }

    public void info(String msg) {
        Log.i((String)this.name, (String)msg);
    }

    public void info(String format, Object arg) {
        Log.i((String)this.name, (String)this.format(format, arg, null));
    }

    public void info(String format, Object arg1, Object arg2) {
        Log.i((String)this.name, (String)this.format(format, arg1, arg2));
    }

    public void info(String format, Object[] argArray) {
        Log.i((String)this.name, (String)this.format(format, argArray));
    }

    public void info(String msg, Throwable t) {
        Log.i((String)this.name, (String)msg, (Throwable)t);
    }

    public boolean isWarnEnabled() {
        return Log.isLoggable((String)this.name, (int)5);
    }

    public void warn(String msg) {
        Log.w((String)this.name, (String)msg);
    }

    public void warn(String format, Object arg) {
        Log.w((String)this.name, (String)this.format(format, arg, null));
    }

    public void warn(String format, Object arg1, Object arg2) {
        Log.w((String)this.name, (String)this.format(format, arg1, arg2));
    }

    public void warn(String format, Object[] argArray) {
        Log.w((String)this.name, (String)this.format(format, argArray));
    }

    public void warn(String msg, Throwable t) {
        Log.w((String)this.name, (String)msg, (Throwable)t);
    }

    public boolean isErrorEnabled() {
        return Log.isLoggable((String)this.name, (int)6);
    }

    public void error(String msg) {
        Log.e((String)this.name, (String)msg);
    }

    public void error(String format, Object arg) {
        Log.e((String)this.name, (String)this.format(format, arg, null));
    }

    public void error(String format, Object arg1, Object arg2) {
        Log.e((String)this.name, (String)this.format(format, arg1, arg2));
    }

    public void error(String format, Object[] argArray) {
        Log.e((String)this.name, (String)this.format(format, argArray));
    }

    public void error(String msg, Throwable t) {
        Log.e((String)this.name, (String)msg, (Throwable)t);
    }

    private String format(String format, Object arg1, Object arg2) {
        return MessageFormatter.format((String)format, (Object)arg1, (Object)arg2).getMessage();
    }

    private String format(String format, Object[] args) {
        return MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage();
    }
}

