/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.core.logging.implementation;

import android.os.Build;
import java.util.StringTokenizer;

public final class LogUtils {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final int TAG_MAX_LENGTH = 23;

    private LogUtils() {
    }

    public static String ensureValidLoggerName(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() > 23 && Build.VERSION.SDK_INT <= 25) {
            StringTokenizer st = new StringTokenizer(name, ".");
            if (st.hasMoreTokens()) {
                StringBuilder sb = new StringBuilder();
                do {
                    String token;
                    if ((token = st.nextToken()).length() == 1) {
                        sb.append(token);
                        sb.append('.');
                        continue;
                    }
                    if (st.hasMoreTokens()) {
                        sb.append(token.charAt(0));
                        sb.append("*.");
                        continue;
                    }
                    sb.append(token);
                } while (st.hasMoreTokens());
                name = sb.toString();
            }
            if (name.length() > 23) {
                name = name.substring(0, 22) + '*';
            }
        }
        return name;
    }

    public static String removeNewLinesFromLogMessage(String logMessage) {
        if (logMessage == null || logMessage.isEmpty()) {
            return logMessage;
        }
        StringBuilder sb = null;
        int prevStart = 0;
        for (int i = 0; i < logMessage.length(); ++i) {
            if (logMessage.charAt(i) != '\r' && logMessage.charAt(i) != '\n') continue;
            if (sb == null) {
                sb = new StringBuilder(logMessage.length());
            }
            if (prevStart != i) {
                sb.append(logMessage, prevStart, i);
            }
            prevStart = i + 1;
        }
        if (sb == null) {
            return logMessage;
        }
        sb.append(logMessage, prevStart, logMessage.length());
        return sb.toString();
    }
}

