/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.core.logging;

import com.azure.android.core.logging.LogLevel;
import com.azure.android.core.logging.implementation.DefaultLogger;
import com.azure.android.core.logging.implementation.LogUtils;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class ClientLogger {
    private static final String LINE_SEPARATOR;
    private final Logger logger;

    public ClientLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public ClientLogger(String className) {
        Logger initLogger = LoggerFactory.getLogger((String)className);
        this.logger = initLogger instanceof NOPLogger ? new DefaultLogger(className) : initLogger;
    }

    public void verbose(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(LogUtils.removeNewLinesFromLogMessage(message));
        }
    }

    public void verbose(String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.performLogging(LogLevel.VERBOSE, false, format, args);
        }
    }

    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(LogUtils.removeNewLinesFromLogMessage(message));
        }
    }

    public void info(String format, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.performLogging(LogLevel.INFORMATIONAL, false, format, args);
        }
    }

    public void warning(String message) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(LogUtils.removeNewLinesFromLogMessage(message));
        }
    }

    public void warning(String format, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            this.performLogging(LogLevel.WARNING, false, format, args);
        }
    }

    public void error(String message) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(LogUtils.removeNewLinesFromLogMessage(message));
        }
    }

    public void error(String format, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            this.performLogging(LogLevel.ERROR, false, format, args);
        }
    }

    public RuntimeException logExceptionAsWarning(RuntimeException runtimeException) {
        ClientLogger.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        return this.logThrowableAsWarning(runtimeException);
    }

    public <T extends Throwable> T logThrowableAsWarning(T throwable) {
        ClientLogger.requireNonNull(throwable, "'throwable' cannot be null.");
        if (!this.logger.isWarnEnabled()) {
            return throwable;
        }
        this.performLogging(LogLevel.WARNING, true, throwable.getMessage(), throwable);
        return throwable;
    }

    public RuntimeException logExceptionAsError(RuntimeException runtimeException) {
        ClientLogger.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        return this.logThrowableAsError(runtimeException);
    }

    public <T extends Throwable> T logThrowableAsError(T throwable) {
        ClientLogger.requireNonNull(throwable, "'throwable' cannot be null.");
        if (!this.logger.isErrorEnabled()) {
            return throwable;
        }
        this.performLogging(LogLevel.ERROR, true, throwable.getMessage(), throwable);
        return throwable;
    }

    private void performLogging(LogLevel logLevel, boolean isExceptionLogging, String format, Object ... args) {
        String throwableMessage = "";
        if (this.doesArgsHaveThrowable(args)) {
            Object throwable;
            if (!isExceptionLogging && (throwable = args[args.length - 1]) instanceof Throwable) {
                throwableMessage = ((Throwable)throwable).getMessage();
            }
            if (!this.logger.isDebugEnabled()) {
                args = this.removeThrowable(args);
            }
        }
        format = LogUtils.removeNewLinesFromLogMessage(format);
        switch (logLevel) {
            case VERBOSE: {
                this.logger.debug(format, args);
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(format, args);
                break;
            }
            case WARNING: {
                if (throwableMessage != null && throwableMessage.length() != 0) {
                    format = format + LINE_SEPARATOR + throwableMessage;
                }
                this.logger.warn(format, args);
                break;
            }
            case ERROR: {
                if (throwableMessage != null && throwableMessage.length() != 0) {
                    format = format + LINE_SEPARATOR + throwableMessage;
                }
                this.logger.error(format, args);
                break;
            }
        }
    }

    public boolean canLogAtLevel(LogLevel logLevel) {
        if (logLevel == null) {
            return false;
        }
        switch (logLevel) {
            case VERBOSE: {
                return this.logger.isDebugEnabled();
            }
            case INFORMATIONAL: {
                return this.logger.isInfoEnabled();
            }
            case WARNING: {
                return this.logger.isWarnEnabled();
            }
            case ERROR: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    private boolean doesArgsHaveThrowable(Object ... args) {
        if (args.length == 0) {
            return false;
        }
        return args[args.length - 1] instanceof Throwable;
    }

    private Object[] removeThrowable(Object ... args) {
        return Arrays.copyOf(args, args.length - 1);
    }

    private static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    static {
        String lineSeparator = System.getProperty("line.separator");
        LINE_SEPARATOR = lineSeparator == null || lineSeparator.length() == 0 ? lineSeparator : "\n";
    }
}

