/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.common;

import com.azure.android.communication.common.CommunicationCloudEnvironment;
import com.azure.android.communication.common.CommunicationUserIdentifier;
import com.azure.android.communication.common.MicrosoftTeamsUserIdentifier;
import com.azure.android.communication.common.PhoneNumberIdentifier;
import com.azure.android.communication.common.UnknownIdentifier;

public abstract class CommunicationIdentifier {
    private String rawId;

    public static CommunicationIdentifier fromRawId(String rawId) {
        if (rawId == null || rawId.trim().length() == 0) {
            throw new IllegalArgumentException("The parameter [rawId] cannot be null to empty.");
        }
        if (rawId.startsWith("4:")) {
            return new PhoneNumberIdentifier(rawId.substring("4:".length()));
        }
        String[] segments = rawId.split(":");
        if (segments.length < 3) {
            return new UnknownIdentifier(rawId);
        }
        String prefix = segments[0] + ":" + segments[1] + ":";
        String suffix = rawId.substring(prefix.length());
        if ("8:teamsvisitor:".equals(prefix)) {
            return new MicrosoftTeamsUserIdentifier(suffix, true);
        }
        if ("8:orgid:".equals(prefix)) {
            return new MicrosoftTeamsUserIdentifier(suffix, false);
        }
        if ("8:dod:".equals(prefix)) {
            return new MicrosoftTeamsUserIdentifier(suffix, false).setCloudEnvironment(CommunicationCloudEnvironment.DOD);
        }
        if ("8:gcch:".equals(prefix)) {
            return new MicrosoftTeamsUserIdentifier(suffix, false).setCloudEnvironment(CommunicationCloudEnvironment.GCCH);
        }
        if ("8:acs:".equals(prefix) || "8:spool:".equals(prefix) || "8:dod-acs:".equals(prefix) || "8:gcch-acs:".equals(prefix)) {
            return new CommunicationUserIdentifier(rawId);
        }
        return new UnknownIdentifier(rawId);
    }

    public String getRawId() {
        return this.rawId;
    }

    protected CommunicationIdentifier setRawId(String rawId) {
        this.rawId = rawId;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof CommunicationIdentifier)) {
            return false;
        }
        CommunicationIdentifier thatId = (CommunicationIdentifier)that;
        return this.getRawId().equals(thatId.getRawId());
    }

    public int hashCode() {
        return this.getRawId().hashCode();
    }
}

