/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;
import com.azure.android.communication.calling.VideoStreamPixelFormat;
import com.azure.android.communication.calling.VideoStreamResolution;

public final class VideoStreamFormat {
    long handle;

    VideoStreamFormat(long ahandle, boolean transfer) {
        this.handle = ahandle;
        if (!transfer) {
            NativeLibrary.sam_video_stream_format_addref(ahandle);
        }
        ProjectedObjectCache.add(this, this.handle);
    }

    long getHandle() {
        return this.handle;
    }

    public VideoStreamFormat() {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_video_stream_format_create(result_handle);
        this.handle = (Long)result_handle.value;
        NativeLibraryHelpers.checkStatus(this.handle, resultStatus);
        ProjectedObjectCache.add(this, this.handle);
    }

    protected void finalize() {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_release(this.handle));
        this.handle = 0L;
    }

    public int getWidth() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_get_width(this.handle, result));
        return (Integer)result.value;
    }

    public VideoStreamFormat setWidth(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_set_width(this.handle, value));
        return this;
    }

    public int getHeight() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_get_height(this.handle, result));
        return (Integer)result.value;
    }

    public VideoStreamFormat setHeight(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_set_height(this.handle, value));
        return this;
    }

    public VideoStreamResolution getResolution() {
        Out<VideoStreamResolution> result = new Out<VideoStreamResolution>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_get_resolution(this.handle, result));
        return (VideoStreamResolution)((Object)result.value);
    }

    public VideoStreamFormat setResolution(VideoStreamResolution value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_set_resolution(this.handle, value));
        return this;
    }

    public VideoStreamPixelFormat getPixelFormat() {
        Out<VideoStreamPixelFormat> result = new Out<VideoStreamPixelFormat>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_get_pixel_format(this.handle, result));
        return (VideoStreamPixelFormat)((Object)result.value);
    }

    public VideoStreamFormat setPixelFormat(VideoStreamPixelFormat value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_set_pixel_format(this.handle, value));
        return this;
    }

    public float getFramesPerSecond() {
        Out<Float> result = new Out<Float>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_get_frames_per_second(this.handle, result));
        return ((Float)result.value).floatValue();
    }

    public VideoStreamFormat setFramesPerSecond(float value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_set_frames_per_second(this.handle, value));
        return this;
    }

    public int getStride1() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_get_stride1(this.handle, result));
        return (Integer)result.value;
    }

    public VideoStreamFormat setStride1(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_set_stride1(this.handle, value));
        return this;
    }

    public int getStride2() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_get_stride2(this.handle, result));
        return (Integer)result.value;
    }

    public VideoStreamFormat setStride2(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_set_stride2(this.handle, value));
        return this;
    }

    public int getStride3() {
        Out<Integer> result = new Out<Integer>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_get_stride3(this.handle, result));
        return (Integer)result.value;
    }

    public VideoStreamFormat setStride3(int value) {
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_video_stream_format_set_stride3(this.handle, value));
        return this;
    }

    static VideoStreamFormat getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoStreamFormat, VideoStreamFormat.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_video_stream_format_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.VideoStreamFormat, VideoStreamFormat.class, false);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

