/*
 * Decompiled with CFR 0.152.
 */
package com.azure.android.communication.calling;

import com.azure.android.communication.calling.CallClient;
import com.azure.android.communication.calling.JoinTeamsMeetingLocator;
import com.azure.android.communication.calling.ModelClass;
import com.azure.android.communication.calling.NativeLibrary;
import com.azure.android.communication.calling.NativeLibraryHelpers;
import com.azure.android.communication.calling.Out;
import com.azure.android.communication.calling.ProjectedObjectCache;
import com.azure.android.communication.calling.ProjectedObjectCacheListener;
import com.azure.android.communication.calling.Status;

public final class TeamsMeetingLinkLocator
extends JoinTeamsMeetingLocator {
    TeamsMeetingLinkLocator(long ahandle, boolean transfer) {
        super(ahandle, transfer);
    }

    @Override
    long getHandle() {
        return this.handle;
    }

    static long Create(String meetingLink) {
        Out<Long> result_handle = new Out<Long>();
        Status resultStatus = NativeLibrary.sam_teams_meeting_link_locator_create_string_meeting_link(meetingLink, result_handle);
        NativeLibraryHelpers.checkStatus((Long)result_handle.value, resultStatus);
        return (Long)result_handle.value;
    }

    public TeamsMeetingLinkLocator(String meetingLink) {
        super(TeamsMeetingLinkLocator.Create(meetingLink), true);
    }

    public String getMeetingLink() {
        Out<String> result = new Out<String>();
        NativeLibraryHelpers.checkStatus(this.handle, NativeLibrary.sam_teams_meeting_link_locator_get_meeting_link(this.handle, result));
        return (String)result.value;
    }

    static TeamsMeetingLinkLocator getInstance(final long cookie, boolean transfer) {
        if (transfer) {
            return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsMeetingLinkLocator, TeamsMeetingLinkLocator.class, true, new ProjectedObjectCacheListener(){

                @Override
                public void onCacheHit() {
                    NativeLibrary.sam_join_meeting_locator_release(cookie);
                }
            });
        }
        return ProjectedObjectCache.getOrCreate(cookie, ModelClass.TeamsMeetingLinkLocator, TeamsMeetingLinkLocator.class, false);
    }

    static {
        CallClient.loadNativeLibraries();
    }
}

